/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor.remote_lens;

import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.util.TextUtils;
import com.simibubi.create.AllSoundEvents;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class RemoteLensItem
extends Item {
    public RemoteLensItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = customData.copyTag();
        if (tag.hasUUID("SelectedConductor")) {
            UUID conductorId = tag.getUUID("SelectedConductor");
            tooltip.add((Component)Component.translatable((String)"railways.whistle.tool.bound").withStyle(ChatFormatting.DARK_GREEN));
            tooltip.add(TextUtils.translateWithFormatting("railways.whistle.tool.conductor_id", conductorId.toString().substring(0, 5)));
            tooltip.add((Component)Component.translatable((String)"railways.remote_lens.tool.bound_usage"));
        } else {
            tooltip.add((Component)Component.translatable((String)"railways.remote_lens.tool.not_bound").withStyle(ChatFormatting.DARK_RED));
        }
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack pStack, @NotNull Player pPlayer, @NotNull LivingEntity pInteractionTarget, @NotNull InteractionHand pUsedHand) {
        ConductorEntity conductor;
        if (pPlayer.level().isClientSide) {
            return InteractionResult.CONSUME;
        }
        if (pInteractionTarget instanceof ConductorEntity && (conductor = (ConductorEntity)pInteractionTarget).getJob() == ConductorEntity.Job.SPY) {
            CustomData customData = (CustomData)pStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            CompoundTag stackTag = customData.copyTag();
            stackTag.putUUID("SelectedConductor", conductor.getUUID());
            pPlayer.displayClientMessage((Component)Component.translatable((String)"railways.remote_lens.set"), true);
            pStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)stackTag));
            pPlayer.setItemInHand(pUsedHand, pStack);
            AllSoundEvents.PECULIAR_BELL_USE.play(pPlayer.level(), null, conductor.getX(), conductor.getY(), conductor.getZ(), 0.5f, 1.1f);
            return InteractionResult.SUCCESS;
        }
        return super.interactLivingEntity(pStack, pPlayer, pInteractionTarget, pUsedHand);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        if (context.getPlayer() == null) {
            return InteractionResult.FAIL;
        }
        return this.use(context.getLevel(), context.getPlayer(), context.getHand()).getResult();
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ConductorEntity conductor;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
                CompoundTag stackTag = customData.copyTag();
                if (!stackTag.hasUUID("SelectedConductor")) {
                    return InteractionResultHolder.fail((Object)stack);
                }
                UUID conductorId = stackTag.getUUID("SelectedConductor");
                if (player.isShiftKeyDown()) {
                    stackTag.remove("SelectedConductor");
                    stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)stackTag));
                    AllSoundEvents.CONTROLLER_CLICK.play(level, null, (Vec3i)player.blockPosition(), 0.5f, 1.1f);
                    player.displayClientMessage((Component)Component.translatable((String)"railways.remote_lens.clear"), true);
                    return InteractionResultHolder.success((Object)stack);
                }
                Entity entity = serverLevel.getEntity(conductorId);
                if (entity instanceof ConductorEntity && (conductor = (ConductorEntity)entity).getJob() == ConductorEntity.Job.SPY) {
                    return conductor.startViewing(serverPlayer) ? InteractionResultHolder.success((Object)stack) : InteractionResultHolder.fail((Object)stack);
                }
                return InteractionResultHolder.fail((Object)stack);
            }
        }
        return InteractionResultHolder.success((Object)stack);
    }
}

