/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.conductor.ConductorCapItem;
import com.railwayteam.railways.content.conductor.ConductorCapLayer;
import com.railwayteam.railways.content.conductor.ConductorElytraLayer;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.ConductorEntityModel;
import com.railwayteam.railways.content.conductor.ConductorFlagLayer;
import com.railwayteam.railways.content.conductor.ConductorRemoteLayer;
import com.railwayteam.railways.content.conductor.ConductorSecondaryHeadLayer;
import com.railwayteam.railways.content.conductor.ConductorToolboxLayer;
import com.railwayteam.railways.mixin.client.AccessorLivingEntityRenderer;
import com.railwayteam.railways.registry.CRBlockPartials;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ConductorRenderer
extends MobRenderer<ConductorEntity, ConductorEntityModel<ConductorEntity>> {
    public static final ResourceLocation TEXTURE = Railways.asResource("textures/entity/conductor.png");

    public ConductorRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, new ConductorEntityModel(ctx.bakeLayer(ConductorEntityModel.LAYER_LOCATION)), 0.2f);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new ConductorEntityModel(ctx.bakeLayer(ModelLayers.ARMOR_STAND_INNER_ARMOR)), new ConductorEntityModel(ctx.bakeLayer(ModelLayers.ARMOR_STAND_OUTER_ARMOR)), ctx.getModelManager()));
        this.addLayer(new ConductorCapLayer(this));
        this.addLayer(new ConductorSecondaryHeadLayer(this, ctx.getModelSet(), ctx.getItemInHandRenderer()));
        this.addLayer(new ConductorToolboxLayer(this));
        this.addLayer(new ConductorFlagLayer(this));
        this.addLayer(new ConductorRemoteLayer(this));
        this.addLayer((RenderLayer)new ConductorElytraLayer(this, ctx.getModelSet()));
    }

    private ResourceLocation ensurePng(ResourceLocation loc) {
        if (loc.getPath().endsWith(".png")) {
            return loc;
        }
        return ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)(loc.getPath() + ".png"));
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull ConductorEntity conductor) {
        ItemStack headItem = conductor.getItemBySlot(EquipmentSlot.HEAD);
        String name = headItem.getHoverName().getString();
        if (name.startsWith("[sus]")) {
            name = name.substring(5);
        }
        if (!headItem.isEmpty() && headItem.getItem() instanceof ConductorCapItem && CRBlockPartials.CUSTOM_CONDUCTOR_SKINS.containsKey(name)) {
            return this.ensurePng(CRBlockPartials.CUSTOM_CONDUCTOR_SKINS.get(name));
        }
        if (conductor.getCustomName() != null && CRBlockPartials.CUSTOM_CONDUCTOR_SKINS_FOR_NAME.containsKey(conductor.getCustomName().getString())) {
            return this.ensurePng(CRBlockPartials.CUSTOM_CONDUCTOR_SKINS_FOR_NAME.get(conductor.getCustomName().getString()));
        }
        return TEXTURE;
    }

    public void render(ConductorEntity entity, float f1, float f2, PoseStack stack, MultiBufferSource source, int i1) {
        super.render((LivingEntity)entity, f1, f2, stack, source, i1);
    }

    protected void setupRotations(ConductorEntity entityLiving, PoseStack matrixStack, float ageInTicks, float rotationYaw, float partialTicks, float scale) {
        EntityRenderer renderer;
        if (entityLiving.visualBaseEntity != null && (renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)entityLiving.visualBaseEntity)) instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
            ((AccessorLivingEntityRenderer)livingRenderer).callSetupRotations(entityLiving.visualBaseEntity, matrixStack, ageInTicks, rotationYaw, partialTicks, entityLiving.getScale());
            return;
        }
        super.setupRotations((LivingEntity)entityLiving, matrixStack, ageInTicks, rotationYaw, partialTicks, scale);
    }
}

