/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor;

import com.google.common.collect.ImmutableMap;
import com.mojang.authlib.GameProfile;
import com.railwayteam.railways.content.conductor.ClientHandler;
import com.railwayteam.railways.content.conductor.ConductorCapItem;
import com.railwayteam.railways.content.conductor.ConductorPossessionController;
import com.railwayteam.railways.content.conductor.toolbox.MountedToolbox;
import com.railwayteam.railways.content.conductor.vent.VentBlock;
import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.railwayteam.railways.mixin.conductor_possession.ServerPlayerAccessor;
import com.railwayteam.railways.multiloader.S2CPacket;
import com.railwayteam.railways.registry.CREntities;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.registry.CRTags;
import com.railwayteam.railways.util.EntityUtils;
import com.railwayteam.railways.util.ItemUtils;
import com.railwayteam.railways.util.Utils;
import com.railwayteam.railways.util.packet.CameraMovePacket;
import com.railwayteam.railways.util.packet.SetCameraViewPacket;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.equipment.toolbox.ToolboxBlock;
import com.simibubi.create.content.redstone.link.IRedstoneLinkable;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.simibubi.create.content.redstone.link.controller.LinkedControllerItem;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.data.WorldAttached;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ConductorEntity
extends AbstractGolem {
    public static final GameProfile FAKE_PLAYER_PROFILE = new GameProfile(UUID.fromString("B0FADEE5-4411-3475-ADD0-C4EA7E30D050"), "[Conductor]");
    private final FrequencyHolder frequencies = new FrequencyHolder();
    public static final WorldAttached<Set<ConductorEntity>> WITH_TOOLBOXES = new WorldAttached(w -> new HashSet());
    public static final EntityDataAccessor<Byte> COLOR = SynchedEntityData.defineId(ConductorEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final EntityDataAccessor<BlockPos> BLOCK = SynchedEntityData.defineId(ConductorEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    public static final EntityDataAccessor<Integer> JOB = SynchedEntityData.defineId(ConductorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> HOLDING_SCHEDULES = SynchedEntityData.defineId(ConductorEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final Map<String, Couple<EntityDataAccessor<ItemStack>>> FREQUENCY_DATA = new HashMap<String, Couple<EntityDataAccessor<ItemStack>>>();
    private static final Vec3i REACH;
    private ServerPlayer fakePlayer = null;
    MountedToolbox toolbox = null;
    private List<ItemStack> heldSchedules;
    public double firstGoodX;
    public double firstGoodY;
    public double firstGoodZ;
    public double lastGoodX;
    public double lastGoodY;
    public double lastGoodZ;
    public int receivedMovePacketCount;
    public int knownMovePacketCount;
    public double xLast;
    public double yLast;
    public double zLast;
    public double xRotLast;
    public double yRotLast;
    public int ventCooldown = 0;
    public static final List<Player> RECENTLY_DISMOUNTED_PLAYERS;
    @NotNull
    private WeakReference<ServerPlayer> currentlyViewing = new WeakReference<Object>(null);
    private int initialChunkLoadingDistance = 0;
    private boolean hasSentChunks = false;
    public SectionPos oldSectionPos = null;
    public float oBob;
    public float bob;
    @OnlyIn(value=Dist.CLIENT)
    public PlayerModel<?> visualBaseModel;
    @OnlyIn(value=Dist.CLIENT)
    public Player visualBaseEntity;
    private boolean rotateAnyway = false;
    private Float flyingSpeedOverride = null;
    protected FrequencyListener forwardListener;
    protected FrequencyListener backwardListener;
    protected FrequencyListener leftListener;
    protected FrequencyListener rightListener;
    protected FrequencyListener jumpListener;
    protected FrequencyListener sneakListener;

    public static boolean isPlayerDisguised(Player player) {
        if (player.getInventory() == null) {
            return false;
        }
        ItemStack headStack = player.getItemBySlot(EquipmentSlot.HEAD);
        if (headStack.isEmpty()) {
            return false;
        }
        if (!CRTags.AllItemTags.CONDUCTOR_CAPS.matches(headStack)) {
            return false;
        }
        String hoverName = headStack.getHoverName().getString();
        return hoverName.startsWith("[sus]") || hoverName.equals("sus");
    }

    public static boolean canSpyInteract(BlockState blockState) {
        Block block = blockState.getBlock();
        return blockState.is(BlockTags.BUTTONS) || blockState.is(BlockTags.TRAPDOORS) || block instanceof LeverBlock || block instanceof VentBlock || CRTags.AllBlockTags.CONDUCTOR_SPY_USABLE.matches(blockState);
    }

    public ItemStack getSecondaryHeadStack() {
        return ItemStack.EMPTY;
    }

    private void resetPosition() {
        this.firstGoodX = this.lastGoodX = this.getX();
        this.firstGoodY = this.lastGoodY = this.getY();
        this.firstGoodZ = this.lastGoodZ = this.getZ();
        this.knownMovePacketCount = this.receivedMovePacketCount;
    }

    public void doCheckFallDamage(double y, boolean onGround) {
        if (this.touchingUnloadedChunk()) {
            return;
        }
        BlockPos blockPos = this.getOnPos();
        super.checkFallDamage(y, onGround, this.level().getBlockState(blockPos), blockPos);
    }

    public void jumpFromGround() {
        super.jumpFromGround();
    }

    public void teleportToForce(double x, double y, double z) {
        ServerPlayer player;
        this.absMoveTo(x, y, z, this.getYRot(), this.getXRot());
        this.getSelfAndPassengers().forEach(entity -> {
            for (Entity entity2 : entity.getPassengers()) {
                entity.positionRider(entity2);
            }
        });
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, new ChunkPos(this.blockPosition()), 5, (Object)this.getId());
        }
        this.firstGoodX = x;
        this.firstGoodY = y;
        this.firstGoodZ = z;
        this.lastGoodX = x;
        this.lastGoodY = y;
        this.lastGoodZ = z;
        if (this.isPossessed() && (player = (ServerPlayer)this.currentlyViewing.get()) != null) {
            CRPackets.PACKETS.sendTo(player, (S2CPacket)new CameraMovePacket(this, new ServerboundMovePlayerPacket.PosRot(x, y, z, this.getYRot(), this.getXRot(), this.onGround())));
        }
    }

    public void setChunkLoadingDistance(int chunkLoadingDistance) {
        this.initialChunkLoadingDistance = chunkLoadingDistance;
    }

    public boolean hasSentChunks() {
        return this.hasSentChunks;
    }

    public void setHasSentChunks(boolean hasSentChunks) {
        this.hasSentChunks = hasSentChunks;
    }

    public static boolean hasRecentlyDismounted(Player player) {
        return RECENTLY_DISMOUNTED_PLAYERS.remove(player);
    }

    public boolean startViewing(ServerPlayer player) {
        ServerPlayer current = (ServerPlayer)this.currentlyViewing.get();
        if (current != null && current.getCamera() == this && current.isAlive() && current != player) {
            return false;
        }
        ServerLevel serverLevel = player.serverLevel();
        if (serverLevel != this.getCommandSenderWorld()) {
            return false;
        }
        this.currentlyViewing = new WeakReference<ServerPlayer>(player);
        this.oldSectionPos = null;
        SectionPos chunkPos = SectionPos.of((BlockPos)this.blockPosition());
        int viewDistance = player.server.getPlayerList().getViewDistance();
        Entity entity = player.getCamera();
        if (entity instanceof ConductorEntity) {
            ConductorEntity conductor = (ConductorEntity)entity;
            conductor.stopViewing(player);
        }
        this.setChunkLoadingDistance(viewDistance);
        ((ServerPlayerAccessor)player).setCamera((Entity)this);
        CRPackets.PACKETS.sendTo(player, (S2CPacket)new SetCameraViewPacket((Entity)this));
        this.resetPosition();
        return true;
    }

    public void stopViewing(ServerPlayer player) {
        if (!this.level().isClientSide) {
            this.currentlyViewing.clear();
            ((ServerPlayerAccessor)player).setCamera((Entity)player);
            CRPackets.PACKETS.sendTo(player, (S2CPacket)new SetCameraViewPacket((Entity)player));
            RECENTLY_DISMOUNTED_PLAYERS.add((Player)player);
        }
    }

    public void onSpyInteract(BlockPos pos) {
        BlockState state;
        if (this.canReach((Vec3i)pos) && ConductorEntity.canSpyInteract(state = this.level().getBlockState(pos)) && this.fakePlayer != null) {
            boolean canUse;
            ClipContext context = new ClipContext(this.getEyePosition(), new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.fakePlayer);
            BlockHitResult hitResult = this.level().clip(context);
            if (!pos.equals((Object)hitResult.getBlockPos())) {
                return;
            }
            boolean bl = canUse = state.getShape((BlockGetter)this.level(), pos).isEmpty() || EntityUtils.handleUseEvent((Player)this.fakePlayer, InteractionHand.MAIN_HAND, hitResult);
            if (canUse) {
                Block block = state.getBlock();
                if (block instanceof VentBlock) {
                    VentBlock ventBlock = (VentBlock)block;
                    ventBlock.teleportConductor(this.level(), pos, (Entity)this, hitResult.getDirection().getOpposite());
                } else {
                    state.useWithoutItem(this.level(), (Player)this.fakePlayer, hitResult);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getViewXRot(float partialTicks) {
        if (ClientHandler.isPossessed(this)) {
            return this.getXRot();
        }
        return super.getViewXRot(partialTicks);
    }

    public boolean isCrouching() {
        return this.level().isClientSide ? (this.visualBaseEntity != null ? this.visualBaseEntity.isCrouching() : super.isCrouching()) : super.isCrouching();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setSharedFlag(int flag, boolean set) {
        super.setSharedFlag(flag, set);
    }

    public boolean isPossessed() {
        return this.level().isClientSide ? ClientHandler.isPossessed(this) : this.currentlyViewing.get() != null;
    }

    public boolean isPossessedAndClient() {
        return this.level().isClientSide && this.isPossessed();
    }

    public void turnView(double yRot, double xRot) {
        float f = (float)xRot * 0.15f;
        float g = (float)yRot * 0.15f;
        this.rotateAnyway = true;
        this.setXRot(this.getXRot() + f);
        this.setYRot(this.getYRot() + g);
        this.rotateAnyway = true;
        this.setXRot(Mth.clamp((float)this.getXRot(), (float)-90.0f, (float)90.0f));
        this.xRotO += f;
        this.yRotO += g;
        this.xRotO = Mth.clamp((float)this.xRotO, (float)-90.0f, (float)90.0f);
        if (this.getVehicle() != null) {
            this.getVehicle().onPassengerTurned((Entity)this);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getViewYRot(float partialTick) {
        return this.isPassenger() || !this.isPossessed() ? super.getViewYRot(partialTick) : this.getYRot();
    }

    private boolean consumeRotateAnyway() {
        if (this.rotateAnyway) {
            this.rotateAnyway = false;
            return true;
        }
        return false;
    }

    public void setXRot(float xRot) {
        if (this.isPossessedAndClient() && !this.consumeRotateAnyway()) {
            return;
        }
        super.setXRot(xRot);
    }

    protected boolean isHorizontalCollisionMinor(@NotNull Vec3 deltaMovement) {
        if (!this.isPossessedAndClient()) {
            return super.isHorizontalCollisionMinor(deltaMovement);
        }
        float f = this.getYRot() * ((float)Math.PI / 180);
        double d0 = Mth.sin((float)f);
        double d1 = Mth.cos((float)f);
        double d2 = (double)this.xxa * d1 - (double)this.zza * d0;
        double d3 = (double)this.zza * d1 + (double)this.xxa * d0;
        double d4 = Mth.square((double)d2) + Mth.square((double)d3);
        double d5 = Mth.square((double)deltaMovement.x) + Mth.square((double)deltaMovement.z);
        if (!(d4 < (double)1.0E-5f) && !(d5 < (double)1.0E-5f)) {
            double d6 = d2 * deltaMovement.x + d3 * deltaMovement.z;
            double d7 = Math.acos(d6 / Math.sqrt(d4 * d5));
            return d7 < 0.13962633907794952;
        }
        return false;
    }

    public void updatePossessionInputs() {
        if (this.isPossessedAndClient()) {
            this._updatePossessionInputs();
        }
    }

    private static float calculateImpulse(boolean input, boolean otherInput) {
        if (input == otherInput) {
            return 0.0f;
        }
        return input ? 1.0f : -1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void _updatePossessionInputs() {
        this.setSpeed((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED));
        this.zza = ConductorEntity.calculateImpulse(ConductorPossessionController.wasUpPressed(), ConductorPossessionController.wasDownPressed());
        this.xxa = ConductorEntity.calculateImpulse(ConductorPossessionController.wasLeftPressed(), ConductorPossessionController.wasRightPressed());
        if (!ConductorPossessionController.wasSprintPressed()) {
            this.zza *= 0.3f;
            this.xxa *= 0.3f;
        }
        this.jumping = ConductorPossessionController.wasJumpPressed();
        this.flyingSpeedOverride = Float.valueOf(0.2f);
        if (ConductorPossessionController.wasSprintPressed()) {
            this.flyingSpeedOverride = Float.valueOf(this.flyingSpeedOverride.floatValue() + 0.006f);
        }
    }

    protected float getFlyingSpeed() {
        return this.flyingSpeedOverride == null ? super.getFlyingSpeed() : this.flyingSpeedOverride.floatValue();
    }

    public void push(@NotNull Entity entity) {
        if (ConductorPossessionController.getPossessingConductor(entity) == this) {
            return;
        }
        super.push(entity);
    }

    public boolean isPushable() {
        return super.isPushable() && !this.isPossessed();
    }

    public boolean isControlledByLocalInstance() {
        return super.isControlledByLocalInstance() || this.isPossessedAndClient();
    }

    private boolean suffocatesAt(BlockPos pos) {
        AABB aabb = this.getBoundingBox();
        AABB aabb1 = new AABB((double)pos.getX(), aabb.minY, (double)pos.getZ(), (double)pos.getX() + 1.0, aabb.maxY, (double)pos.getZ() + 1.0).deflate(1.0E-7);
        return this.level().collidesWithSuffocatingBlock((Entity)this, aabb1);
    }

    private void moveTowardsClosestSpace(double x, double z) {
        BlockPos blockpos = BlockPos.containing((double)x, (double)this.getY(), (double)z);
        if (this.suffocatesAt(blockpos)) {
            double d0 = x - (double)blockpos.getX();
            double d1 = z - (double)blockpos.getZ();
            Direction direction = null;
            double d2 = Double.MAX_VALUE;
            Direction[] adirection = new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH};
            for (Direction direction1 : adirection) {
                double d3 = direction1.getAxis().choose(d0, 0.0, d1);
                double d4 = direction1.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 1.0 - d3 : d3;
                double d = d4;
                if (!(d4 < d2) || this.suffocatesAt(blockpos.relative(direction1))) continue;
                d2 = d4;
                direction = direction1;
            }
            if (direction != null) {
                Vec3 vec3 = this.getDeltaMovement();
                if (direction.getAxis() == Direction.Axis.X) {
                    this.setDeltaMovement(0.1 * (double)direction.getStepX(), vec3.y, vec3.z);
                } else {
                    this.setDeltaMovement(vec3.x, vec3.y, 0.1 * (double)direction.getStepZ());
                }
            }
        }
    }

    public void aiStep() {
        if (this.isPossessedAndClient()) {
            this.oBob = this.bob;
            this.yHeadRot = this.getYRot();
            if (!this.noPhysics) {
                this.moveTowardsClosestSpace(this.getX() - (double)this.getBbWidth() * 0.35, this.getZ() + (double)this.getBbWidth() * 0.35);
                this.moveTowardsClosestSpace(this.getX() - (double)this.getBbWidth() * 0.35, this.getZ() - (double)this.getBbWidth() * 0.35);
                this.moveTowardsClosestSpace(this.getX() + (double)this.getBbWidth() * 0.35, this.getZ() - (double)this.getBbWidth() * 0.35);
                this.moveTowardsClosestSpace(this.getX() + (double)this.getBbWidth() * 0.35, this.getZ() + (double)this.getBbWidth() * 0.35);
            }
        }
        super.aiStep();
        if (this.isPossessedAndClient()) {
            float f = !this.onGround() || this.isDeadOrDying() || this.isSwimming() ? 0.0f : Math.min(0.1f, (float)this.getDeltaMovement().horizontalDistance());
            this.bob += (f - this.bob) * 0.4f;
        }
    }

    protected void updateFrequencyListeners() {
        this.forwardListener = new FrequencyListener("forward");
        this.backwardListener = new FrequencyListener("backward");
        this.leftListener = new FrequencyListener("left");
        this.rightListener = new FrequencyListener("right");
        this.jumpListener = new FrequencyListener("jump");
        this.sneakListener = new FrequencyListener("sneak");
    }

    public int getForwardSignalStrength() {
        if (this.forwardListener == null) {
            return 0;
        }
        return this.forwardListener.receivedStrength;
    }

    private List<ItemStack> getHeldSchedules() {
        if (this.heldSchedules == null) {
            this.heldSchedules = new ArrayList<ItemStack>();
        }
        return this.heldSchedules;
    }

    public ConductorEntity(EntityType<? extends AbstractGolem> type, Level level) {
        super(type, level);
    }

    public boolean isHoldingSchedules() {
        return !this.getHeldSchedules().isEmpty();
    }

    public boolean isHoldingSchedulesClient() {
        return (Boolean)this.entityData.get(HOLDING_SCHEDULES);
    }

    public void addSchedule(ItemStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        this.getHeldSchedules().add(stack.copy());
        this.entityData.set(HOLDING_SCHEDULES, (Object)true);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COLOR, (Object)ConductorEntity.idFrom(ConductorEntity.defaultColor()));
        builder.define(BLOCK, (Object)this.blockPosition());
        builder.define(JOB, (Object)Job.DEFAULT.ordinal());
        builder.define(HOLDING_SCHEDULES, (Object)this.isHoldingSchedules());
        for (Map.Entry<String, Couple<EntityDataAccessor<ItemStack>>> entry : FREQUENCY_DATA.entrySet()) {
            for (boolean first : Iterate.trueAndFalse) {
                builder.define((EntityDataAccessor)entry.getValue().get(first), (Object)ItemStack.EMPTY);
            }
        }
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, (Goal)new ConductorLookedAtGoal(this));
        this.goalSelector.addGoal(1, (Goal)new ConductorPonderBlockGoal(this));
        this.goalSelector.addGoal(1, (Goal)new FollowToolboxPlayerGoal(this, 1.25));
        this.goalSelector.addGoal(1, (Goal)new RemoteControlGoal(this, 1.25));
        this.goalSelector.addGoal(0, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f){

            public boolean canUse() {
                return super.canUse() && !ConductorEntity.this.isPossessed();
            }

            public boolean canContinueToUse() {
                return super.canContinueToUse() && !ConductorEntity.this.isPossessed();
            }
        });
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.ARMOR, 8.0).add(Attributes.ARMOR_TOUGHNESS, 8.0);
    }

    public void remove(@NotNull Entity.RemovalReason reason) {
        super.remove(reason);
        ((Set)WITH_TOOLBOXES.get((LevelAccessor)this.level())).remove((Object)this);
    }

    public void onClientRemoval() {
        ((Set)WITH_TOOLBOXES.get((LevelAccessor)this.level())).remove((Object)this);
    }

    public boolean hurt(@NotNull DamageSource pSource, float pAmount) {
        LivingEntity living;
        if (this.getRootVehicle() instanceof CarriageContraptionEntity) {
            return false;
        }
        Entity entity = pSource.getEntity();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).getMainHandItem().is((Item)AllItems.WRENCH.get())) {
            pAmount = 10.0f;
        }
        return super.hurt(pSource, pAmount);
    }

    protected int decreaseAirSupply(int pAir) {
        return pAir;
    }

    protected float getStandingEyeHeight(@NotNull Pose pPose, @NotNull EntityDimensions pDimensions) {
        return pDimensions.height() * 0.76f;
    }

    public boolean canReach(Vec3i pos) {
        return pos.distToCenterSqr((Position)this.position()) <= REACH.distSqr(Vec3i.ZERO);
    }

    public float maxUpStep() {
        return 0.5f;
    }

    protected boolean isToolbox(ItemStack stack) {
        BlockItem blockItem;
        Item item = stack.getItem();
        return item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof ToolboxBlock;
    }

    public boolean isCarryingToolbox() {
        return this.toolbox != null;
    }

    public ItemStack getToolboxDisplayStack() {
        if (this.isCarryingToolbox()) {
            return this.toolbox.getDisplayStack();
        }
        return ItemStack.EMPTY;
    }

    protected void setToolbox(@Nullable MountedToolbox toolbox) {
        this.toolbox = toolbox;
        if (toolbox != null) {
            ((Set)WITH_TOOLBOXES.get((LevelAccessor)this.level())).add(this);
        } else {
            ((Set)WITH_TOOLBOXES.get((LevelAccessor)this.level())).remove((Object)this);
        }
    }

    @Nullable
    public MountedToolbox getToolbox() {
        return this.toolbox;
    }

    @NotNull
    public MountedToolbox getOrCreateToolboxHolder() {
        if (!this.isCarryingToolbox()) {
            this.setToolbox(new MountedToolbox(this, DyeColor.BROWN));
        }
        return this.toolbox;
    }

    public void equipToolbox(ItemStack stack) {
        BlockItem blockItem;
        Item item = stack.getItem();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof ToolboxBlock) {
            ToolboxBlock toolbox = (ToolboxBlock)item;
            this.setToolbox(new MountedToolbox(this, toolbox.getColor()));
            this.toolbox.readFromItem(stack);
            this.toolbox.sendData();
            this.setJob(Job.TOOLBOX_CARRIER);
        }
    }

    public void setJob(Job job) {
        this.getEntityData().set(JOB, (Object)job.ordinal());
    }

    public Job getJob() {
        return Job.values()[(Integer)this.getEntityData().get(JOB)];
    }

    public void startSeenByPlayer(@NotNull ServerPlayer pServerPlayer) {
        super.startSeenByPlayer(pServerPlayer);
        if (this.toolbox != null) {
            this.toolbox.sendData();
        }
    }

    public ItemStack unequipToolbox() {
        this.setJob(Job.DEFAULT);
        if (this.level().isClientSide || this.toolbox == null) {
            if (this.toolbox != null) {
                this.toolbox.setRemoved();
            }
            this.setToolbox(null);
            return ItemStack.EMPTY;
        }
        this.toolbox.unequipTracked();
        ItemStack itemStack = this.toolbox.getCloneItemStack();
        this.toolbox.setRemoved();
        this.setToolbox(null);
        return itemStack;
    }

    protected void openToolbox(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MountedToolbox.openMenu(serverPlayer, this.toolbox);
        }
    }

    @NotNull
    protected InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        Item item = player.getItemInHand(hand).getItem();
        if (item instanceof DyeItem) {
            DyeItem di = (DyeItem)item;
            this.setColor(di.getDyeColor());
            if (!player.isCreative()) {
                player.getItemInHand(hand).shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.getItemInHand(hand).getItem().equals(AllBlocks.ANDESITE_CASING.asStack().getItem())) {
            if (this.getHealth() < this.getMaxHealth()) {
                this.setHealth(this.getMaxHealth());
                if (!player.isCreative()) {
                    player.getItemInHand(hand).shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
        } else {
            if (!this.isCarryingToolbox() && this.isToolbox(player.getItemInHand(hand)) && this.getJob() == Job.DEFAULT) {
                this.equipToolbox(player.getItemInHand(hand));
                player.getItemInHand(hand).shrink(1);
                return InteractionResult.SUCCESS;
            }
            if (this.isCarryingToolbox()) {
                if (player.isShiftKeyDown() && player.getItemInHand(hand).isEmpty()) {
                    player.setItemInHand(hand, this.unequipToolbox());
                } else if (!this.level().isClientSide) {
                    this.openToolbox(player);
                }
                return InteractionResult.SUCCESS;
            }
            if (player.getItemInHand(hand).isEmpty() && !this.getHeldSchedules().isEmpty()) {
                for (ItemStack item2 : this.heldSchedules) {
                    if (player.addItem(item2)) continue;
                    player.drop(item2, false);
                }
                this.entityData.set(HOLDING_SCHEDULES, (Object)false);
                this.getHeldSchedules().clear();
            } else {
                if (this.getJob() == Job.DEFAULT && AllBlocks.REDSTONE_LINK.isIn(player.getItemInHand(hand))) {
                    this.setJob(Job.REMOTE_CONTROL);
                    player.getItemInHand(hand).shrink(1);
                    return InteractionResult.SUCCESS;
                }
                if (this.getJob() == Job.REMOTE_CONTROL) {
                    if (player.isShiftKeyDown() && player.getItemInHand(hand).isEmpty()) {
                        player.setItemInHand(hand, AllBlocks.REDSTONE_LINK.asStack());
                        this.setJob(Job.DEFAULT);
                    } else if (player.getItemInHand(hand).getItem() instanceof LinkedControllerItem) {
                        int i = 0;
                        for (Consumer<Optional<Couple<RedstoneLinkNetworkHandler.Frequency>>> freq : this.frequencies.settersInOrder()) {
                            freq.accept(Optional.of(LinkedControllerItem.toFrequency((ItemStack)player.getItemInHand(hand), (int)i)));
                            ++i;
                        }
                        this.updateFrequencyListeners();
                    }
                } else {
                    if (this.getJob() == Job.DEFAULT && AllItems.GOGGLES.isIn(player.getItemInHand(hand))) {
                        this.setJob(Job.SPY);
                        player.getItemInHand(hand).shrink(1);
                        return InteractionResult.SUCCESS;
                    }
                    if (this.getJob() == Job.SPY && player.isShiftKeyDown() && player.getItemInHand(hand).isEmpty()) {
                        player.setItemInHand(hand, AllItems.GOGGLES.asStack());
                        this.setJob(Job.DEFAULT);
                    }
                }
            }
        }
        return super.mobInteract(player, hand);
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.NETHERITE_BLOCK_BREAK;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return AllSoundEvents.CRUSHING_1.getMainEvent();
    }

    public void tick() {
        Level level;
        this.resetPosition();
        SectionPos sectionPos = SectionPos.of((EntityAccess)this);
        if (!sectionPos.equals((Object)this.oldSectionPos)) {
            this.setHasSentChunks(false);
        }
        if (this.level().isClientSide) {
            ConductorPossessionController.tryUpdatePossession(this);
            this.updatePossessionInputs();
        }
        super.tick();
        if (this.ventCooldown > 0) {
            --this.ventCooldown;
        }
        if ((level = this.level()) instanceof ServerLevel) {
            Object t;
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.fakePlayer == null) {
                this.fakePlayer = EntityUtils.createConductorFakePlayer(serverLevel, this);
            }
            if ((t = this.currentlyViewing.get()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)t;
                SectionPos chunkPos = SectionPos.of((BlockPos)this.blockPosition());
                int viewDistance = player.server.getPlayerList().getViewDistance();
                for (int x = chunkPos.getX() - viewDistance; x <= chunkPos.getX() + viewDistance; ++x) {
                    for (int z = chunkPos.getZ() - viewDistance; z <= chunkPos.getZ() + viewDistance; ++z) {
                        serverLevel.getChunkSource().addRegionTicket(TicketType.FORCED, new ChunkPos(x, z), 3, (Object)new ChunkPos(x, z));
                    }
                }
            }
        }
        if (this.toolbox != null) {
            this.toolbox.tick();
        }
    }

    public static ConductorEntity spawn(Level level, BlockPos pos, ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof ConductorCapItem)) {
            return null;
        }
        ConductorCapItem cap = (ConductorCapItem)item;
        ConductorEntity result = new ConductorEntity((EntityType<? extends AbstractGolem>)((EntityType)CREntities.CONDUCTOR.get()), level);
        result.setPos((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5);
        result.setColor(cap.color);
        result.equipItemIfPossible(stack);
        level.addFreshEntity((Entity)result);
        return result;
    }

    public boolean isInMinecart() {
        return this.getVehicle() instanceof AbstractMinecart;
    }

    public static DyeColor defaultColor() {
        return DyeColor.BLUE;
    }

    public void setColor(DyeColor color) {
        this.getEntityData().set(COLOR, (Object)ConductorEntity.idFrom(color));
    }

    public DyeColor getColor() {
        return ConductorEntity.colorFrom((Byte)this.entityData.get(COLOR));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isCorrectEngineerCap(ItemStack hat) {
        if (hat.isEmpty()) {
            return true;
        }
        Item item = hat.getItem();
        if (!(item instanceof ConductorCapItem)) return false;
        ConductorCapItem cap = (ConductorCapItem)item;
        if (cap.color != this.getColor()) return false;
        return true;
    }

    boolean isLookingAtMe(Player player) {
        if (player.isSpectator()) {
            return false;
        }
        boolean looking = false;
        ItemStack helmet = player.getItemBySlot(EquipmentSlot.HEAD);
        if (this.isCorrectEngineerCap(helmet) || !ItemUtils.blocksEndermanView(helmet, player, null)) {
            Vec3 headLine;
            Vec3 playerView = player.getViewVector(1.0f).normalize();
            double angle = playerView.dot(headLine = this.getEyePosition().subtract(player.getEyePosition()).normalize());
            looking = angle > 0.983 && player.hasLineOfSight((Entity)this);
        }
        return looking;
    }

    public static DyeColor colorFrom(byte b) {
        if (b >= 16) {
            return null;
        }
        return DyeColor.byId((int)b);
    }

    public static byte idFrom(DyeColor color) {
        int c = color.getId();
        if (c >= 16) {
            return 16;
        }
        return (byte)c;
    }

    public boolean canUseBlock(BlockState state) {
        return state.is(BlockTags.BUTTONS) || state.is(Blocks.LEVER) || state.getBlock() instanceof TrackSwitchBlock;
    }

    public void die(@NotNull DamageSource pSource) {
        super.die(pSource);
        Job job = this.getJob();
        ItemStack holdingStack = this.unequipToolbox();
        if (!holdingStack.isEmpty()) {
            this.spawnAtLocation(holdingStack);
        }
        if (this.isHoldingSchedules()) {
            for (ItemStack scheduleStack : this.getHeldSchedules()) {
                this.spawnAtLocation(scheduleStack);
            }
        }
        if (job == Job.REMOTE_CONTROL) {
            this.spawnAtLocation(AllBlocks.REDSTONE_LINK.asStack());
        } else if (job == Job.SPY) {
            this.spawnAtLocation(AllItems.GOGGLES.asStack());
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.put("target", NbtUtils.writeBlockPos((BlockPos)((BlockPos)this.getEntityData().get(BLOCK))));
        nbt.putByte("color", ((Byte)this.getEntityData().get(COLOR)).byteValue());
        if (this.toolbox != null) {
            CompoundTag toolboxTag = new CompoundTag();
            this.toolbox.write(toolboxTag, (HolderLookup.Provider)this.level().registryAccess(), false);
            nbt.put("toolboxHolder", (Tag)toolboxTag);
        }
        if (!this.getHeldSchedules().isEmpty()) {
            ListTag schedulesTag = new ListTag();
            boolean hasItem = false;
            for (ItemStack heldSchedule : this.heldSchedules) {
                if (heldSchedule.isEmpty()) continue;
                schedulesTag.add((Object)heldSchedule.save((HolderLookup.Provider)this.level().registryAccess()));
                hasItem = true;
            }
            if (hasItem) {
                nbt.put("heldSchedules", (Tag)schedulesTag);
            }
        }
        nbt.putString("job", this.getJob().name());
        nbt.put("frequencies", (Tag)this.frequencies.write((HolderLookup.Provider)this.level().registryAccess()));
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("color", 1)) {
            this.getEntityData().set(COLOR, (Object)nbt.getByte("color"));
        }
        if (nbt.contains("target", 10)) {
            this.getEntityData().set(BLOCK, (Object)NbtUtils.readBlockPos((CompoundTag)nbt.getCompound("target"), (String)"").orElse(BlockPos.ZERO));
        }
        if (nbt.contains("toolboxHolder", 10)) {
            this.setToolbox(MountedToolbox.read(this, nbt.getCompound("toolboxHolder")));
        } else {
            this.setToolbox(null);
        }
        if (nbt.contains("job", 8)) {
            this.setJob(Job.valueOf(nbt.getString("job")));
        } else {
            this.setJob(Job.DEFAULT);
        }
        this.getHeldSchedules().clear();
        if (nbt.contains("heldSchedules", 9)) {
            ListTag schedulesTag = nbt.getList("heldSchedules", 10);
            for (int i = 0; i < schedulesTag.size(); ++i) {
                ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)schedulesTag.getCompound(i));
                if (stack.isEmpty()) continue;
                this.getHeldSchedules().add(stack);
            }
        }
        if (!this.getCommandSenderWorld().isClientSide) {
            this.getEntityData().set(HOLDING_SCHEDULES, (Object)this.isHoldingSchedules());
            this.frequencies.read(nbt.getCompound("frequencies"), (HolderLookup.Provider)this.level().registryAccess());
            this.updateFrequencyListeners();
        }
    }

    static {
        for (String name : List.of("forward", "backward", "left", "right", "jump", "sneak")) {
            FREQUENCY_DATA.put(name, (Couple<EntityDataAccessor<ItemStack>>)Couple.create((Object)SynchedEntityData.defineId(ConductorEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK), (Object)SynchedEntityData.defineId(ConductorEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK)));
        }
        REACH = new Vec3i(3, 2, 3);
        RECENTLY_DISMOUNTED_PLAYERS = new ArrayList<Player>();
    }

    public class FrequencyListener
    implements IRedstoneLinkable {
        public final String key;
        @Nullable
        public final Couple<RedstoneLinkNetworkHandler.Frequency> frequency;
        public int receivedStrength = 0;

        public FrequencyListener(String key) {
            this.key = key;
            this.frequency = ConductorEntity.this.frequencies.entries().get(this.key).orElse(null);
            if (this.frequency != null) {
                Create.REDSTONE_LINK_NETWORK_HANDLER.addToNetwork((LevelAccessor)ConductorEntity.this.level(), (IRedstoneLinkable)this);
            }
        }

        public int getTransmittedStrength() {
            return 0;
        }

        public void setReceivedStrength(int power) {
            this.receivedStrength = power;
        }

        public boolean isListening() {
            return true;
        }

        public boolean isAlive() {
            return ConductorEntity.this.isAlive() && this.frequency != null;
        }

        public Couple<RedstoneLinkNetworkHandler.Frequency> getNetworkKey() {
            return this.frequency;
        }

        public BlockPos getLocation() {
            return ConductorEntity.this.blockPosition();
        }

        public boolean isPowered() {
            return this.receivedStrength > 0;
        }
    }

    public class FrequencyHolder
    implements Iterable<Optional<Couple<RedstoneLinkNetworkHandler.Frequency>>> {
        public FrequencyHolder() {
        }

        public FrequencyHolder(@Nullable Couple<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RedstoneLinkNetworkHandler.Frequency> forward, @Nullable Couple<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RedstoneLinkNetworkHandler.Frequency> backward, @Nullable Couple<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RedstoneLinkNetworkHandler.Frequency> left, @Nullable Couple<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RedstoneLinkNetworkHandler.Frequency> right, @Nullable Couple<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RedstoneLinkNetworkHandler.Frequency> jump, Couple<RedstoneLinkNetworkHandler.Frequency> sneak) {
            this.setForward(forward);
            this.setBackward(backward);
            this.setLeft(left);
            this.setRight(right);
            this.setJump(jump);
            this.setSneak(sneak);
        }

        @Override
        @NotNull
        public @NotNull Iterator<Optional<Couple<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RedstoneLinkNetworkHandler.Frequency>>> iterator() {
            return List.of(Optional.ofNullable(this.getForward()), Optional.ofNullable(this.getBackward()), Optional.ofNullable(this.getLeft()), Optional.ofNullable(this.getRight()), Optional.ofNullable(this.getJump()), Optional.ofNullable(this.getSneak())).iterator();
        }

        public Map<String, Optional<Couple<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RedstoneLinkNetworkHandler.Frequency>>> entries() {
            return Map.of("forward", Optional.ofNullable(this.getForward()), "backward", Optional.ofNullable(this.getBackward()), "left", Optional.ofNullable(this.getLeft()), "right", Optional.ofNullable(this.getRight()), "jump", Optional.ofNullable(this.getJump()), "sneak", Optional.ofNullable(this.getSneak()));
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public Map<String, Couple<@NotNull ItemStack>> stacks() {
            HashMap<String, @NotNull Couple> stacks = new HashMap<String, Couple>();
            for (Map.Entry<String, Optional<Couple<RedstoneLinkNetworkHandler.Frequency>>> entry : this.entries().entrySet()) {
                if (entry.getValue().isEmpty()) {
                    stacks.put(entry.getKey(), Couple.create((Object)ItemStack.EMPTY, (Object)ItemStack.EMPTY));
                    continue;
                }
                Couple<// Could not load outer class - annotation placement on inner may be incorrect
                 @NotNull RedstoneLinkNetworkHandler.Frequency> freqs = entry.getValue().get();
                stacks.put(entry.getKey(), Couple.create((Object)((RedstoneLinkNetworkHandler.Frequency)freqs.getFirst()).getStack(), (Object)((RedstoneLinkNetworkHandler.Frequency)freqs.getSecond()).getStack()));
            }
            return ImmutableMap.copyOf(stacks);
        }

        public Map<String, Consumer<Optional<Couple<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RedstoneLinkNetworkHandler.Frequency>>>> setters() {
            return Map.of("forward", freq -> this.setForward((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), "backward", freq -> this.setBackward((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), "left", freq -> this.setLeft((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), "right", freq -> this.setRight((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), "jump", freq -> this.setJump((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), "sneak", freq -> this.setSneak((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))));
        }

        public List<Consumer<Optional<Couple<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RedstoneLinkNetworkHandler.Frequency>>>> settersInOrder() {
            return List.of(freq -> this.setForward((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), freq -> this.setBackward((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), freq -> this.setLeft((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), freq -> this.setRight((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), freq -> this.setJump((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), freq -> this.setSneak((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))));
        }

        public CompoundTag write(HolderLookup.Provider lookupProvider) {
            CompoundTag tag = new CompoundTag();
            for (Map.Entry<String, Optional<Couple<RedstoneLinkNetworkHandler.Frequency>>> freq : this.entries().entrySet()) {
                if (!freq.getValue().isPresent()) continue;
                ItemStack firstStack = ((RedstoneLinkNetworkHandler.Frequency)freq.getValue().get().getFirst()).getStack();
                ItemStack secondStack = ((RedstoneLinkNetworkHandler.Frequency)freq.getValue().get().getSecond()).getStack();
                if (firstStack.isEmpty() && secondStack.isEmpty()) continue;
                CompoundTag subTag = new CompoundTag();
                if (!firstStack.isEmpty()) {
                    subTag.put("first", firstStack.save(lookupProvider));
                }
                if (!secondStack.isEmpty()) {
                    subTag.put("second", secondStack.save(lookupProvider));
                }
                tag.put(freq.getKey(), (Tag)subTag);
            }
            return tag;
        }

        public FrequencyHolder read(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            for (Map.Entry<String, Consumer<Optional<Couple<RedstoneLinkNetworkHandler.Frequency>>>> freq : this.setters().entrySet()) {
                if (tag.contains(freq.getKey(), 10)) {
                    CompoundTag freqTag = tag.getCompound(freq.getKey());
                    ItemStack first = freqTag.contains("first", 10) ? ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)freqTag.getCompound("first")) : ItemStack.EMPTY;
                    ItemStack second = freqTag.contains("second", 10) ? ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)freqTag.getCompound("second")) : ItemStack.EMPTY;
                    freq.getValue().accept(Optional.of(Couple.create((Object)RedstoneLinkNetworkHandler.Frequency.of((ItemStack)first), (Object)RedstoneLinkNetworkHandler.Frequency.of((ItemStack)second))));
                    continue;
                }
                freq.getValue().accept(Optional.empty());
            }
            return this;
        }

        private static Couple<ItemStack> freqToStacks(@Nullable Couple<RedstoneLinkNetworkHandler.Frequency> freqs) {
            if (freqs == null) {
                return Couple.create((Object)ItemStack.EMPTY, (Object)ItemStack.EMPTY);
            }
            return freqs.map(RedstoneLinkNetworkHandler.Frequency::getStack);
        }

        private static Couple<RedstoneLinkNetworkHandler.Frequency> stacksToFreq(Couple<ItemStack> stacks) {
            return stacks.map(RedstoneLinkNetworkHandler.Frequency::of);
        }

        private void set(String name, @Nullable Couple<RedstoneLinkNetworkHandler.Frequency> value) {
            Couple<ItemStack> stacks = FrequencyHolder.freqToStacks(value);
            Couple<EntityDataAccessor<ItemStack>> freqAccessors = FREQUENCY_DATA.get(name);
            for (boolean first : Iterate.trueAndFalse) {
                ConductorEntity.this.entityData.set((EntityDataAccessor)freqAccessors.get(first), (Object)((ItemStack)stacks.get(first)));
            }
        }

        private Couple<RedstoneLinkNetworkHandler.Frequency> get(String name) {
            Couple<EntityDataAccessor<ItemStack>> freqAccessors = FREQUENCY_DATA.get(name);
            return FrequencyHolder.stacksToFreq((Couple<ItemStack>)freqAccessors.map(arg_0 -> ((SynchedEntityData)ConductorEntity.this.entityData).get(arg_0)));
        }

        @Nullable
        public Couple<RedstoneLinkNetworkHandler.Frequency> getForward() {
            return this.get("forward");
        }

        public void setForward(@Nullable Couple<RedstoneLinkNetworkHandler.Frequency> forward) {
            this.set("forward", forward);
        }

        @Nullable
        public Couple<RedstoneLinkNetworkHandler.Frequency> getBackward() {
            return this.get("backward");
        }

        public void setBackward(@Nullable Couple<RedstoneLinkNetworkHandler.Frequency> backward) {
            this.set("backward", backward);
        }

        @Nullable
        public Couple<RedstoneLinkNetworkHandler.Frequency> getLeft() {
            return this.get("left");
        }

        public void setLeft(@Nullable Couple<RedstoneLinkNetworkHandler.Frequency> left) {
            this.set("left", left);
        }

        @Nullable
        public Couple<RedstoneLinkNetworkHandler.Frequency> getRight() {
            return this.get("right");
        }

        public void setRight(@Nullable Couple<RedstoneLinkNetworkHandler.Frequency> right) {
            this.set("right", right);
        }

        @Nullable
        public Couple<RedstoneLinkNetworkHandler.Frequency> getJump() {
            return this.get("jump");
        }

        public void setJump(@Nullable Couple<RedstoneLinkNetworkHandler.Frequency> jump) {
            this.set("jump", jump);
        }

        @Nullable
        public Couple<RedstoneLinkNetworkHandler.Frequency> getSneak() {
            return this.get("sneak");
        }

        public void setSneak(@Nullable Couple<RedstoneLinkNetworkHandler.Frequency> sneak) {
            this.set("sneak", sneak);
        }
    }

    public static enum Job {
        REDSTONE_OPERATOR,
        TOOLBOX_CARRIER,
        REMOTE_CONTROL,
        SPY;

        public static final Job DEFAULT;

        static {
            DEFAULT = REDSTONE_OPERATOR;
        }
    }

    static class ConductorLookedAtGoal
    extends JobBasedGoal {
        @Nullable
        private LivingEntity target;
        @Nullable
        private Player lookingPlayer;

        public ConductorLookedAtGoal(ConductorEntity conductor) {
            super(conductor, Job.REDSTONE_OPERATOR);
        }

        @Override
        public boolean canUse() {
            if (!super.canUse()) {
                return false;
            }
            for (Player player : this.conductor.level().players()) {
                if (!player.hasLineOfSight((Entity)this.conductor) || !(this.conductor.distanceToSqr((Entity)player) < 256.0) || !this.conductor.isLookingAtMe(player)) continue;
                this.lookingPlayer = player;
                return true;
            }
            return false;
        }

        public void start() {
            Level level = this.conductor.level();
            ServerPlayer fake = this.conductor.fakePlayer;
            if (fake == null) {
                return;
            }
            for (int y = -REACH.getY(); y < REACH.getY(); ++y) {
                for (int x = -REACH.getX(); x < REACH.getX(); ++x) {
                    for (int z = -REACH.getZ(); z < REACH.getZ(); ++z) {
                        boolean canUse;
                        ClipContext context;
                        BlockHitResult hitResult;
                        BlockPos at = this.conductor.blockPosition().offset(x, y, z);
                        BlockState state = level.getBlockState(at);
                        if (!this.conductor.canUseBlock(state) || !this.conductor.canReach((Vec3i)at) || !(hitResult = level.clip(context = new ClipContext(this.conductor.getEyePosition(), new Vec3((double)at.getX() + 0.5, (double)at.getY() + 0.5, (double)at.getZ() + 0.5), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.conductor))).getBlockPos().equals((Object)at)) continue;
                        boolean bl = canUse = state.getShape((BlockGetter)level, at).isEmpty() || EntityUtils.handleUseEvent((Player)fake, InteractionHand.MAIN_HAND, hitResult);
                        if (!canUse) continue;
                        state.useWithoutItem(level, (Player)fake, hitResult);
                        this.target = this.lookingPlayer;
                        return;
                    }
                }
            }
        }

        public void tick() {
            if (this.target != null) {
                this.conductor.lookControl.setLookAt((Entity)this.target);
            }
        }
    }

    static class ConductorPonderBlockGoal
    extends JobBasedGoal {
        private BlockPos target;

        public ConductorPonderBlockGoal(ConductorEntity conductor) {
            super(conductor, Job.REDSTONE_OPERATOR);
            this.target = (BlockPos)conductor.entityData.get(BLOCK);
        }

        @Override
        public boolean canUse() {
            if (!super.canUse()) {
                return false;
            }
            this.target = (BlockPos)this.conductor.entityData.get(BLOCK);
            if (this.conductor.canReach((Vec3i)this.target) && this.conductor.canUseBlock(this.conductor.level().getBlockState(this.target))) {
                return true;
            }
            for (int y = -REACH.getY(); y < REACH.getY(); ++y) {
                for (int x = -REACH.getX(); x < REACH.getX(); ++x) {
                    for (int z = -REACH.getZ(); z < REACH.getZ(); ++z) {
                        BlockPos at = this.conductor.blockPosition().offset(x, y, z);
                        BlockState state = this.conductor.level().getBlockState(at);
                        if (!this.conductor.canUseBlock(state)) continue;
                        ClipContext context = new ClipContext(this.conductor.getEyePosition(), new Vec3((double)at.getX() + 0.5, (double)at.getY() + 0.5, (double)at.getZ() + 0.5), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.conductor);
                        BlockHitResult hitResult = this.conductor.level().clip(context);
                        if (!hitResult.getBlockPos().equals((Object)at)) continue;
                        this.target = at;
                        this.conductor.entityData.set(BLOCK, (Object)this.target);
                        return true;
                    }
                }
            }
            return false;
        }

        public void tick() {
            this.conductor.lookControl.setLookAt((double)this.target.getX(), (double)this.target.getY(), (double)this.target.getZ());
        }
    }

    static class FollowToolboxPlayerGoal
    extends JobBasedGoal {
        protected final double speedModifier;
        @Nullable
        protected Player target;
        protected int timeToRecalcPath;

        public FollowToolboxPlayerGoal(ConductorEntity conductor, double speedModifier) {
            super(conductor, Job.TOOLBOX_CARRIER);
            this.speedModifier = speedModifier;
        }

        public void tick() {
            super.tick();
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.adjustedTickDelay(10);
                if (this.conductor.distanceToSqr((Entity)this.target) > 16.0) {
                    this.conductor.getNavigation().moveTo((Entity)this.target, this.speedModifier);
                } else {
                    this.conductor.getNavigation().stop();
                }
            }
        }

        @Override
        public boolean canUse() {
            return super.canUse() && this.conductor.isCarryingToolbox() && !this.conductor.getToolbox().getConnectedPlayers().isEmpty();
        }

        @Override
        public boolean canContinueToUse() {
            return super.canContinueToUse() && this.conductor.isCarryingToolbox() && this.conductor.getToolbox().getConnectedPlayers().contains(this.target) && this.target.isAlive() && !this.target.isSpectator();
        }

        public void start() {
            super.start();
            List<Player> players = this.conductor.getToolbox().getConnectedPlayers();
            this.target = players.get(this.conductor.random.nextInt(players.size()));
        }

        public void stop() {
            super.stop();
            this.target = null;
        }
    }

    static class RemoteControlGoal
    extends JobBasedGoal {
        protected final double speedModifier;
        protected Vec3 targetDirection = Vec3.ZERO;
        protected double targetStrength = 15.0;
        private int honkPacketCooldown = 0;
        private boolean usedToHonk;

        public RemoteControlGoal(ConductorEntity conductor, double speedModifier) {
            super(conductor, Job.REMOTE_CONTROL);
            this.speedModifier = speedModifier;
        }

        protected double getGroundY(Vec3 vec) {
            BlockPos blockPos = BlockPos.containing((Position)vec);
            return this.conductor.level().getBlockState(blockPos.below()).isAir() ? vec.y : WalkNodeEvaluator.getFloorLevel((BlockGetter)this.conductor.level(), (BlockPos)blockPos);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void tick() {
            CarriageContraptionEntity cce;
            super.tick();
            Pair<Vec3, Double> pair = this.calculateTarget();
            this.targetDirection = (Vec3)pair.getFirst();
            this.targetStrength = (Double)pair.getSecond();
            Vec3 target = this.conductor.position().add(this.targetDirection.scale(2.0));
            Entity entity = this.conductor.getRootVehicle();
            if (entity instanceof CarriageContraptionEntity && (cce = (CarriageContraptionEntity)entity).getControllingPlayer().isEmpty() && (entity = cce.getContraption()) instanceof CarriageContraption) {
                CarriageContraption cc = (CarriageContraption)entity;
                if (this.conductor.fakePlayer != null) {
                    ScheduleRuntime runtime;
                    BlockPos seat = cc.getSeatOf(this.conductor.uuid);
                    if (seat == null) {
                        return;
                    }
                    Couple controlsPresent = (Couple)cc.conductorSeats.get(seat);
                    if (controlsPresent == null) {
                        return;
                    }
                    if (cce.getCarriage() != null && (runtime = cce.getCarriage().train.runtime).getSchedule() != null && !runtime.completed && !runtime.paused) {
                        return;
                    }
                    BlockPos controlsPos = null;
                    BlockPos reverseControlsPos = null;
                    if (((Boolean)controlsPresent.getFirst()).booleanValue()) {
                        controlsPos = seat.relative(cc.getAssemblyDirection().getOpposite());
                    }
                    if (((Boolean)controlsPresent.getSecond()).booleanValue()) {
                        if (controlsPos == null) {
                            controlsPos = seat.relative(cc.getAssemblyDirection());
                        } else {
                            reverseControlsPos = seat.relative(cc.getAssemblyDirection());
                        }
                    }
                    if (controlsPos == null) {
                        return;
                    }
                    Set<Integer> controls = this.getControls();
                    if (reverseControlsPos != null && controls.contains(1) && !controls.contains(0)) {
                        controls.remove(1);
                        controls.add(0);
                        controlsPos = reverseControlsPos;
                    }
                    boolean isSprintKeyPressed = controls.remove(5);
                    cce.control(controlsPos, controls, (Player)this.conductor.fakePlayer);
                    Train train = cce.getCarriage().train;
                    if (isSprintKeyPressed && this.honkPacketCooldown-- <= 0) {
                        train.determineHonk(this.conductor.level());
                        if (train.lowHonk != null) {
                            Utils.sendHonkPacket(train, true);
                            this.honkPacketCooldown = 5;
                            this.usedToHonk = true;
                        }
                    }
                    if (isSprintKeyPressed) return;
                    if (!this.usedToHonk) return;
                    Utils.sendHonkPacket(train, false);
                    this.honkPacketCooldown = 0;
                    this.usedToHonk = false;
                    return;
                }
            }
            if (!(this.targetDirection.lengthSqr() > 0.01)) return;
            this.conductor.getMoveControl().setWantedPosition(target.x, this.getGroundY(target), target.z, this.speedModifier * this.targetStrength / 15.0);
        }

        private Set<Integer> getControls() {
            HashSet<Integer> controls = new HashSet<Integer>();
            if (this.conductor.forwardListener != null && this.conductor.forwardListener.isPowered()) {
                controls.add(0);
            }
            if (this.conductor.backwardListener != null && this.conductor.backwardListener.isPowered()) {
                controls.add(1);
            }
            if (this.conductor.leftListener != null && this.conductor.leftListener.isPowered()) {
                controls.add(2);
            }
            if (this.conductor.rightListener != null && this.conductor.rightListener.isPowered()) {
                controls.add(3);
            }
            if (this.conductor.jumpListener != null && this.conductor.jumpListener.isPowered()) {
                controls.add(4);
            }
            if (this.conductor.sneakListener != null && this.conductor.sneakListener.isPowered()) {
                controls.add(5);
            }
            return controls;
        }

        private Pair<Vec3, Double> calculateTarget() {
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            if (this.conductor.forwardListener != null && this.conductor.forwardListener.isPowered()) {
                z -= (double)this.conductor.forwardListener.receivedStrength;
            }
            if (this.conductor.backwardListener != null && this.conductor.backwardListener.isPowered()) {
                z += (double)this.conductor.backwardListener.receivedStrength;
            }
            if (this.conductor.leftListener != null && this.conductor.leftListener.isPowered()) {
                x -= (double)this.conductor.leftListener.receivedStrength;
            }
            if (this.conductor.rightListener != null && this.conductor.rightListener.isPowered()) {
                x += (double)this.conductor.rightListener.receivedStrength;
            }
            if (this.conductor.jumpListener != null && this.conductor.jumpListener.isPowered()) {
                y += (double)this.conductor.jumpListener.receivedStrength;
            }
            if (this.conductor.sneakListener != null && this.conductor.sneakListener.isPowered()) {
                y -= (double)this.conductor.sneakListener.receivedStrength;
            }
            double avgStrength = 0.0;
            int count = 0;
            if (x != 0.0) {
                avgStrength += Math.abs(x);
                ++count;
            }
            if (y != 0.0) {
                avgStrength += Math.abs(y);
                ++count;
            }
            if (z != 0.0) {
                avgStrength += Math.abs(z);
                ++count;
            }
            return Pair.of((Object)new Vec3(x, Math.max(0.0, y), z).scale(0.06666666666666667), (Object)(count == 0 ? 0.0 : avgStrength / (double)count));
        }

        public void start() {
            super.start();
            Pair<Vec3, Double> pair = this.calculateTarget();
            this.targetDirection = (Vec3)pair.getFirst();
            this.targetStrength = (Double)pair.getSecond();
        }

        public void stop() {
            super.stop();
            this.targetDirection = Vec3.ZERO;
            this.targetStrength = 15.0;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }
    }

    static class JobBasedGoal
    extends Goal {
        private final Job job;
        protected final ConductorEntity conductor;

        public JobBasedGoal(ConductorEntity conductor, Job job) {
            this.conductor = conductor;
            this.job = job;
        }

        public boolean canUse() {
            return this.conductor.getJob() == this.job && !this.conductor.isPossessed();
        }

        public boolean canContinueToUse() {
            return this.canUse();
        }
    }
}

