/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.registry.CRBlockPartials;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.HashMap;
import java.util.Map;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.render.CachedBuffers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ConductorCapModel<T extends LivingEntity>
extends Model
implements HeadedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Railways.asResource("conductor_cap"), "main");
    private final ModelPart cap;
    @Nullable
    private final PartialModel override;
    private final boolean doNotTilt;
    private static ConductorCapModel<?> defaultModel = null;
    private static final Map<Pair<String, Boolean>, ConductorCapModel<?>> customModels = new HashMap();

    public ConductorCapModel(ModelPart root, @Nullable PartialModel override, boolean doNotTilt) {
        super(override == null ? RenderType::armorCutoutNoCull : rl -> RenderType.cutout());
        this.cap = root.getChild("cap");
        this.override = override;
        this.doNotTilt = doNotTilt;
    }

    public static void clearModelCache() {
        defaultModel = null;
        customModels.clear();
    }

    public static ConductorCapModel<?> of(ItemStack stack, HumanoidModel<?> base, LivingEntity entity) {
        String name2;
        if (defaultModel == null) {
            EntityModelSet set = Minecraft.getInstance().getEntityModels();
            ModelPart root = set.bakeLayer(LAYER_LOCATION);
            CRBlockPartials.CUSTOM_CONDUCTOR_CAPS.forEach((name, partial) -> {
                ConductorCapModel model = new ConductorCapModel(root, (PartialModel)partial, CRBlockPartials.shouldPreventTiltingCap(name));
                customModels.put((Pair<String, Boolean>)Pair.of((Object)name, (Object)false), model);
                customModels.put((Pair<String, Boolean>)Pair.of((Object)name, (Object)true), model);
            });
            CRBlockPartials.CUSTOM_CONDUCTOR_ONLY_CAPS.forEach((name, partial) -> {
                ConductorCapModel model = new ConductorCapModel(root, (PartialModel)partial, CRBlockPartials.shouldPreventTiltingCap(name));
                Pair key = Pair.of((Object)name, (Object)true);
                customModels.put((Pair<String, Boolean>)key, model);
            });
            defaultModel = new ConductorCapModel(root, null, false);
        }
        if ((name2 = stack.getHoverName().getString()).startsWith("[sus]")) {
            name2 = name2.substring(5);
        }
        ConductorCapModel<?> model = customModels.getOrDefault(Pair.of((Object)name2, (Object)(entity instanceof ConductorEntity)), defaultModel);
        model.setProperties(base);
        return model;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition hat = partdefinition.addOrReplaceChild("cap", CubeListBuilder.create().texOffs(0, 0).addBox(-4.5f, -9.0f, -4.0f, 9.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        hat.addOrReplaceChild("brim", CubeListBuilder.create().texOffs(6, 12).addBox(-4.5f, 3.8f, -3.0f, 9.0f, 0.02f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-10.0f, (float)-4.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        this.renderToBufferRGBA(poseStack, vertexConsumer, packedLight, packedOverlay, r, g, b, a);
    }

    private void renderToBufferRGBA(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.override != null) {
            poseStack.pushPose();
            this.cap.translateAndRotate(poseStack);
            poseStack.translate(0.0, -0.25, 0.0);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            poseStack.scale(0.625f, -0.625f, -0.625f);
            this.override.get().getTransforms().head.apply(false, poseStack);
            poseStack.translate(-0.5, -0.5, -0.5);
            CachedBuffers.partial((PartialModel)this.override, (BlockState)Blocks.AIR.defaultBlockState()).light(packedLight).overlay(packedOverlay).renderInto(poseStack, Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.translucent()));
            poseStack.popPose();
        } else {
            int ri = (int)(red * 255.0f) & 0xFF;
            int gi = (int)(green * 255.0f) & 0xFF;
            int bi = (int)(blue * 255.0f) & 0xFF;
            int ai = (int)(alpha * 255.0f) & 0xFF;
            int argb = ai << 24 | ri << 16 | gi << 8 | bi;
            this.cap.render(poseStack, vertexConsumer, packedLight, packedOverlay, argb);
        }
    }

    public ModelPart getHead() {
        return this.cap;
    }

    public void setProperties(HumanoidModel<?> base) {
        this.cap.copyFrom(this.doNotTilt ? base.head : base.hat);
        if (base instanceof PlayerModel && this.override == null) {
            float s = 0.0625f;
            this.cap.offsetScale(new Vector3f(s, s, s));
            this.cap.offsetPos(new Vector3f(0.0f, 0.0f, -0.625f));
        }
    }
}

