/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer;

import com.mojang.serialization.MapCodec;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.buffer.WoodVariantTrackBufferBlock;
import com.railwayteam.railways.content.custom_bogeys.special.monobogey.MonoBogeyBlock;
import java.util.Locale;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MonoTrackBufferBlock
extends WoodVariantTrackBufferBlock {
    public static final MapCodec<MonoTrackBufferBlock> CODEC = MonoTrackBufferBlock.simpleCodec(MonoTrackBufferBlock::new);
    public static final EnumProperty<Style> STYLE = EnumProperty.create((String)"style", Style.class);
    public static final BooleanProperty UPSIDE_DOWN = MonoBogeyBlock.UPSIDE_DOWN;

    public MonoTrackBufferBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(STYLE, (Comparable)((Object)Style.STANDARD))).setValue((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends MonoTrackBufferBlock> codec() {
        return CODEC;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{STYLE, UPSIDE_DOWN}));
    }

    @Override
    protected BlockState getCycledStyle(BlockState originalState, Direction targetedFace) {
        return (BlockState)originalState.cycle(STYLE);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        boolean hanging = context.getClickedFace() == Direction.DOWN;
        Style style = context.getClickedFace().getAxis().isHorizontal() ? Style.SIDE : Style.STANDARD;
        return (BlockState)((BlockState)state.setValue((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(hanging))).setValue(STYLE, (Comparable)((Object)style));
    }

    public static enum Style implements StringRepresentable
    {
        STANDARD("monorail_buffer_stop"),
        MONO("monorail_mono_buffer_stop"),
        SIDE("monorail_side_buffer_stop");

        private final String model;

        private Style(String model) {
            this.model = model;
        }

        public ResourceLocation getModel() {
            return Railways.asResource("block/buffer/" + this.model);
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

