/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.compat.tracks;

import com.google.common.collect.ImmutableSet;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.base.data.CRTagGen;
import com.railwayteam.railways.compat.Mods;
import com.railwayteam.railways.compat.tracks.CompatTrackBlockStateGenerator;
import com.railwayteam.railways.compat.tracks.GenericTrackCompat;
import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.mixin.AccessorTrackMaterialFactory;
import com.railwayteam.railways.multiloader.CommonTags;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockItem;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackMaterialFactory;
import com.simibubi.create.content.trains.track.TrackModel;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.SharedProperties;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;

public abstract class TrackCompatUtils {
    public static final Set<String> TRACK_COMPAT_MODS = ImmutableSet.of((Object)"hexcasting", (Object)"byg", (Object)"blue_skies", (Object)"twilightforest", (Object)"biomesoplenty", (Object)"natures_spirit", (Object[])new String[]{"create_dd", "quark", "tfc"});
    private static final CreateRegistrate REGISTRATE = Railways.registrate();

    public static boolean anyLoaded() {
        if (GenericTrackCompat.isDataGen() || ((Boolean)CRConfigs.common().registerMissingTracks.get()).booleanValue()) {
            return true;
        }
        for (String mod : TRACK_COMPAT_MODS) {
            if (!Mods.valueOf((String)mod.toUpperCase((Locale)Locale.ROOT)).isLoaded) continue;
            return true;
        }
        return false;
    }

    public static BlockEntry<TrackBlock> makeTrack(TrackMaterial material) {
        return TrackCompatUtils.makeTrack(material, (NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider>)((NonNullBiConsumer)(arg_0, arg_1) -> ((CompatTrackBlockStateGenerator)CompatTrackBlockStateGenerator.create()).generate(arg_0, arg_1)));
    }

    public static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, boolean hideInCreativeTabs) {
        return TrackCompatUtils.makeTrack(material, (NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider>)((NonNullBiConsumer)(arg_0, arg_1) -> ((CompatTrackBlockStateGenerator)CompatTrackBlockStateGenerator.create()).generate(arg_0, arg_1)), (NonNullConsumer<? super TrackBlock>)((NonNullConsumer)t -> {}), p -> p, hideInCreativeTabs);
    }

    public static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider> blockstateGen) {
        return TrackCompatUtils.makeTrack(material, blockstateGen, (NonNullConsumer<? super TrackBlock>)((NonNullConsumer)t -> {}));
    }

    public static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider> blockstateGen, NonNullConsumer<? super TrackBlock> onRegister) {
        return TrackCompatUtils.makeTrack(material, blockstateGen, onRegister, p -> p);
    }

    public static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider> blockstateGen, Function<BlockBehaviour.Properties, BlockBehaviour.Properties> collectProperties) {
        return TrackCompatUtils.makeTrack(material, blockstateGen, (NonNullConsumer<? super TrackBlock>)((NonNullConsumer)t -> {}), collectProperties);
    }

    public static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider> blockstateGen, NonNullConsumer<? super TrackBlock> onRegister, Function<BlockBehaviour.Properties, BlockBehaviour.Properties> collectProperties) {
        return TrackCompatUtils.makeTrack(material, blockstateGen, onRegister, collectProperties, false);
    }

    public static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider> blockstateGen, NonNullConsumer<? super TrackBlock> onRegister, Function<BlockBehaviour.Properties, BlockBehaviour.Properties> collectProperties, boolean hideInCreativeTabs) {
        String owningMod = material.id.getNamespace();
        String name = "track_" + owningMod + "_" + material.resourceName();
        CRTagGen.addOptionalTag(Railways.asResource(name), AllTags.AllBlockTags.TRACKS.tag, CommonTags.RELOCATION_NOT_SUPPORTED.forge, CommonTags.RELOCATION_NOT_SUPPORTED.fabric, BlockTags.MINEABLE_WITH_PICKAXE);
        if (material.trackType != CRTrackMaterials.CRTrackType.MONORAIL) {
            CRTagGen.addOptionalTag(Railways.asResource(name), AllTags.AllBlockTags.GIRDABLE_TRACKS.tag);
        }
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block(name, arg_0 -> ((TrackMaterial)material).createBlock(arg_0)).initialProperties(SharedProperties::stone).properties(p -> ((BlockBehaviour.Properties)collectProperties.apply((BlockBehaviour.Properties)p)).mapColor(MapColor.METAL).strength(0.8f).sound(SoundType.METAL).noOcclusion()).addLayer(() -> RenderType::cutoutMipped).blockstate(blockstateGen).lang(material.langName + " Train Track").onRegister(onRegister)).onRegister(CreateRegistrate.blockModel(() -> TrackModel::new))).onRegister(CRTrackMaterials::addToBlockEntityType)).item(TrackBlockItem::new).removeTab(hideInCreativeTabs ? null : CreativeModeTabs.SEARCH).model((c, p) -> p.generated((NonNullSupplier)c, new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)owningMod, (String)("item/track/track_" + material.resourceName()))})).build()).register();
    }

    public static TrackMaterial buildCompatModels(GenericTrackCompat trackCompat, TrackMaterialFactory factory) {
        String namespace = ((AccessorTrackMaterialFactory)factory).getId().getNamespace();
        String path = ((AccessorTrackMaterialFactory)factory).getId().getPath();
        String prefix = "block/track/compat/" + namespace + "/" + path + "/";
        TrackMaterialFactory materialFactory = factory.customModels(() -> () -> PartialModel.of((ResourceLocation)Railways.asResource(prefix + "tie")), () -> () -> PartialModel.of((ResourceLocation)Railways.asResource(prefix + "segment_left")), () -> () -> PartialModel.of((ResourceLocation)Railways.asResource(prefix + "segment_right")));
        String customLang = trackCompat.getLang(path);
        if (!path.equals(customLang)) {
            materialFactory.lang(customLang);
        }
        return materialFactory.build();
    }
}

