/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.base.data.neoforge;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.base.data.BuilderTransformers;
import com.railwayteam.railways.content.buffer.MonoTrackBufferBlock;
import com.railwayteam.railways.content.buffer.TrackBufferBlock;
import com.railwayteam.railways.content.buffer.headstock.CopycatHeadstockBarsBlock;
import com.railwayteam.railways.content.buffer.headstock.CopycatHeadstockBlock;
import com.railwayteam.railways.content.buffer.headstock.HeadstockBlock;
import com.railwayteam.railways.content.buffer.headstock.HeadstockStyle;
import com.railwayteam.railways.content.buffer.headstock.neoforge.CopycatHeadstockBarsModel;
import com.railwayteam.railways.content.buffer.headstock.neoforge.CopycatHeadstockModel;
import com.railwayteam.railways.content.buffer.neoforge.BufferModel;
import com.railwayteam.railways.content.buffer.single_deco.GenericDyeableSingleBufferBlock;
import com.railwayteam.railways.content.buffer.single_deco.LinkPinBlock;
import com.railwayteam.railways.content.conductor.vent.VentBlock;
import com.railwayteam.railways.content.conductor.whistle.ConductorWhistleFlagBlock;
import com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlock;
import com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlockEntity;
import com.railwayteam.railways.content.custom_bogeys.blocks.base.CRBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.special.invisible.InvisibleBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.special.monobogey.AbstractMonoBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.special.monobogey.InvisibleMonoBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.special.monobogey.MonoBogeyBlock;
import com.railwayteam.railways.content.custom_tracks.casing.CasingCollisionBlock;
import com.railwayteam.railways.content.custom_tracks.generic_crossing.GenericCrossingBlock;
import com.railwayteam.railways.content.custom_tracks.generic_crossing.neoforge.GenericCrossingModel;
import com.railwayteam.railways.content.handcar.HandcarBlock;
import com.railwayteam.railways.content.palettes.smokebox.PalettesSmokeboxBlock;
import com.railwayteam.railways.content.semaphore.SemaphoreBlock;
import com.railwayteam.railways.content.smokestack.SmokestackStyle;
import com.railwayteam.railways.content.smokestack.block.AbstractSmokeStackBlock;
import com.railwayteam.railways.content.smokestack.block.DieselSmokeStackBlock;
import com.railwayteam.railways.content.smokestack.block.SmokeStackBlock;
import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CRTags;
import com.railwayteam.railways.util.ColorUtils;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.decoration.copycat.CopycatBlock;
import com.simibubi.create.foundation.data.AssetLookup;
import com.simibubi.create.foundation.data.BlockStateGen;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import org.jetbrains.annotations.Nullable;

public class BuilderTransformersImpl {
    public static <B extends MonoBogeyBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> monobogey() {
        return b -> ((BlockBuilder)b.initialProperties(SharedProperties::softMetal).properties(p -> p.sound(SoundType.NETHERITE_BLOCK)).properties(BlockBehaviour.Properties::noOcclusion).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> BlockStateGen.horizontalAxisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, s -> p.models().getExistingFile(p.modLoc("block/bogey/monorail/top" + ((Boolean)s.getValue((Property)AbstractMonoBogeyBlock.UPSIDE_DOWN) != false ? "_upside_down" : ""))))).loot((p, l) -> p.dropOther((Block)l, (ItemLike)AllBlocks.RAILWAY_CASING.get()));
    }

    public static <B extends InvisibleBogeyBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> invisibleBogey() {
        return b -> ((BlockBuilder)b.initialProperties(SharedProperties::softMetal).properties(p -> p.sound(SoundType.NETHERITE_BLOCK)).properties(BlockBehaviour.Properties::noOcclusion).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> BlockStateGen.horizontalAxisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, s -> p.models().getExistingFile(p.modLoc("block/bogey/invisible/top")))).loot((p, l) -> p.dropOther((Block)l, (ItemLike)AllBlocks.RAILWAY_CASING.get()));
    }

    public static <B extends SmokeStackBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> smokestack(boolean rotates, ResourceLocation modelLoc) {
        return a -> a.blockstate((c, p) -> {
            if (rotates) {
                p.getVariantBuilder((Block)c.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(modelLoc)).rotationY(state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS) == Direction.Axis.X ? 90 : 0).build());
            } else {
                p.getVariantBuilder((Block)c.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(modelLoc)).build());
            }
        });
    }

    public static <B extends SemaphoreBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> semaphore() {
        return a -> a.blockstate((ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)prov.models().getExistingFile(prov.modLoc("block/semaphore/block" + ((Boolean)state.getValue((Property)SemaphoreBlock.FULL) != false ? "_full" : "") + ((Boolean)state.getValue((Property)SemaphoreBlock.FLIPPED) != false ? "_flipped" : "") + ((Boolean)state.getValue((Property)SemaphoreBlock.UPSIDE_DOWN) != false ? "_down" : "")))).rotationY(((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 180) % 360).build()));
    }

    public static <B extends TrackCouplerBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> trackCoupler() {
        return a -> a.blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile(AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[]{((TrackCouplerBlockEntity.AllowedOperationMode)((Object)((Object)((Object)((Object)state.getValue(TrackCouplerBlock.MODE)))))).getSerializedName()})).build(), new Property[]{TrackCouplerBlock.POWERED}));
    }

    public static <B extends TrackSwitchBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> trackSwitch(boolean andesite) {
        return a -> a.blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(Railways.asResource("block/track_switch_" + (andesite ? "andesite" : "brass") + "/block"))).rotationY(((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 90) % 360).build(), new Property[]{TrackSwitchBlock.LOCKED}));
    }

    public static <B extends ConductorWhistleFlagBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> conductorWhistleFlag() {
        return a -> a.blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(Railways.asResource("block/conductor_whistle/block_pole"))).build()));
    }

    public static <B extends DieselSmokeStackBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> dieselSmokeStack() {
        return a -> a.blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(Railways.asResource("block/smokestack/block_diesel_case"))).build()));
    }

    public static <B extends VentBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> conductorVent() {
        return a -> a.blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile((Boolean)state.getValue((Property)VentBlock.CONDUCTOR_VISIBLE) != false ? Railways.asResource("block/copycat_vent_visible") : ResourceLocation.withDefaultNamespace((String)"block/air"))).build()));
    }

    public static <B extends InvisibleMonoBogeyBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> invisibleMonoBogey() {
        return b -> ((BlockBuilder)b.initialProperties(SharedProperties::softMetal).properties(p -> p.sound(SoundType.NETHERITE_BLOCK)).properties(p -> p.noOcclusion()).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> BlockStateGen.horizontalAxisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, s -> p.models().getExistingFile(p.modLoc("block/bogey/invisible_monorail/top" + ((Boolean)s.getValue((Property)AbstractMonoBogeyBlock.UPSIDE_DOWN) != false ? "_upside_down" : ""))))).loot((p, l) -> p.dropOther((Block)l, (ItemLike)AllBlocks.RAILWAY_CASING.get()));
    }

    public static NonNullBiConsumer<DataGenContext<Block, SmokeStackBlock>, RegistrateBlockstateProvider> defaultSmokeStack(String variant, SmokeStackBlock.RotationType rotType) {
        return (c, p) -> p.getVariantBuilder((Block)c.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName() + "_" + ((SmokestackStyle)((Object)state.getValue((Property)SmokeStackBlock.STYLE))).getBlockId(), Railways.asResource("block/smokestack/block_" + variant))).texture("0", ((SmokestackStyle)((Object)state.getValue((Property)SmokeStackBlock.STYLE))).getTexture(variant))).texture("particle", "#0")).rotationY(rotType == SmokeStackBlock.RotationType.FACING ? ((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 180) % 360 : (rotType == SmokeStackBlock.RotationType.AXIS ? (state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS) == Direction.Axis.X ? 90 : 0) : 0)).build(), new Property[]{AbstractSmokeStackBlock.ENABLED, AbstractSmokeStackBlock.POWERED, AbstractSmokeStackBlock.WATERLOGGED});
    }

    public static <B extends CasingCollisionBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> casingCollision() {
        return a -> a.blockstate((c, p) -> p.simpleBlock((Block)c.get(), (ModelFile)p.models().withExistingParent(c.getName(), p.mcLoc("block/air"))));
    }

    public static <B extends HandcarBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> handcar() {
        return b -> ((BlockBuilder)b.initialProperties(SharedProperties::softMetal).properties(p -> p.sound(SoundType.NETHERITE_BLOCK).noOcclusion()).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> BlockStateGen.horizontalAxisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, s -> p.models().getExistingFile(p.mcLoc("air")))).loot((p, l) -> p.dropOther((Block)l, (ItemLike)CRBlocks.HANDCAR.get()));
    }

    public static <B extends CRBogeyBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> standardBogey() {
        return b -> ((BlockBuilder)b.transform(BuilderTransformers.sharedBogey())).blockstate((c, p) -> BlockStateGen.horizontalAxisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, s -> p.models().getExistingFile(p.modLoc("block/bogey/top"))));
    }

    public static <B extends CRBogeyBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> wideBogey() {
        return b -> ((BlockBuilder)b.transform(BuilderTransformers.sharedBogey())).blockstate((c, p) -> BlockStateGen.horizontalAxisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, s -> p.models().getExistingFile(p.modLoc("block/bogey/wide/top"))));
    }

    public static <B extends CRBogeyBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> narrowBogey() {
        return b -> ((BlockBuilder)b.transform(BuilderTransformers.sharedBogey())).blockstate((c, p) -> BlockStateGen.horizontalAxisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, s -> p.models().getExistingFile(p.modLoc("block/bogey/narrow/top"))));
    }

    public static <B extends GenericCrossingBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> genericCrossing() {
        return b -> (BlockBuilder)b.onRegister(CreateRegistrate.blockModel(() -> GenericCrossingModel::new));
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> locoMetalBase(@Nullable DyeColor color, @Nullable String type) {
        return b -> {
            BlockBuilder out = ((BlockBuilder)b.initialProperties(SharedProperties::softMetal).properties(p -> p.mapColor(ColorUtils.mapColorFromDye(color, MapColor.COLOR_BLACK)).sound(SoundType.NETHERITE_BLOCK)).transform(TagGen.pickaxeOnly())).tag(new TagKey[]{AllTags.AllBlockTags.WRENCH_PICKUP.tag}).tag(new TagKey[]{CRTags.AllBlockTags.LOCOMETAL.tag});
            if (type != null) {
                out = out.blockstate((c, p) -> p.simpleBlock((Block)c.get(), (ModelFile)p.models().cubeAll(c.getName(), p.modLoc("block/palettes/" + BuilderTransformersImpl.colorName(color) + "/" + type))));
            }
            return out;
        };
    }

    public static <B extends RotatedPillarBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> locoMetalPillar(@Nullable DyeColor color) {
        return b -> ((BlockBuilder)b.transform(BuilderTransformersImpl.locoMetalBase(color, null))).blockstate((c, p) -> p.axisBlock((RotatedPillarBlock)c.get(), p.modLoc("block/palettes/" + BuilderTransformersImpl.colorName(color) + "/riveted_pillar_side"), p.modLoc("block/palettes/" + BuilderTransformersImpl.colorName(color) + "/riveted_pillar_top")));
    }

    public static <B extends PalettesSmokeboxBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> locoMetalSmokeBox(@Nullable DyeColor color) {
        return b -> ((BlockBuilder)b.transform(BuilderTransformersImpl.locoMetalBase(color, null))).blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> {
            Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            String name = dir.getAxis().isVertical() ? "smokebox" : "smokebox_horizontal";
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(BuilderTransformers.colorNameUnderscore(color) + "locometal_" + name, p.modLoc("block/palettes/smokebox/" + name))).texture("side", p.modLoc("block/palettes/" + BuilderTransformersImpl.colorName(color) + "/tank_side"))).texture("top", p.modLoc("block/palettes/" + BuilderTransformersImpl.colorName(color) + "/smokebox_tank_top"))).rotationX(dir == Direction.DOWN ? 180 : (dir.getAxis().isHorizontal() ? 90 : 0)).rotationY(dir.getAxis().isVertical() ? 0 : ((int)dir.toYRot() + 180) % 360).build();
        }));
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> variantBuffer() {
        return b -> (BlockBuilder)b.onRegister(CreateRegistrate.blockModel(() -> BufferModel::new));
    }

    public static <I extends Item, P> NonNullUnaryOperator<ItemBuilder<I, P>> variantBufferItem() {
        return i -> (ItemBuilder)i.onRegister(CreateRegistrate.itemModel(() -> BufferModel::new));
    }

    public static <B extends CopycatHeadstockBarsBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> copycatHeadstockBars() {
        return b -> (BlockBuilder)b.blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(p.modLoc("block/buffer/headstock/copycat_headstock_bars" + ((Boolean)state.getValue((Property)CopycatHeadstockBarsBlock.UPSIDE_DOWN) != false ? "_upside_down" : "")))).rotationY(((int)((Direction)state.getValue((Property)CopycatHeadstockBarsBlock.FACING)).toYRot() + 180) % 360).build())).onRegister(CreateRegistrate.blockModel(() -> CopycatHeadstockBarsModel::new));
    }

    private static String colorName(@Nullable DyeColor color) {
        return color == null ? "netherite" : color.name().toLowerCase(Locale.ROOT);
    }

    public static <B extends TrackBufferBlock<?>, P> NonNullUnaryOperator<BlockBuilder<B, P>> bufferBlockState(Function<BlockState, ResourceLocation> modelFunc, Function<BlockState, Direction> facingFunc) {
        return b -> b.blockstate((c, p) -> p.getVariantBuilder((Block)c.getEntry()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile((ResourceLocation)modelFunc.apply((BlockState)state))).rotationY(TrackBufferBlock.getBaseModelYRotationOf(state)).build(), new Property[]{BlockStateProperties.WATERLOGGED}));
    }

    public static <B extends MonoTrackBufferBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> monoBuffer() {
        return b -> b.blockstate((c, p) -> p.getVariantBuilder((Block)c.getEntry()).forAllStatesExcept(state -> {
            boolean hanging = (Boolean)state.getValue((Property)MonoTrackBufferBlock.UPSIDE_DOWN);
            return ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(((MonoTrackBufferBlock.Style)((Object)((Object)((Object)((Object)state.getValue(MonoTrackBufferBlock.STYLE)))))).getModel())).rotationX(hanging ? 180 : 0).rotationY(TrackBufferBlock.getBaseModelYRotationOf(state, hanging ? 0 : 180)).build();
        }, new Property[]{MonoTrackBufferBlock.WATERLOGGED}));
    }

    public static <B extends LinkPinBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> linkAndPin() {
        return b -> b.blockstate((c, p) -> p.getVariantBuilder((Block)c.getEntry()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(((LinkPinBlock.Style)((Object)state.getValue(LinkPinBlock.STYLE))).getModel())).rotationY(((int)((Direction)state.getValue((Property)LinkPinBlock.FACING)).toYRot() + 180) % 360).build(), new Property[]{LinkPinBlock.WATERLOGGED}));
    }

    public static <B extends HeadstockBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> headstock() {
        return b -> b.blockstate((c, p) -> p.getVariantBuilder((Block)c.getEntry()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(((HeadstockStyle)((Object)state.getValue(HeadstockBlock.STYLE))).getModel(false, (Boolean)state.getValue((Property)HeadstockBlock.UPSIDE_DOWN)))).rotationY(((int)((Direction)state.getValue((Property)HeadstockBlock.FACING)).toYRot() + 180) % 360).build(), new Property[]{HeadstockBlock.WATERLOGGED}));
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> invisibleBlockState() {
        return b -> b.blockstate((c, p) -> p.simpleBlock((Block)c.get(), (ModelFile)p.models().withExistingParent(c.getName(), p.modLoc("block/invisible"))));
    }

    public static <B extends CopycatHeadstockBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> copycatHeadstock() {
        return b -> (BlockBuilder)b.blockstate((c, p) -> p.getVariantBuilder((Block)c.getEntry()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(((HeadstockStyle)((Object)state.getValue(CopycatHeadstockBlock.STYLE))).getModel(true, (Boolean)state.getValue((Property)CopycatHeadstockBlock.UPSIDE_DOWN)))).rotationY(((int)((Direction)state.getValue((Property)HeadstockBlock.FACING)).toYRot() + 180) % 360).build(), new Property[]{HeadstockBlock.WATERLOGGED})).properties(p -> p.noOcclusion().mapColor(MapColor.NONE)).addLayer(() -> RenderType::solid).addLayer(() -> RenderType::cutout).addLayer(() -> RenderType::cutoutMipped).addLayer(() -> RenderType::translucent).color(() -> CopycatBlock::wrappedColor).onRegister(CreateRegistrate.blockModel(() -> CopycatHeadstockModel::new));
    }

    public static <I extends Item, P> NonNullUnaryOperator<ItemBuilder<I, P>> copycatHeadstockItem() {
        return i -> (ItemBuilder)i.color(() -> CopycatHeadstockBlock::wrappedItemColor).onRegister(CreateRegistrate.itemModel(() -> CopycatHeadstockModel::new));
    }

    public static <B extends GenericDyeableSingleBufferBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> bigBuffer() {
        return b -> b.blockstate((c, p) -> p.getVariantBuilder((Block)c.getEntry()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(p.modLoc("block/buffer/single_deco/big_buffer"))).rotationY(((int)((Direction)state.getValue((Property)GenericDyeableSingleBufferBlock.FACING)).toYRot() + 180) % 360).build(), new Property[]{GenericDyeableSingleBufferBlock.WATERLOGGED}));
    }

    public static <B extends GenericDyeableSingleBufferBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> smallBuffer() {
        return b -> b.blockstate((c, p) -> p.getVariantBuilder((Block)c.getEntry()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(p.modLoc("block/buffer/single_deco/small_buffer"))).rotationY(((int)((Direction)state.getValue((Property)GenericDyeableSingleBufferBlock.FACING)).toYRot() + 180) % 360).build(), new Property[]{GenericDyeableSingleBufferBlock.WATERLOGGED}));
    }
}

