/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.base.data;

import com.railwayteam.railways.base.data.neoforge.CRTagGenImpl;
import com.railwayteam.railways.multiloader.CommonTags;
import com.railwayteam.railways.registry.CRTags;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.decoration.girder.GirderBlock;
import com.simibubi.create.content.decoration.girder.GirderEncasedShaftBlock;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;

public class CRTagGen {
    private static final Map<TagKey<Block>, List<ResourceLocation>> OPTIONAL_TAGS = new HashMap<TagKey<Block>, List<ResourceLocation>>();

    @SafeVarargs
    public static void addOptionalTag(ResourceLocation id, TagKey<Block> ... tags) {
        for (TagKey<Block> tag : tags) {
            OPTIONAL_TAGS.computeIfAbsent(tag, e -> new ArrayList()).add(id);
        }
    }

    public static void generateBlockTags(RegistrateTagsProvider<Block> prov) {
        prov.addTag(CRTags.AllBlockTags.SEMAPHORE_POLES.tag).add(new ResourceKey[]{((GirderBlock)AllBlocks.METAL_GIRDER.get()).builtInRegistryHolder().key(), ((GirderEncasedShaftBlock)AllBlocks.METAL_GIRDER_ENCASED_SHAFT.get()).builtInRegistryHolder().key()}).addTag(BlockTags.FENCES);
        prov.addTag(CRTags.AllBlockTags.TRACK_CASING_BLACKLIST.tag);
        for (CRTags.AllBlockTags tag : CRTags.AllBlockTags.values()) {
            if (!tag.alwaysDatagen) continue;
            CRTagGen.tagAppender(prov, tag);
        }
        for (TagKey tagKey : OPTIONAL_TAGS.keySet()) {
            TagsProvider.TagAppender<Block> appender = CRTagGen.tagAppender(prov, tagKey);
            for (ResourceLocation loc : OPTIONAL_TAGS.get(tagKey)) {
                appender.addOptional(loc);
            }
        }
    }

    public static void generateItemTags(RegistrateTagsProvider<Item> prov) {
        CommonTags.DYES.forEach((color, tag) -> CRTagGen.tagAppender(prov, tag.tag).add(CRTagGen.getDyeItem(color).builtInRegistryHolder().key()));
        CRTagGen.tagAppender(prov, CommonTags.IRON_NUGGETS.tag).add(Items.IRON_NUGGET.builtInRegistryHolder().key());
        CRTagGen.tagAppender(prov, CommonTags.ZINC_NUGGETS.tag).add(((Item)AllItems.ZINC_NUGGET.get()).builtInRegistryHolder().key());
        CRTagGen.tagAppender(prov, CommonTags.BRASS_NUGGETS.tag).add(((Item)AllItems.BRASS_NUGGET.get()).builtInRegistryHolder().key());
        CRTagGen.tagAppender(prov, CommonTags.COPPER_INGOTS.tag).add(Items.COPPER_INGOT.builtInRegistryHolder().key());
        CRTagGen.tagAppender(prov, CommonTags.BRASS_INGOTS.tag).add(((Item)AllItems.BRASS_INGOT.get()).builtInRegistryHolder().key());
        CRTagGen.tagAppender(prov, CommonTags.IRON_INGOTS.tag).add(Items.IRON_INGOT.builtInRegistryHolder().key());
        CRTagGen.tagAppender(prov, CommonTags.STRING.tag).add(Items.STRING.builtInRegistryHolder().key());
        CRTagGen.tagAppender(prov, CommonTags.IRON_PLATES.tag).add(((Item)AllItems.IRON_SHEET.get()).builtInRegistryHolder().key());
        CRTagGen.tagAppender(prov, CommonTags.BRASS_PLATES.tag).add(((Item)AllItems.BRASS_SHEET.get()).builtInRegistryHolder().key());
        CRTagGen.tagAppender(prov, CommonTags.WORKBENCH.tag).add(Items.CRAFTING_TABLE.builtInRegistryHolder().key());
        prov.addTag(CRTags.AllItemTags.NOT_TRAIN_FUEL.tag);
        for (CRTags.AllItemTags tag2 : CRTags.AllItemTags.values()) {
            if (!tag2.alwaysDatagen) continue;
            CRTagGen.tagAppender(prov, tag2);
        }
    }

    private static Item getDyeItem(DyeColor color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case DyeColor.BLACK -> Items.BLACK_DYE;
            case DyeColor.BLUE -> Items.BLUE_DYE;
            case DyeColor.BROWN -> Items.BROWN_DYE;
            case DyeColor.CYAN -> Items.CYAN_DYE;
            case DyeColor.GRAY -> Items.GRAY_DYE;
            case DyeColor.GREEN -> Items.GREEN_DYE;
            case DyeColor.LIGHT_BLUE -> Items.LIGHT_BLUE_DYE;
            case DyeColor.LIGHT_GRAY -> Items.LIGHT_GRAY_DYE;
            case DyeColor.LIME -> Items.LIME_DYE;
            case DyeColor.MAGENTA -> Items.MAGENTA_DYE;
            case DyeColor.ORANGE -> Items.ORANGE_DYE;
            case DyeColor.PINK -> Items.PINK_DYE;
            case DyeColor.PURPLE -> Items.PURPLE_DYE;
            case DyeColor.RED -> Items.RED_DYE;
            case DyeColor.WHITE -> Items.WHITE_DYE;
            case DyeColor.YELLOW -> Items.YELLOW_DYE;
        };
    }

    public static TagsProvider.TagAppender<Item> tagAppender(RegistrateTagsProvider<Item> prov, CRTags.AllItemTags tag) {
        return CRTagGen.tagAppender(prov, tag.tag);
    }

    public static TagsProvider.TagAppender<Block> tagAppender(RegistrateTagsProvider<Block> prov, CRTags.AllBlockTags tag) {
        return CRTagGen.tagAppender(prov, tag.tag);
    }

    public static <T> TagsProvider.TagAppender<T> tagAppender(RegistrateTagsProvider<T> prov, TagKey<T> tag) {
        return CRTagGenImpl.tagAppender(prov, tag);
    }
}

