/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways;

import com.railwayteam.railways.ModSetup;
import com.railwayteam.railways.base.data.compat.emi.EmiExcludedTagGen;
import com.railwayteam.railways.base.data.compat.emi.EmiRecipeDefaultsGen;
import com.railwayteam.railways.compat.Mods;
import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.multiloader.Loader;
import com.railwayteam.railways.neoforge.RailwaysImpl;
import com.railwayteam.railways.registry.CRCommands;
import com.railwayteam.railways.registry.CRCreativeModeTabs;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.util.Utils;
import com.simibubi.create.CreateBuildInfo;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.Function;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.MixinEnvironment;

public class Railways {
    public static final String MOD_ID = "railways";
    public static final String ID_NAME = "Railways";
    public static final String NAME = "Steam 'n' Rails";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Railways");
    public static final int DATA_FIXER_VERSION = 2;
    private static final CreateRegistrate REGISTRATE = CreateRegistrate.create((String)"railways");

    private static void migrateConfig(Path path, Function<String, String> converter) {
        block9: {
            try {
                String migrated;
                String str = new String(Files.readAllBytes(path));
                if (!str.contains("#General settings") && !str.contains("[general]")) break block9;
                try {
                    migrated = converter.apply(new String(Files.readAllBytes(path)));
                }
                catch (IOException e) {
                    break block9;
                }
                try (FileWriter writer = new FileWriter(path.toFile());){
                    writer.write(migrated);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void init() {
        LOGGER.info("{} v{} initializing! Commit hash: {} on Create version: {} on platform: {}", new Object[]{NAME, "1.6.13-alpha", "dev", CreateBuildInfo.VERSION, Loader.getFormatted()});
        Path configDir = Utils.configDir();
        Path clientConfigDir = configDir.resolve("railways-client.toml");
        Railways.migrateConfig(clientConfigDir, CRConfigs::migrateClient);
        Path commonConfigDir = configDir.resolve("railways-common.toml");
        Railways.migrateConfig(commonConfigDir, CRConfigs::migrateCommon);
        ModSetup.register();
        RailwaysImpl.finalizeRegistrate();
        if (Utils.isDevEnv()) {
            try {
                int itemCount = Railways.registrate().getAll(Registries.ITEM).size();
                int blockCount = Railways.registrate().getAll(Registries.BLOCK).size();
                LOGGER.info("[Dev] Registrate entries -> items: {}, blocks: {}", (Object)itemCount, (Object)blockCount);
                CRCreativeModeTabs.devLogTabCounts();
            }
            catch (Throwable t) {
                LOGGER.debug("[Dev] Failed to count Registrate entries", t);
            }
        }
        RailwaysImpl.registerCommands(CRCommands::register);
        CRPackets.PACKETS.registerC2SListener();
        if (!(!Utils.isDevEnv() || Loader.FORGE.isCurrent() || Loader.NEOFORGE.isCurrent() || Mods.BYG.isLoaded || Mods.SODIUM.isLoaded || Utils.isEnvVarTrue("DATAGEN"))) {
            MixinEnvironment.getCurrentEnvironment().audit();
        }
    }

    public static ResourceLocation asResource(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }

    public static void gatherData(DataGenerator.PackGenerator gen) {
        gen.addProvider(EmiExcludedTagGen::new);
        gen.addProvider(EmiRecipeDefaultsGen::new);
    }

    public static CreateRegistrate registrate() {
        return REGISTRATE;
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
    }
}

