/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.core;

import io.wispforest.owo.ui.core.Animatable;
import io.wispforest.owo.ui.core.Size;
import net.minecraft.util.Mth;

public interface PositionedRectangle
extends Animatable<PositionedRectangle> {
    public int x();

    public int y();

    public int width();

    public int height();

    default public boolean isInBoundingBox(double x, double y) {
        return x >= (double)this.x() && x < (double)(this.x() + this.width()) && y >= (double)this.y() && y < (double)(this.y() + this.height());
    }

    default public boolean intersects(PositionedRectangle other) {
        return other.x() < this.x() + this.width() && other.x() + other.width() >= this.x() && other.y() < this.y() + this.height() && other.y() + other.height() >= this.y();
    }

    default public PositionedRectangle intersection(PositionedRectangle other) {
        int leftEdge = Math.max(this.x(), other.x());
        int topEdge = Math.max(this.y(), other.y());
        int rightEdge = Math.min(this.x() + this.width(), other.x() + other.width());
        int bottomEdge = Math.min(this.y() + this.height(), other.y() + other.height());
        return PositionedRectangle.of(leftEdge, topEdge, Math.max(rightEdge - leftEdge, 0), Math.max(bottomEdge - topEdge, 0));
    }

    @Override
    default public PositionedRectangle interpolate(PositionedRectangle next, float delta) {
        return PositionedRectangle.of(Mth.lerpInt((float)delta, (int)this.x(), (int)next.x()), Mth.lerpInt((float)delta, (int)this.y(), (int)next.y()), Mth.lerpInt((float)delta, (int)this.width(), (int)next.width()), Mth.lerpInt((float)delta, (int)this.height(), (int)next.height()));
    }

    public static PositionedRectangle of(int x, int y, Size size) {
        return PositionedRectangle.of(x, y, size.width(), size.height());
    }

    public static PositionedRectangle of(final int x, final int y, final int width, final int height) {
        return new PositionedRectangle(){

            @Override
            public int x() {
                return x;
            }

            @Override
            public int y() {
                return y;
            }

            @Override
            public int width() {
                return width;
            }

            @Override
            public int height() {
                return height;
            }
        };
    }
}

