/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.pack;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.List;
import net.mehvahdjukaar.moonlight.core.Moonlight;

public final class ImageMerger {
    public static NativeImage mergeSquare(List<NativeImage> images, Mode mode, int backgroundColor) {
        if (images == null || images.isEmpty()) {
            throw new IllegalArgumentException("images is empty");
        }
        Moonlight.LOGGER.info("Merging {} images using mode {}", (Object)images.size(), (Object)mode);
        int minSide = Integer.MAX_VALUE;
        int maxSide = Integer.MIN_VALUE;
        for (NativeImage img : images) {
            int h;
            if (img == null) {
                throw new IllegalArgumentException("null image");
            }
            int w = img.getWidth();
            if (w != (h = img.getHeight())) {
                throw new IllegalArgumentException("all images must be square, got " + w + "x" + h);
            }
            minSide = Math.min(minSide, w);
            maxSide = Math.max(maxSide, w);
        }
        int n = images.size();
        int g = (int)Math.ceil(Math.sqrt(n));
        int tile = mode == Mode.MIN_AREA_NO_UPSCALE ? minSide : maxSide;
        int canvas = g * tile;
        NativeImage out = new NativeImage(NativeImage.Format.RGBA, canvas, canvas, true);
        ImageMerger.fillColor(out, backgroundColor);
        int rowsUsed = (n + g - 1) / g;
        int globalYPadding = (g - rowsUsed) * tile / 2;
        for (int i = 0; i < n; ++i) {
            int colsThisRow;
            NativeImage src = images.get(i);
            int srcSize = src.getWidth();
            int row = i / g;
            int col = i % g;
            int n2 = colsThisRow = row < rowsUsed - 1 ? g : n - (rowsUsed - 1) * g;
            if (colsThisRow == 0) {
                colsThisRow = g;
            }
            int rowXPadding = (g - colsThisRow) * tile / 2;
            int cellX = rowXPadding + col * tile;
            int cellY = globalYPadding + row * tile;
            if (mode == Mode.MIN_AREA_NO_UPSCALE) {
                if (srcSize == tile) {
                    ImageMerger.blit(src, out, 0, 0, srcSize, cellX, cellY);
                    continue;
                }
                ImageMerger.blitScaledNearest(src, out, cellX, cellY, tile);
                continue;
            }
            if (srcSize > tile) {
                ImageMerger.blitScaledNearest(src, out, cellX, cellY, tile);
                continue;
            }
            int innerPad = (tile - srcSize) / 2;
            ImageMerger.blit(src, out, 0, 0, srcSize, cellX + innerPad, cellY + innerPad);
        }
        return out;
    }

    private static void fillColor(NativeImage img, int rgba) {
        int w = img.getWidth();
        int h = img.getHeight();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                img.setPixelRGBA(x, y, rgba);
            }
        }
    }

    private static void blit(NativeImage src, NativeImage dst, int sx, int sy, int size, int dx, int dy) {
        for (int y = 0; y < size; ++y) {
            int srcY = sy + y;
            int dstY = dy + y;
            for (int x = 0; x < size; ++x) {
                int rgba = src.getPixelRGBA(sx + x, srcY);
                dst.setPixelRGBA(dx + x, dstY, rgba);
            }
        }
    }

    private static void blitScaledNearest(NativeImage src, NativeImage dst, int dx, int dy, int dSize) {
        int s = src.getWidth();
        for (int y = 0; y < dSize; ++y) {
            int sy = (int)(((double)y + 0.5) * (double)s / (double)dSize);
            if (sy >= s) {
                sy = s - 1;
            }
            int dstY = dy + y;
            for (int x = 0; x < dSize; ++x) {
                int sx = (int)(((double)x + 0.5) * (double)s / (double)dSize);
                if (sx >= s) {
                    sx = s - 1;
                }
                int rgba = src.getPixelRGBA(sx, sy);
                dst.setPixelRGBA(dx + x, dstY, rgba);
            }
        }
    }

    public static enum Mode {
        MIN_AREA_NO_UPSCALE,
        NO_UPSCALE_CENTER;

    }
}

