/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.plugin.jei.display;

import java.util.List;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.common.Constants;
import net.mehvahdjukaar.jeed.common.HSLColor;
import net.mehvahdjukaar.jeed.plugin.jei.JEIPlugin;
import net.mehvahdjukaar.jeed.plugin.jei.display.EffectBox;
import net.mehvahdjukaar.jeed.plugin.jei.display.EffectInfoRecipe;
import net.mehvahdjukaar.jeed.plugin.jei.display.TabIcon;
import net.mehvahdjukaar.jeed.plugin.jei.ingredient.EffectInstanceRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.crafting.Ingredient;

public class EffectInfoRecipeCategory
implements IRecipeCategory<EffectInfoRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slotBackground;
    private final IDrawable effectBackground;

    public EffectInfoRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(Constants.RECIPE_WIDTH, Constants.RECIPE_HEIGHT);
        this.effectBackground = new EffectBox();
        this.icon = new TabIcon();
        this.slotBackground = guiHelper.getSlotDrawable();
    }

    public RecipeType<EffectInfoRecipe> getRecipeType() {
        return EffectInfoRecipe.TYPE;
    }

    public Component getTitle() {
        return Constants.LOCALIZED_NAME;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void draw(EffectInfoRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        int size;
        int xPos = 0;
        int yPos = this.effectBackground.getHeight() + 4 + Constants.Y_OFFSET;
        Font font = Minecraft.getInstance().font;
        MobEffect effect = (MobEffect)recipe.getEffect().getEffect().value();
        MutableComponent name = (MutableComponent)effect.getDisplayName();
        int color = HSLColor.getProcessedColor(effect.getColor());
        name.setStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(TextColor.fromRgb((int)color)));
        float x = (float)Constants.RECIPE_WIDTH / 2.0f - (float)font.width((FormattedText)name) / 2.0f;
        graphics.drawString(font, Language.getInstance().getVisualOrder((FormattedText)name), (int)x, 0, -16777216);
        for (FormattedText descriptionLine : recipe.getDescription()) {
            graphics.drawString(font, Language.getInstance().getVisualOrder(descriptionLine), xPos, yPos, -16777216, false);
            Objects.requireNonNull(font);
            yPos += 9 + Constants.LINE_SPACING;
        }
        if (Jeed.hasIngredientList() && (size = recipe.ingredients.size()) != 0) {
            int maxSlots = size <= Constants.SLOTS_PER_ROW ? Constants.SLOTS_PER_ROW : Constants.SLOTS_PER_ROW * Constants.ROWS;
            for (int slotId = 0; slotId < maxSlots; ++slotId) {
                int slotX = 1 + (int)((float)Constants.RECIPE_WIDTH / 2.0f + (float)Constants.SLOT_W * ((float)(slotId % Constants.SLOTS_PER_ROW) - (float)Constants.SLOTS_PER_ROW / 2.0f));
                this.slotBackground.draw(graphics, slotX, Constants.RECIPE_HEIGHT - Constants.SLOT_W * (1 + slotId / Constants.SLOTS_PER_ROW));
            }
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EffectInfoRecipe recipe, IFocusGroup focuses) {
        IIngredientType<MobEffectInstance> type = JEIPlugin.EFFECT_INGREDIENT_TYPE;
        IRecipeSlotBuilder mainSlot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, (Constants.RECIPE_WIDTH - 18) / 2, Constants.Y_OFFSET + 3).setCustomRenderer(type, (IIngredientRenderer)EffectInstanceRenderer.INSTANCE_SLOT).addIngredient(type, (Object)recipe.getEffect());
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addIngredient(type, (Object)recipe.getEffect());
        if (Jeed.hasEffectBox()) {
            mainSlot.setBackground(this.effectBackground, -3, -3);
        }
        if (Jeed.hasIngredientList()) {
            List<Ingredient> slotContents = recipe.slots;
            int rowsCount = slotContents.size() <= Constants.SLOTS_PER_ROW ? 1 : Constants.ROWS;
            for (int slotId = 0; slotId < slotContents.size(); ++slotId) {
                int x = (int)((float)Constants.RECIPE_WIDTH / 2.0f + (float)Constants.ROWS + (float)Constants.SLOT_W * ((float)(slotId % Constants.SLOTS_PER_ROW) - (float)Constants.SLOTS_PER_ROW / 2.0f));
                int y = 1 + Constants.RECIPE_HEIGHT - Constants.SLOT_W * (rowsCount - slotId / Constants.SLOTS_PER_ROW);
                builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients(slotContents.get(slotId));
            }
        }
    }
}

