/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.plugin.jei;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.rei.plugincompatibilities.api.REIPluginCompatIgnore;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.builder.IClickableIngredientFactory;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientVisibility;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.api.IEffectScreenExtension;
import net.mehvahdjukaar.jeed.common.IPlugin;
import net.mehvahdjukaar.jeed.common.ScreenExtensionsHandler;
import net.mehvahdjukaar.jeed.plugin.jei.display.EffectInfoRecipe;
import net.mehvahdjukaar.jeed.plugin.jei.display.EffectInfoRecipeCategory;
import net.mehvahdjukaar.jeed.plugin.jei.ingredient.EffectInstanceHelper;
import net.mehvahdjukaar.jeed.plugin.jei.ingredient.EffectInstanceRenderer;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Items;

@REIPluginCompatIgnore
@JeiPlugin
public class JEIPlugin
implements IModPlugin,
IPlugin {
    private static final ResourceLocation ID = Jeed.res("jei_plugin");
    public static final IIngredientType<MobEffectInstance> EFFECT_INGREDIENT_TYPE = () -> MobEffectInstance.class;
    public static IJeiRuntime JEI_RUNTIME;
    public static IJeiHelpers JEI_HELPERS;
    public static IIngredientVisibility JEI_INGREDIENT_VISIBILITY;

    public JEIPlugin() {
        if (Jeed.EMI) {
            return;
        }
        Jeed.PLUGIN = this;
    }

    @Override
    public boolean rendersTooltips() {
        return true;
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        if (Jeed.EMI || Jeed.REI) {
            return;
        }
        registry.addRecipeCategories(new IRecipeCategory[]{new EffectInfoRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        if (Jeed.EMI || Jeed.REI) {
            return;
        }
        registration.register(EFFECT_INGREDIENT_TYPE, Jeed.getEffectList().stream().map(MobEffectInstance::new).toList(), (IIngredientHelper)new EffectInstanceHelper(), (IIngredientRenderer)EffectInstanceRenderer.INSTANCE, MobEffectInstance.CODEC);
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JEI_RUNTIME = jeiRuntime;
    }

    public void registerRecipes(IRecipeRegistration registry) {
        if (Jeed.EMI || Jeed.REI) {
            return;
        }
        JEI_INGREDIENT_VISIBILITY = registry.getJeiHelpers().getIngredientVisibility();
        JEI_HELPERS = registry.getJeiHelpers();
        for (Holder.Reference<MobEffect> e : Jeed.getEffectList()) {
            List<EffectInfoRecipe> recipes = EffectInfoRecipe.create(e);
            registry.addRecipes(EffectInfoRecipe.TYPE, recipes);
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        if (Jeed.EMI || Jeed.REI) {
            return;
        }
        for (Map.Entry<Class<AbstractContainerScreen<?>>, IEffectScreenExtension<AbstractContainerScreen<?>>> e : ScreenExtensionsHandler.EXTENSIONS.entrySet()) {
            Class<? extends AbstractContainerScreen<?>> screenClass = e.getKey();
            IEffectScreenExtension<? extends AbstractContainerScreen<?>> effect = e.getValue();
            ScreenExtension extension = new ScreenExtension(effect);
            registration.addGuiContainerHandler(screenClass, extension);
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        if (Jeed.EMI || Jeed.REI) {
            return;
        }
        registration.addRecipeCatalyst(Items.POTION.getDefaultInstance(), new RecipeType[]{EffectInfoRecipe.TYPE});
    }

    @Override
    public void onClickedEffect(MobEffectInstance effect, double x, double y, int button) {
        if (Jeed.EMI || Jeed.REI) {
            return;
        }
        IFocus focus = JEI_HELPERS.getFocusFactory().createFocus(RecipeIngredientRole.INPUT, EFFECT_INGREDIENT_TYPE, (Object)effect);
        IRecipesGui recipesGui = JEI_RUNTIME.getRecipesGui();
        recipesGui.show(focus);
    }

    public record ScreenExtension<T extends AbstractContainerScreen<?>>(IEffectScreenExtension<T> ext) implements IGuiContainerHandler<T>
    {
        public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(IClickableIngredientFactory builder, T containerScreen, double mouseX, double mouseY) {
            MobEffectInstance v = this.ext.getEffectAtPosition(containerScreen, mouseX, mouseY, IEffectScreenExtension.CallReason.RECIPE_KEY);
            if (v != null) {
                builder.createBuilder(EFFECT_INGREDIENT_TYPE, (Object)v).buildWithArea((int)mouseX, (int)mouseY, 1, 1);
            }
            return Optional.empty();
        }
    }
}

