/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.network.s2c;

import immersive_melodies.Common;
import immersive_melodies.Config;
import immersive_melodies.network.ImmersivePayload;
import immersive_melodies.resources.MelodyDescriptor;
import immersive_melodies.resources.MelodyLoader;
import immersive_melodies.resources.ServerMelodyManager;
import immersive_melodies.util.Utils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record MelodyListMessage(Map<ResourceLocation, MelodyDescriptor> melodies) implements ImmersivePayload
{
    public static final CustomPacketPayload.Type<MelodyListMessage> TYPE = new CustomPacketPayload.Type(Common.locate("melody_list_message"));
    public static final StreamCodec<FriendlyByteBuf, MelodyListMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceLocation.STREAM_CODEC, MelodyDescriptor.STREAM_CODEC), MelodyListMessage::melodies, MelodyListMessage::new);

    public MelodyListMessage(Player receiver) {
        this(MelodyListMessage.createMelodiesMap(receiver));
    }

    private static Map<ResourceLocation, MelodyDescriptor> createMelodiesMap(Player receiver) {
        HashMap<ResourceLocation, MelodyDescriptor> melodies = new HashMap<ResourceLocation, MelodyDescriptor>();
        for (Map.Entry<ResourceLocation, MelodyLoader.LazyMelody> lazyMelodyEntry : ServerMelodyManager.getDatapackMelodies().entrySet()) {
            melodies.put(lazyMelodyEntry.getKey(), lazyMelodyEntry.getValue().getDescriptor());
        }
        if (Config.getInstance().showOtherPlayersMelodies) {
            melodies.putAll(ServerMelodyManager.getIndex().getMelodies());
        } else {
            ServerMelodyManager.getIndex().getMelodies().forEach((id, desc) -> {
                if (Utils.ownsMelody(id, receiver)) {
                    melodies.put((ResourceLocation)id, (MelodyDescriptor)desc);
                }
            });
        }
        return melodies;
    }

    @Override
    public void handle(Player e) {
        Common.networkManager.handleMelodyListMessage(this);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

