/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.network.c2s;

import immersive_melodies.Common;
import immersive_melodies.item.InstrumentItem;
import immersive_melodies.network.ImmersivePayload;
import immersive_melodies.resources.ServerMelodyManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record TrackToggleMessage(ResourceLocation melody, int track, boolean enabled) implements ImmersivePayload
{
    public static final CustomPacketPayload.Type<TrackToggleMessage> TYPE = new CustomPacketPayload.Type(Common.locate("track_toggle_message"));
    public static final StreamCodec<FriendlyByteBuf, TrackToggleMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, TrackToggleMessage::melody, (StreamCodec)ByteBufCodecs.INT, TrackToggleMessage::track, (StreamCodec)ByteBufCodecs.BOOL, TrackToggleMessage::enabled, TrackToggleMessage::new);

    @Override
    public void handle(Player e) {
        e.getHandSlots().forEach(stack -> {
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof InstrumentItem) {
                InstrumentItem item = (InstrumentItem)patt0$temp;
                ServerMelodyManager.MelodyTrackSettings settings = ServerMelodyManager.getSettings();
                String identifier = ServerMelodyManager.getIdentifier((Entity)e, item);
                if (this.enabled) {
                    settings.enableTrack(this.melody, identifier, this.track);
                } else {
                    settings.disableTrack(this.melody, identifier, this.track);
                }
                item.refreshTracks((ItemStack)stack, (Entity)e);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

