/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.network;

import immersive_melodies.network.ImmersivePayload;
import immersive_melodies.network.c2s.ItemActionMessage;
import immersive_melodies.network.c2s.MelodyDeleteRequest;
import immersive_melodies.network.c2s.MelodyRequest;
import immersive_melodies.network.c2s.NoteBroadcastRequest;
import immersive_melodies.network.c2s.TrackToggleMessage;
import immersive_melodies.network.c2s.UploadMelodyRequest;
import immersive_melodies.network.s2c.MelodyListMessage;
import immersive_melodies.network.s2c.MelodyResponse;
import immersive_melodies.network.s2c.NoteMessage;
import immersive_melodies.network.s2c.OpenGuiRequest;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;

public class Network {
    private static Sender sender;
    private static ClientSender clientSender;

    public static void registerSender(Sender sender) {
        Network.sender = sender;
    }

    public static void registerClientSender(ClientSender clientSender) {
        Network.clientSender = clientSender;
    }

    public static void sendToServer(ImmersivePayload payload) {
        clientSender.sendToServer(payload);
    }

    public static void sendToPlayer(ImmersivePayload payload, ServerPlayer player) {
        sender.sendToPlayer(player, payload);
    }

    public static void register(Registrar c) {
        c.register(ItemActionMessage.TYPE, ItemActionMessage.STREAM_CODEC, true);
        c.register(MelodyDeleteRequest.TYPE, MelodyDeleteRequest.STREAM_CODEC, true);
        c.register(MelodyRequest.TYPE, MelodyRequest.STREAM_CODEC, true);
        c.register(NoteBroadcastRequest.TYPE, NoteBroadcastRequest.STREAM_CODEC, true);
        c.register(TrackToggleMessage.TYPE, TrackToggleMessage.STREAM_CODEC, true);
        c.register(UploadMelodyRequest.TYPE, UploadMelodyRequest.STREAM_CODEC, true);
        c.register(MelodyListMessage.TYPE, MelodyListMessage.STREAM_CODEC, false);
        c.register(MelodyResponse.TYPE, MelodyResponse.STREAM_CODEC, false);
        c.register(NoteMessage.TYPE, NoteMessage.STREAM_CODEC, false);
        c.register(OpenGuiRequest.TYPE, OpenGuiRequest.STREAM_CODEC, false);
    }

    public static interface Sender {
        public void sendToPlayer(ServerPlayer var1, ImmersivePayload var2);
    }

    public static interface ClientSender {
        public void sendToServer(ImmersivePayload var1);
    }

    public static interface Registrar {
        public <T extends ImmersivePayload> void register(CustomPacketPayload.Type<T> var1, StreamCodec<FriendlyByteBuf, T> var2, boolean var3);
    }
}

