/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies;

import immersive_melodies.Common;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public interface Sounds {
    public static final Map<ResourceLocation, SoundEvent> sounds = new ConcurrentHashMap<ResourceLocation, SoundEvent>();

    public static SoundEvent register(String namespace, String path) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
        SoundEvent event = SoundEvent.createVariableRangeEvent((ResourceLocation)id);
        sounds.put(id, event);
        return event;
    }

    public static void registerSounds(Common.RegisterHelper<SoundEvent> helper) {
        sounds.forEach(helper::register);
    }

    public static class Instrument {
        List<SoundEvent> octaves = new LinkedList<SoundEvent>();

        public Instrument(String namespace, String name) {
            for (int octave = 1; octave <= 8; ++octave) {
                this.octaves.add(Sounds.register(namespace, name + ".c" + octave));
            }
        }

        public SoundEvent get(int octave) {
            return this.octaves.get(octave - 1);
        }
    }
}

