/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies;

import immersive_melodies.Common;
import immersive_melodies.MidiListener;
import immersive_melodies.client.sound.CancelableSoundInstance;
import immersive_melodies.client.sound.SoundManagerImpl;
import immersive_melodies.item.InstrumentItem;
import immersive_melodies.network.ClientNetworkManager;
import immersive_melodies.network.Network;
import immersive_melodies.network.c2s.ItemActionMessage;
import immersive_melodies.network.c2s.NoteBroadcastRequest;
import immersive_melodies.resources.Note;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class Client {
    private static final Map<Integer, CancelableSoundInstance> playingSounds = new ConcurrentHashMap<Integer, CancelableSoundInstance>();

    public static void postLoad() {
        Minecraft client = Minecraft.getInstance();
        Common.networkManager = new ClientNetworkManager();
        Common.soundManager = new SoundManagerImpl(client);
        MidiListener.launch();
    }

    public static void playNote(int tone, int velocity) {
        Minecraft client = Minecraft.getInstance();
        if (client.player != null && !client.isPaused() && Client.playNote((LivingEntity)client.player, tone, velocity)) {
            Network.sendToServer(new NoteBroadcastRequest(tone, velocity));
        }
    }

    public static boolean playNote(LivingEntity entity, int tone, int velocity) {
        for (ItemStack stack : entity.getAllSlots()) {
            Item item = stack.getItem();
            if (!(item instanceof InstrumentItem)) continue;
            InstrumentItem instrument = (InstrumentItem)item;
            if (entity instanceof LocalPlayer && instrument.isPlaying(stack)) {
                Network.sendToServer(ItemActionMessage.fromState(ItemActionMessage.State.PAUSE));
            }
            if (velocity > 0) {
                if (playingSounds.containsKey(tone)) break;
                Note note = new Note(tone, velocity, 0, 10000, 200);
                CancelableSoundInstance soundInstance = instrument.playNote((Entity)entity, note, 0L);
                playingSounds.put(tone, soundInstance);
                return true;
            }
            CancelableSoundInstance soundInstance = playingSounds.get(tone);
            if (soundInstance == null) break;
            soundInstance.cancel();
            playingSounds.remove(tone);
            return true;
        }
        return false;
    }
}

