/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbxmodcompat.ftbquests.jei;

import com.mojang.blaze3d.platform.InputConstants;
import dev.ftb.mods.ftbquests.registry.ModItems;
import dev.ftb.mods.ftbxmodcompat.ftbquests.jei.JEIRecipeTypes;
import dev.ftb.mods.ftbxmodcompat.ftbquests.recipemod_common.WrappedQuest;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class QuestCategory
implements IRecipeCategory<WrappedQuest> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"ftbquests", (String)"textures/gui/jei/quest.png");
    private static final ScreenRectangle INPUT_AREA = new ScreenRectangle(0, 0, 144, 20);
    private final IDrawable background;
    private final IDrawable icon;

    public QuestCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 144, 74);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItems.BOOK.get()));
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, WrappedQuest recipe, IFocusGroup focuses) {
        builder.addInputHandler((IJeiInputHandler)new ClickHandler(INPUT_AREA, recipe));
    }

    public Component getTitle() {
        return Component.translatable((String)"ftbquests.quests");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public RecipeType<WrappedQuest> getRecipeType() {
        return JEIRecipeTypes.QUEST;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, WrappedQuest recipe, IFocusGroup focuses) {
        int inputSize = Math.min(9, recipe.input.size());
        for (int i = 0; i < inputSize; ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, i % 3 * 18 + 1, i / 3 * 18 + 21).addItemStacks(recipe.input.get(i));
        }
        int outputSize = Math.min(9, recipe.output.size());
        for (int i = 0; i < outputSize; ++i) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, i % 3 * 18 + 90 + 1, i / 3 * 18 + 21).addItemStacks(recipe.output.get(i));
        }
    }

    /*
     * Unable to fully structure code
     */
    public void draw(WrappedQuest recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        text = recipe.quest.getTitle().copy().withStyle(ChatFormatting.UNDERLINE);
        font = Minecraft.getInstance().font;
        w = font.width((FormattedText)text);
        x = (this.background.getWidth() - w) / 2;
        y = 3;
        if (!(mouseX >= (double)x) || !(mouseY >= (double)y) || !(mouseX < (double)(x + w))) ** GOTO lbl-1000
        Objects.requireNonNull(font);
        if (mouseY < (double)(y + 9)) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        highlight = v0;
        graphics.drawString(font, (Component)text, x, y, highlight != false ? -5735842 : -12636637, false);
    }

    public record ClickHandler(ScreenRectangle area, WrappedQuest recipe) implements IJeiInputHandler
    {
        public ScreenRectangle getArea() {
            return this.area;
        }

        public boolean handleInput(double mouseX, double mouseY, IJeiUserInput input) {
            if (input.getKey().getType() == InputConstants.Type.MOUSE) {
                this.recipe.openQuestGui();
                return true;
            }
            return false;
        }
    }
}

