/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.FTBLibraryCommands;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public record EditNBTResponsePacket(CompoundTag info, CompoundTag tag) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<EditNBTResponsePacket> TYPE = new CustomPacketPayload.Type(FTBLibrary.rl("edit_nbt_response"));
    public static StreamCodec<FriendlyByteBuf, EditNBTResponsePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, EditNBTResponsePacket::info, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, EditNBTResponsePacket::tag, EditNBTResponsePacket::new);

    public static void handle(EditNBTResponsePacket packet, NetworkManager.PacketContext context) {
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            CompoundTag info = packet.info;
            CompoundTag tag = packet.tag;
            if (info.equals((Object)FTBLibraryCommands.EDITING_NBT.remove(player.getUUID()))) {
                switch (info.getString("type")) {
                    case "block": {
                        BlockEntity blockEntity;
                        BlockPos pos = new BlockPos(info.getInt("x"), info.getInt("y"), info.getInt("z"));
                        if (!player.level().isLoaded(pos) || (blockEntity = player.level().getBlockEntity(pos)) == null) break;
                        tag.putInt("x", pos.getX());
                        tag.putInt("y", pos.getY());
                        tag.putInt("z", pos.getZ());
                        tag.putString("id", info.getString("id"));
                        blockEntity.loadWithComponents(tag, (HolderLookup.Provider)player.level().registryAccess());
                        blockEntity.setChanged();
                        player.level().sendBlockUpdated(pos, blockEntity.getBlockState(), blockEntity.getBlockState(), 3);
                        break;
                    }
                    case "entity": {
                        Entity entity = player.level().getEntity(info.getInt("id"));
                        if (entity == null) break;
                        UUID uUID = entity.getUUID();
                        entity.load(tag);
                        entity.setUUID(uUID);
                        break;
                    }
                    case "player": {
                        ServerPlayer player1 = player.getServer().getPlayerList().getPlayer(info.getUUID("id"));
                        if (player1 == null) break;
                        UUID uUID = player1.getUUID();
                        player1.load(tag);
                        player1.setUUID(uUID);
                        player1.moveTo(player1.getX(), player1.getY(), player1.getZ());
                        break;
                    }
                    case "item": {
                        ItemStack.parse((HolderLookup.Provider)player.registryAccess(), (Tag)tag).ifPresent(stack -> player.setItemInHand(InteractionHand.MAIN_HAND, stack));
                    }
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

