/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.mapicon;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.RegistrarManager;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import dev.ftb.mods.ftbchunks.client.mapicon.EntityImageIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class EntityIcons
extends SimplePreparableReloadListener<Map<EntityType<?>, EntityIconSettings>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Icon NORMAL = Icon.getIcon((String)"ftbchunks:textures/faces/normal.png");
    public static final Icon HOSTILE = Icon.getIcon((String)"ftbchunks:textures/faces/hostile.png");
    private static final Map<EntityType<?>, Map<ResourceLocation, Icon>> ICON_CACHE = new HashMap();
    private static final Map<EntityType<?>, EntityIconSettings> ENTITY_SETTINGS = new HashMap();
    public static final Map<EntityType<?>, Boolean> IS_USING_NEW_JSON = new HashMap();

    protected Map<EntityType<?>, EntityIconSettings> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap map = new HashMap();
        for (Map.Entry entry : RegistrarManager.get((String)"ftbchunks").get(Registries.ENTITY_TYPE).entrySet()) {
            Map stringBooleanMap;
            Optional resource;
            ResourceLocation id = ((ResourceKey)entry.getKey()).location();
            EntityType entityType = (EntityType)entry.getValue();
            ResourceKey registryName = (ResourceKey)BuiltInRegistries.ENTITY_TYPE.getResourceKey((Object)entityType).orElseThrow();
            String basePath = EntityIcons.getBasePath(id);
            ResourceLocation invisible = FTBChunksAPI.rl(basePath + ".invisible");
            EntityIconSettings entityIconSettings = null;
            if (resourceManager.getResource(invisible).isPresent()) {
                LOGGER.error("Entity {} is using legacy invisible texture, please update it to use the new system!", (Object)id);
                entityIconSettings = EntityIconSettings.OLD_HIDDEN;
            }
            if ((resource = resourceManager.getResource(FTBChunksAPI.rl(basePath + ".json"))).isPresent()) {
                entityIconSettings = this.getEntitySetting(id, (Resource)resource.get());
                IS_USING_NEW_JSON.put(entityType, true);
            } else {
                ResourceLocation rl = FTBChunksAPI.rl(basePath + ".png");
                Optional pic = resourceManager.getResource(rl);
                if (pic.isPresent()) {
                    entityIconSettings = new EntityIconSettings(false, Optional.of(rl), Optional.empty(), List.of(), WidthHeight.DEFAULT, 1.0, true);
                }
            }
            if (entityIconSettings == null) {
                if (entityType.getCategory() == MobCategory.MISC || !Platform.isDevelopmentEnvironment()) continue;
                LOGGER.error("Missing entity icon settings for {}", (Object)id);
                entityIconSettings = EntityIconSettings.OLD_HIDDEN;
            }
            if (!(stringBooleanMap = (Map)FTBChunksClientConfig.ENTITY_ICON.get()).containsKey(registryName)) {
                stringBooleanMap.put(registryName, entityIconSettings.defaultEnabled);
                FTBChunksClientConfig.saveConfig();
            }
            map.put(entityType, entityIconSettings);
        }
        return map;
    }

    public static boolean canTypeRenderer(EntityType<?> type) {
        if (type == EntityType.PLAYER) {
            return false;
        }
        Optional<EntityIconSettings> settings = EntityIcons.getSettings(type);
        return settings.isPresent();
    }

    public static boolean shouldEntityRender(Entity entity, Player player) {
        if (!EntityIcons.canTypeRenderer(entity.getType())) {
            return false;
        }
        if (entity.isInvisibleTo(player)) {
            return false;
        }
        Optional registryName = BuiltInRegistries.ENTITY_TYPE.getResourceKey((Object)entity.getType());
        if (registryName.isEmpty()) {
            return false;
        }
        return ((Map)FTBChunksClientConfig.ENTITY_ICON.get()).getOrDefault(registryName.get(), true);
    }

    private static String getBasePath(ResourceLocation id) {
        return "textures/faces/" + id.getNamespace() + "/" + id.getPath();
    }

    private EntityIconSettings getEntitySetting(ResourceLocation id, Resource resource) {
        try {
            JsonElement jsonElement = (JsonElement)GsonHelper.fromJson((Gson)GSON, (Reader)resource.openAsReader(), JsonElement.class);
            DataResult settings = EntityIconSettings.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement);
            return (EntityIconSettings)settings.getOrThrow();
        }
        catch (IOException e) {
            LOGGER.error("Failed to load entity icon settings for {}", (Object)id, (Object)e);
        }
        catch (IllegalStateException e) {
            LOGGER.error("Failed to parse entity icon settings for {}", (Object)id, (Object)e);
        }
        return null;
    }

    private static Optional<Icon> getIconCache(Entity entity) {
        return EntityIcons.getSettings(entity.getType()).map(settings -> {
            if (settings.useMobTexture) {
                return EntityIcons.getOrCreateIcon(entity.getType(), Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(entity).getTextureLocation(entity), settings);
            }
            return settings.texture.map(resourceLocation -> EntityIcons.getOrCreateIcon(entity.getType(), resourceLocation, settings)).orElse(null);
        });
    }

    public static Optional<EntityIconSettings> getSettings(EntityType<?> entityType) {
        return Optional.ofNullable(ENTITY_SETTINGS.get(entityType));
    }

    private static Icon getOrCreateIcon(EntityType<?> entityType, ResourceLocation texture, EntityIconSettings settings) {
        return ICON_CACHE.computeIfAbsent(entityType, i -> new HashMap()).computeIfAbsent(texture, t -> new EntityImageIcon((ResourceLocation)t, settings.mainSlice.orElse(null), settings.children));
    }

    protected void apply(Map<EntityType<?>, EntityIconSettings> entityIconDataMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        ICON_CACHE.clear();
        ENTITY_SETTINGS.clear();
        ENTITY_SETTINGS.putAll(entityIconDataMap);
    }

    public static Icon getIcon(Entity entity) {
        return EntityIcons.getIconCache(entity).orElseGet(() -> entity instanceof Enemy ? HOSTILE : NORMAL);
    }

    public static Icon getIcon(EntityType<?> entityType) {
        Entity entity = entityType.create((Level)Minecraft.getInstance().level);
        if (entity == null) {
            return NORMAL;
        }
        return EntityIcons.getIcon(entity);
    }

    public record EntityIconSettings(boolean useMobTexture, Optional<ResourceLocation> texture, Optional<EntityImageIcon.Slice> mainSlice, List<EntityImageIcon.ChildIconData> children, WidthHeight widthHeight, double scale, boolean defaultEnabled) {
        public static EntityIconSettings OLD_HIDDEN = new EntityIconSettings(false, Optional.empty(), Optional.empty(), List.of(), WidthHeight.DEFAULT, 1.0, true);
        public static final Codec<EntityIconSettings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.optionalFieldOf("use_mob_texture", (Object)false).forGetter(s -> s.useMobTexture), (App)ResourceLocation.CODEC.optionalFieldOf("texture").forGetter(s -> s.texture), (App)EntityImageIcon.Slice.CODEC.optionalFieldOf("slice").forGetter(entityIconData -> entityIconData.mainSlice), (App)EntityImageIcon.ChildIconData.CODEC.listOf().optionalFieldOf("children", List.of()).forGetter(entityIconData -> entityIconData.children), (App)WidthHeight.CODEC.optionalFieldOf("size", (Object)WidthHeight.DEFAULT).forGetter(s -> s.widthHeight), (App)Codec.DOUBLE.optionalFieldOf("scale", (Object)1.0).forGetter(s -> s.scale), (App)Codec.BOOL.optionalFieldOf("default_enabled", (Object)true).forGetter(s -> s.defaultEnabled)).apply((Applicative)builder, EntityIconSettings::new)).validate(settings -> {
            if (settings.texture().isEmpty() && !settings.useMobTexture) {
                return DataResult.error(() -> "Texture is required if use_mob_texture is false");
            }
            return DataResult.success((Object)settings);
        });
    }

    public record WidthHeight(int width, int height) {
        public static final WidthHeight DEFAULT = new WidthHeight(16, 16);
        public static final Codec<WidthHeight> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("width").forGetter(WidthHeight::width), (App)Codec.INT.fieldOf("height").forGetter(WidthHeight::height)).apply((Applicative)instance, WidthHeight::new));
    }
}

