/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.ftb.mods.ftbchunks.client.ClientTaskQueue;
import dev.ftb.mods.ftbchunks.client.map.RegionSyncKey;
import dev.ftb.mods.ftbchunks.client.map.SyncRXTask;
import dev.ftb.mods.ftbchunks.net.SyncRXPacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PartialPackets<Key, Packet> {
    public static final PartialPackets<RegionSyncKey, SyncRXPacket> REGION = new PartialPackets<RegionSyncKey, SyncRXPacket>(SyncRXPacket::new, (key, data) -> ClientTaskQueue.queue(new SyncRXTask((RegionSyncKey)key, data)));
    private final Map<Key, PartialData> map = new HashMap<Key, PartialData>();
    private final PacketFactory<Key, Packet> packetFactory;
    private final Callback<Key> callback;

    public PartialPackets(PacketFactory<Key, Packet> packetFactory, Callback<Key> callback) {
        this.packetFactory = packetFactory;
        this.callback = callback;
    }

    public List<Packet> write(Key key, byte[] data) {
        byte[] data1;
        if (data.length <= 30000) {
            return Collections.singletonList(this.packetFactory.create(key, 0, data.length, data));
        }
        ArrayList<Packet> list = new ArrayList<Packet>();
        int r = data.length;
        int i = 0;
        while (r >= 30000) {
            data1 = new byte[30000];
            System.arraycopy(data, i, data1, 0, 30000);
            list.add(this.packetFactory.create(key, i, data.length, data1));
            r -= 30000;
            i += 30000;
        }
        if (r > 0) {
            data1 = new byte[r];
            System.arraycopy(data, i, data1, 0, r);
            list.add(this.packetFactory.create(key, i, data.length, data1));
        }
        return list;
    }

    public void read(Key key, int offset, int total, byte[] data) {
        PartialData partialData = this.map.computeIfAbsent(key, s -> new PartialData(total));
        System.arraycopy(data, 0, partialData.data, offset, data.length);
        partialData.remaining -= data.length;
        if (partialData.remaining == 0) {
            this.callback.accept(key, partialData.data);
            this.map.remove(key);
        } else if (partialData.remaining < 0) {
            throw new RuntimeException("Read more data than required");
        }
    }

    @FunctionalInterface
    public static interface PacketFactory<K, P> {
        public P create(K var1, int var2, int var3, byte[] var4);
    }

    @FunctionalInterface
    public static interface Callback<K> {
        public void accept(K var1, byte[] var2);
    }

    public static class PartialData {
        private int remaining;
        private final byte[] data;

        public PartialData(int s) {
            this.remaining = s;
            this.data = new byte[s];
        }
    }
}

