/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map;

import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.client.map.MapChunk;
import dev.ftb.mods.ftbchunks.client.map.MapRegion;
import dev.ftb.mods.ftblibrary.math.XZ;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;

public class MapRegionData {
    public final MapRegion region;
    public final short[] height = new short[262144];
    public final short[] waterLightAndBiome = new short[262144];
    public final int[] foliage = new int[262144];
    public final int[] grass = new int[262144];
    public final int[] water = new int[262144];

    public MapRegionData(MapRegion r) {
        this.region = r;
        Arrays.fill(this.height, (short)-32767);
        FTBChunks.LOGGER.debug("constructing map region data for {} / {}", (Object)this.region, (Object)this.region.pos);
    }

    public int getBlockIndex(int index) {
        int f = this.foliage[index] >> 24 & 0xFF;
        int g = this.grass[index] >> 24 & 0xFF;
        int w = this.water[index] >> 24 & 0xFF;
        return f << 16 | g << 8 | w;
    }

    public void setBlockIndex(int index, int block) {
        this.foliage[index] = this.foliage[index] & 0xFFFFFF | (block >> 16 & 0xFF) << 24;
        this.grass[index] = this.grass[index] & 0xFFFFFF | (block >> 8 & 0xFF) << 24;
        this.water[index] = this.water[index] & 0xFFFFFF | (block & 0xFF) << 24;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() throws IOException {
        Path file;
        if (Files.notExists(this.region.dimension.directory, new LinkOption[0])) {
            Files.createDirectories(this.region.dimension.directory, new FileAttribute[0]);
        }
        if (Files.exists(file = this.region.dimension.directory.resolve(this.region.pos.toRegionString() + ".zip"), new LinkOption[0]) && Files.isReadable(file)) {
            FTBChunks.LOGGER.debug("reading data from {} for {} / {}", (Object)file.getFileName(), (Object)this.region, (Object)this.region.pos);
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]));
                 ZipInputStream zis = new ZipInputStream(bufferedInputStream);){
                ZipEntry ze;
                BufferedImage dataImage = null;
                BufferedImage foliageImage = null;
                BufferedImage grassImage = null;
                BufferedImage waterImage = null;
                BufferedImage blocksImage = null;
                byte version = 0;
                block29: while ((ze = zis.getNextEntry()) != null) {
                    switch (ze.getName()) {
                        case "chunks.dat": {
                            DataInputStream stream = new DataInputStream(zis);
                            stream.readByte();
                            version = stream.readByte();
                            int nMapChunks = stream.readShort();
                            for (int i = 0; i < nMapChunks; ++i) {
                                byte chunkVersion = version >= 2 ? stream.readByte() : (byte)0;
                                byte x = stream.readByte();
                                byte z = stream.readByte();
                                long lastModified = stream.readLong();
                                MapChunk mapChunk = Objects.requireNonNullElse(this.region.getMapChunk(XZ.of((int)x, (int)z)), new MapChunk(this.region, XZ.of((int)x, (int)z)));
                                mapChunk.setVersion(chunkVersion);
                                mapChunk.setModified(lastModified);
                                Object object = this.region.dimension.getManager().lock;
                                synchronized (object) {
                                    this.region.addMapChunk(mapChunk);
                                    continue;
                                }
                            }
                            continue block29;
                        }
                        case "data.png": {
                            dataImage = ImageIO.read(zis);
                            break;
                        }
                        case "foliage.png": {
                            foliageImage = ImageIO.read(zis);
                            break;
                        }
                        case "grass.png": {
                            grassImage = ImageIO.read(zis);
                            break;
                        }
                        case "water.png": {
                            waterImage = ImageIO.read(zis);
                            break;
                        }
                        case "blocks.png": {
                            blocksImage = ImageIO.read(zis);
                            break;
                        }
                        default: {
                            FTBChunks.LOGGER.warn("Unknown file " + ze.getName() + " in " + String.valueOf(file.toAbsolutePath()));
                        }
                    }
                }
                for (int y = 0; y < 512; ++y) {
                    for (int x = 0; x < 512; ++x) {
                        int index = x + y * 512;
                        this.height[index] = (short)(dataImage.getRGB(x, y) >> 16 & 0xFFFF);
                        if (version < 3 && this.height[index] == 0) {
                            this.height[index] = -32767;
                            this.region.markDirty();
                        }
                        this.waterLightAndBiome[index] = (short)(dataImage.getRGB(x, y) & 0xFFFF);
                        this.foliage[index] = foliageImage.getRGB(x, y);
                        this.grass[index] = grassImage.getRGB(x, y);
                        this.water[index] = waterImage.getRGB(x, y);
                        this.setBlockIndex(index, blocksImage.getRGB(x, y));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        Collection<MapChunk> chunkList;
        Object object = this.region.dimension.getManager().lock;
        synchronized (object) {
            chunkList = this.region.getModifiedChunks();
        }
        if (chunkList.isEmpty()) {
            return;
        }
        BufferedImage dataImage = new BufferedImage(512, 512, 2);
        BufferedImage foliageImage = new BufferedImage(512, 512, 1);
        BufferedImage grassImage = new BufferedImage(512, 512, 1);
        BufferedImage waterImage = new BufferedImage(512, 512, 1);
        BufferedImage blocksImage = new BufferedImage(512, 512, 1);
        for (int y = 0; y < 512; ++y) {
            for (int x = 0; x < 512; ++x) {
                int index = x + y * 512;
                dataImage.setRGB(x, y, (this.height[index] & 0xFFFF) << 16 | this.waterLightAndBiome[index] & 0xFFFF);
                foliageImage.setRGB(x, y, 0xFF000000 | this.foliage[index] & 0xFFFFFF);
                grassImage.setRGB(x, y, 0xFF000000 | this.grass[index] & 0xFFFFFF);
                waterImage.setRGB(x, y, 0xFF000000 | this.water[index] & 0xFFFFFF);
                blocksImage.setRGB(x, y, 0xFF000000 | this.getBlockIndex(index));
            }
        }
        FTBChunksClient.MAP_EXECUTOR.execute(() -> {
            try {
                this.writeData(chunkList, dataImage, foliageImage, grassImage, waterImage, blocksImage);
            }
            catch (Exception ex) {
                FTBChunks.LOGGER.error("Failed to write map region " + String.valueOf(this.region.dimension) + ":" + String.valueOf(this.region) + ":");
                ex.printStackTrace();
            }
        });
    }

    private void writeData(Collection<MapChunk> chunkList, BufferedImage dataImage, BufferedImage foliageImage, BufferedImage grassImage, BufferedImage waterImage, BufferedImage blocksImage) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(baos);
             ZipOutputStream out = new ZipOutputStream(bufferedOutputStream);){
            DataOutputStream stream = new DataOutputStream(out);
            out.putNextEntry(new ZipEntry("chunks.dat"));
            stream.writeByte(0);
            stream.writeByte(3);
            stream.writeShort(chunkList.size());
            for (MapChunk chunk : chunkList) {
                chunk.writeData(stream);
            }
            out.closeEntry();
            out.putNextEntry(new ZipEntry("data.png"));
            ImageIO.write((RenderedImage)dataImage, "PNG", out);
            out.closeEntry();
            out.putNextEntry(new ZipEntry("foliage.png"));
            ImageIO.write((RenderedImage)foliageImage, "PNG", out);
            out.closeEntry();
            out.putNextEntry(new ZipEntry("grass.png"));
            ImageIO.write((RenderedImage)grassImage, "PNG", out);
            out.closeEntry();
            out.putNextEntry(new ZipEntry("water.png"));
            ImageIO.write((RenderedImage)waterImage, "PNG", out);
            out.closeEntry();
            out.putNextEntry(new ZipEntry("blocks.png"));
            ImageIO.write((RenderedImage)blocksImage, "PNG", out);
            out.closeEntry();
        }
        if (Files.notExists(this.region.dimension.directory, new LinkOption[0])) {
            Files.createDirectories(this.region.dimension.directory, new FileAttribute[0]);
        }
        FTBChunks.LOGGER.debug("writing data to {} for {} / {}", (Object)(this.region.pos.toRegionString() + ".zip"), (Object)this.region, (Object)this.region.pos);
        Files.write(this.region.dimension.directory.resolve(this.region.pos.toRegionString() + ".zip"), baos.toByteArray(), new OpenOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapChunk getChunk(XZ pos) {
        XZ effectivePos = pos.x() != (pos.x() & 0x1F) || pos.z() != (pos.z() & 0x1F) ? XZ.of((int)(pos.x() & 0x1F), (int)(pos.z() & 0x1F)) : pos;
        Object object = this.region.dimension.getManager().lock;
        synchronized (object) {
            return this.region.getOrCreateMapChunk(effectivePos);
        }
    }
}

