/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mrcrayfish.framework.Constants;
import com.mrcrayfish.framework.api.serialize.DataObject;
import com.mrcrayfish.framework.client.resources.IDataLoader;
import com.mrcrayfish.framework.client.resources.IResourceSupplier;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.commons.lang3.tuple.Pair;

public final class JsonDataManager
extends SimplePreparableReloadListener<List<Pair<IDataLoader<IResourceSupplier>, List<Pair<IResourceSupplier, DataObject>>>>> {
    private static final Gson GSON = new GsonBuilder().create();
    private static JsonDataManager instance;
    private final List<IDataLoader<IResourceSupplier>> loaders = new ArrayList<IDataLoader<IResourceSupplier>>();

    public static JsonDataManager getInstance() {
        if (instance == null) {
            instance = new JsonDataManager();
        }
        return instance;
    }

    private JsonDataManager() {
    }

    public void addLoader(IDataLoader<?> loader) {
        this.loaders.add(loader);
    }

    protected List<Pair<IDataLoader<IResourceSupplier>, List<Pair<IResourceSupplier, DataObject>>>> prepare(ResourceManager manager, ProfilerFiller filler) {
        ArrayList<Pair<IDataLoader<IResourceSupplier>, List<Pair<IResourceSupplier, DataObject>>>> list = new ArrayList<Pair<IDataLoader<IResourceSupplier>, List<Pair<IResourceSupplier, DataObject>>>>();
        this.loaders.forEach(loader -> {
            ArrayList pairs = new ArrayList();
            loader.getResourceSuppliers().forEach(supplier -> {
                ResourceLocation location = supplier.getLocation();
                Optional optional = manager.getResource(location);
                if (optional.isPresent()) {
                    try (BufferedReader reader = ((Resource)optional.get()).openAsReader();){
                        JsonElement element = (JsonElement)GsonHelper.fromJson((Gson)GSON, (Reader)reader, JsonElement.class);
                        if (element == null) {
                            return;
                        }
                        DataObject dataObject = DataObject.convert(element);
                        if (dataObject == null) {
                            return;
                        }
                        pairs.add(Pair.of((Object)supplier, (Object)dataObject));
                    }
                    catch (IOException e) {
                        Constants.LOG.error("Failed to json data", (Throwable)e);
                        pairs.add(Pair.of((Object)supplier, (Object)DataObject.EMPTY));
                    }
                } else {
                    pairs.add(Pair.of((Object)supplier, (Object)DataObject.EMPTY));
                }
            });
            list.add(Pair.of((Object)loader, pairs));
        });
        return list;
    }

    protected void apply(List<Pair<IDataLoader<IResourceSupplier>, List<Pair<IResourceSupplier, DataObject>>>> list, ResourceManager p_10794_, ProfilerFiller p_10795_) {
        list.forEach(pair -> ((IDataLoader)pair.getLeft()).process((List)pair.getRight()));
    }
}

