/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visualization.VisualizationHelper;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import rbasamoyai.escalated.index.EscalatedBlockPartials;
import rbasamoyai.escalated.index.EscalatedBlocks;
import rbasamoyai.escalated.walkways.WalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayBlockEntity;
import rbasamoyai.escalated.walkways.WalkwaySlope;
import rbasamoyai.escalated.walkways.WideEscalatorSideBlock;
import rbasamoyai.escalated.walkways.WideWalkwaySideBlock;

public class WalkwayRenderer
extends KineticBlockEntityRenderer<WalkwayBlockEntity> {
    public WalkwayRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(WalkwayBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.getLevel())) {
            return;
        }
        BlockState state = this.getRenderedBlockState(be);
        KineticBlock kinetic = (KineticBlock)state.getBlock();
        WalkwayBlock walkway = (WalkwayBlock)state.getBlock();
        Direction facing = walkway.getFacing(state);
        Level level = be.getLevel();
        BlockPos pos = be.getBlockPos();
        RenderType type = this.getRenderType(be, state);
        if (type != null) {
            VertexConsumer cons = buffer.getBuffer(type);
            if (kinetic.hasShaftTowards((LevelReader)level, pos, state, Direction.DOWN)) {
                WalkwayRenderer.kineticRotationTransform((SuperByteBuffer)this.getHalfShaftRotatedModel(be, state, Direction.DOWN), (KineticBlockEntity)be, (Direction.Axis)Direction.Axis.Y, (float)WalkwayRenderer.getAngleForBe((KineticBlockEntity)be, (BlockPos)be.getBlockPos(), (Direction.Axis)Direction.Axis.Y), (int)light).renderInto(ms, cons);
            }
            Direction left = Direction.fromAxisAndDirection((Direction.Axis)kinetic.getRotationAxis(state), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
            Direction right = left.getOpposite();
            if (kinetic.hasShaftTowards((LevelReader)level, pos, state, left)) {
                WalkwayRenderer.renderRotatingBuffer((KineticBlockEntity)be, (SuperByteBuffer)this.getHalfShaftRotatedModel(be, state, left), (PoseStack)ms, (VertexConsumer)cons, (int)light);
            }
            if (kinetic.hasShaftTowards((LevelReader)level, pos, state, right)) {
                WalkwayRenderer.renderRotatingBuffer((KineticBlockEntity)be, (SuperByteBuffer)this.getHalfShaftRotatedModel(be, state, right), (PoseStack)ms, (VertexConsumer)cons, (int)light);
            }
            boolean isTerminal = walkway.getWalkwaySlope(state) == WalkwaySlope.TERMINAL;
            boolean flag = facing == Direction.NORTH || facing == Direction.EAST;
            boolean isController = be.isController();
            Direction stepFacing = isTerminal && isController ? facing.getOpposite() : facing;
            PartialModel stepModel = this.getStepModel(be);
            SuperByteBuffer buf = CachedBuffers.partialFacing((PartialModel)stepModel, (BlockState)state, (Direction)stepFacing);
            if (!isTerminal || flag) {
                ((SuperByteBuffer)buf.light(light).translate((Vector3fc)WalkwayRenderer.getStepOffset(be, stepFacing, BlockPos.ZERO, false))).renderInto(ms, cons);
            }
            if (!isTerminal || !flag) {
                ((SuperByteBuffer)buf.light(light).translate((Vector3fc)WalkwayRenderer.getStepOffset(be, stepFacing, BlockPos.ZERO, true))).renderInto(ms, cons);
            }
        }
    }

    protected SuperByteBuffer getHalfShaftRotatedModel(KineticBlockEntity be, BlockState state, Direction dir) {
        return CachedBuffers.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (BlockState)state, (Direction)dir);
    }

    protected PartialModel getStepModel(WalkwayBlockEntity be) {
        return WalkwayRenderer.baseGetStepModel(be);
    }

    public static Vector3f getStepOffset(WalkwayBlockEntity be, Direction facing, BlockPos pos, boolean frontStep) {
        Direction originalFacing = facing;
        Direction.AxisDirection axisDir = facing.getAxis() == Direction.Axis.X ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE;
        facing = Direction.fromAxisAndDirection((Direction.Axis)facing.getAxis(), (Direction.AxisDirection)axisDir);
        BlockState state = be.getBlockState();
        WalkwayBlock walkway = (WalkwayBlock)state.getBlock();
        WalkwaySlope slope = walkway.getWalkwaySlope(state);
        Vector3f offset = new Vector3f((float)pos.getX(), (float)pos.getY() + 0.96875f, (float)pos.getZ());
        float partialTick = be.getSpeed() == 0.0f ? 0.0f : AnimationTickHolder.getPartialTicks((LevelAccessor)be.getLevel());
        float stepOffset = be.getVisualProgress() + (partialTick - 1.0f) * be.getWalkwayMovementSpeed();
        if (Math.abs(stepOffset) > 0.5f) {
            stepOffset = Math.signum(stepOffset) * (Math.abs(stepOffset) - 0.5f);
        }
        if (frontStep) {
            stepOffset += 0.5f;
        }
        offset.add((Vector3fc)facing.step().mul(stepOffset -= 0.25f));
        if (slope == WalkwaySlope.TOP || slope == WalkwaySlope.MIDDLE || slope == WalkwaySlope.BOTTOM) {
            float f = stepOffset - 0.25f;
            if (originalFacing == Direction.NORTH || originalFacing == Direction.EAST) {
                f *= -1.0f;
                f -= 0.5f;
            }
            if (slope == WalkwaySlope.TOP) {
                f = Math.min(f, 0.0f);
            }
            if (slope == WalkwaySlope.BOTTOM) {
                f = Math.max(f, 0.0f);
            }
            offset.add(0.0f, f, 0.0f);
        }
        return offset;
    }

    public static PartialModel baseGetStepModel(WalkwayBlockEntity be) {
        Direction facing;
        DyeColor color = be.getColor();
        BlockState state = be.getBlockState();
        Level level = be.getLevel();
        BlockPos pos = be.getBlockPos();
        boolean terminal = false;
        if (EscalatedBlocks.METAL_WALKWAY_TERMINAL.has(state)) {
            facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            state = level.getBlockState(pos.relative(facing));
            terminal = true;
        }
        if (EscalatedBlocks.METAL_NARROW_WALKWAY.has(state)) {
            return EscalatedBlockPartials.DYED_METAL_WALKWAY_STEPS.getOrDefault(color, EscalatedBlockPartials.METAL_WALKWAY_STEP);
        }
        if (EscalatedBlocks.METAL_WIDE_WALKWAY_SIDE.has(state)) {
            boolean left = (Boolean)state.getValue((Property)WideWalkwaySideBlock.LEFT);
            return left ? EscalatedBlockPartials.DYED_METAL_WALKWAY_STEPS_RIGHT.getOrDefault(color, EscalatedBlockPartials.METAL_WALKWAY_STEP_RIGHT) : EscalatedBlockPartials.DYED_METAL_WALKWAY_STEPS_LEFT.getOrDefault(color, EscalatedBlockPartials.METAL_WALKWAY_STEP_LEFT);
        }
        if (EscalatedBlocks.METAL_WIDE_WALKWAY_CENTER.has(state)) {
            return EscalatedBlockPartials.DYED_METAL_WALKWAY_STEPS_CENTER.getOrDefault(color, EscalatedBlockPartials.METAL_WALKWAY_STEP_CENTER);
        }
        if (EscalatedBlocks.METAL_NARROW_ESCALATOR.has(state)) {
            return EscalatedBlockPartials.DYED_METAL_ESCALATOR_STEPS.getOrDefault(color, EscalatedBlockPartials.METAL_ESCALATOR_STEP);
        }
        if (EscalatedBlocks.METAL_WIDE_ESCALATOR_SIDE.has(state)) {
            boolean left = (Boolean)state.getValue((Property)WideEscalatorSideBlock.LEFT);
            return left ? EscalatedBlockPartials.DYED_METAL_ESCALATOR_STEPS_RIGHT.getOrDefault(color, EscalatedBlockPartials.METAL_ESCALATOR_STEP_RIGHT) : EscalatedBlockPartials.DYED_METAL_ESCALATOR_STEPS_LEFT.getOrDefault(color, EscalatedBlockPartials.METAL_ESCALATOR_STEP_LEFT);
        }
        if (EscalatedBlocks.METAL_WIDE_ESCALATOR_CENTER.has(state)) {
            return EscalatedBlockPartials.DYED_METAL_ESCALATOR_STEPS_CENTER.getOrDefault(color, EscalatedBlockPartials.METAL_ESCALATOR_STEP_CENTER);
        }
        if (EscalatedBlocks.WOODEN_WALKWAY_TERMINAL.has(state)) {
            facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            state = level.getBlockState(pos.relative(facing));
            terminal = true;
        }
        if (EscalatedBlocks.WOODEN_NARROW_WALKWAY.has(state)) {
            return EscalatedBlockPartials.DYED_WOODEN_WALKWAY_STEPS.getOrDefault(color, EscalatedBlockPartials.WOODEN_WALKWAY_STEP);
        }
        if (EscalatedBlocks.WOODEN_WIDE_WALKWAY_SIDE.has(state)) {
            boolean left = (Boolean)state.getValue((Property)WideWalkwaySideBlock.LEFT);
            return left ? EscalatedBlockPartials.DYED_WOODEN_WALKWAY_STEPS_RIGHT.getOrDefault(color, EscalatedBlockPartials.WOODEN_WALKWAY_STEP_RIGHT) : EscalatedBlockPartials.DYED_WOODEN_WALKWAY_STEPS_LEFT.getOrDefault(color, EscalatedBlockPartials.WOODEN_WALKWAY_STEP_LEFT);
        }
        if (EscalatedBlocks.WOODEN_WIDE_WALKWAY_CENTER.has(state)) {
            return EscalatedBlockPartials.DYED_WOODEN_WALKWAY_STEPS_CENTER.getOrDefault(color, EscalatedBlockPartials.WOODEN_WALKWAY_STEP_CENTER);
        }
        if (EscalatedBlocks.WOODEN_NARROW_ESCALATOR.has(state)) {
            return EscalatedBlockPartials.DYED_WOODEN_ESCALATOR_STEPS.getOrDefault(color, EscalatedBlockPartials.WOODEN_ESCALATOR_STEP);
        }
        if (EscalatedBlocks.WOODEN_WIDE_ESCALATOR_SIDE.has(state)) {
            boolean left = (Boolean)state.getValue((Property)WideEscalatorSideBlock.LEFT);
            return left ? EscalatedBlockPartials.DYED_WOODEN_ESCALATOR_STEPS_RIGHT.getOrDefault(color, EscalatedBlockPartials.WOODEN_ESCALATOR_STEP_RIGHT) : EscalatedBlockPartials.DYED_WOODEN_ESCALATOR_STEPS_LEFT.getOrDefault(color, EscalatedBlockPartials.WOODEN_ESCALATOR_STEP_LEFT);
        }
        if (EscalatedBlocks.WOODEN_WIDE_ESCALATOR_CENTER.has(state)) {
            return EscalatedBlockPartials.DYED_WOODEN_ESCALATOR_STEPS_CENTER.getOrDefault(color, EscalatedBlockPartials.WOODEN_ESCALATOR_STEP_CENTER);
        }
        if (terminal && VisualizationHelper.canVisualize((BlockEntity)be)) {
            be.lazyResetClientRender = true;
        }
        return EscalatedBlockPartials.DYED_METAL_WALKWAY_STEPS.get(DyeColor.RED);
    }
}

