/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.handrails;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.foundation.utility.BlockHelper;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import rbasamoyai.escalated.handrails.AbstractHandrailBlock;
import rbasamoyai.escalated.index.EscalatedBlocks;
import rbasamoyai.escalated.index.EscalatedShapes;
import rbasamoyai.escalated.walkways.WalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwaySlope;

public class EscalatorHandrailBlock
extends AbstractHandrailBlock {
    public static final MapCodec<EscalatorHandrailBlock> CODEC = EscalatorHandrailBlock.simpleCodec(EscalatorHandrailBlock::new);
    public static final EnumProperty<Part> PART = EnumProperty.create((String)"part", Part.class);

    public EscalatorHandrailBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nonnull
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PART});
    }

    @Override
    public BlockState getStateForSlope(Level level, BlockPos basePos, BlockState base, BlockPos placePos, Direction facing, WalkwaySlope slope, AbstractHandrailBlock.Side side) {
        BlockState returnState = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)SIDE, (Comparable)((Object)side));
        boolean isStart = ((WalkwayBlock)base.getBlock()).getFacing(base) == facing;
        Part part = switch (slope) {
            default -> throw new MatchException(null, null);
            case WalkwaySlope.HORIZONTAL -> Part.HORIZONTAL;
            case WalkwaySlope.BOTTOM -> Part.BOTTOM;
            case WalkwaySlope.MIDDLE -> Part.MIDDLE;
            case WalkwaySlope.TOP -> Part.TOP;
            case WalkwaySlope.TERMINAL -> isStart ? Part.START : Part.END;
        };
        return (BlockState)returnState.setValue(PART, (Comparable)((Object)part));
    }

    @Override
    public WalkwaySlope getHandrailSlope(BlockState state) {
        return switch (((Part)((Object)state.getValue(PART))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 5 -> WalkwaySlope.TERMINAL;
            case 1 -> WalkwaySlope.BOTTOM;
            case 2 -> WalkwaySlope.MIDDLE;
            case 3 -> WalkwaySlope.TOP;
            case 4 -> WalkwaySlope.HORIZONTAL;
        };
    }

    @Override
    public boolean isEndHandrail(BlockState state) {
        return state.getValue(PART) == Part.END;
    }

    @Override
    protected boolean canConvertToGlassHandrail() {
        return this != EscalatedBlocks.GLASS_ESCALATOR_HANDRAIL.get();
    }

    @Override
    protected BlockState getGlassHandrail(BlockState state) {
        return BlockHelper.copyProperties((BlockState)state, (BlockState)EscalatedBlocks.GLASS_ESCALATOR_HANDRAIL.getDefaultState());
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        AbstractHandrailBlock.Side side = (AbstractHandrailBlock.Side)((Object)state.getValue((Property)SIDE));
        Part part = (Part)((Object)state.getValue(PART));
        Direction facing = (Direction)state.getValue((Property)FACING);
        return switch (side) {
            default -> throw new MatchException(null, null);
            case AbstractHandrailBlock.Side.LEFT -> {
                switch (part.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield EscalatedShapes.WALKWAY_HANDRAIL_LEFT_START.get(facing);
                    }
                    case 1: {
                        yield EscalatedShapes.ESCALATOR_HANDRAIL_LEFT_BOTTOM.get(facing);
                    }
                    case 2: {
                        yield EscalatedShapes.ESCALATOR_HANDRAIL_LEFT_MIDDLE.get(facing);
                    }
                    case 3: {
                        yield EscalatedShapes.ESCALATOR_HANDRAIL_LEFT_TOP.get(facing);
                    }
                    case 4: {
                        yield EscalatedShapes.WALKWAY_HANDRAIL_LEFT_HORIZONTAL.get(facing);
                    }
                    case 5: 
                }
                yield EscalatedShapes.WALKWAY_HANDRAIL_LEFT_END.get(facing);
            }
            case AbstractHandrailBlock.Side.RIGHT -> {
                switch (part.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield EscalatedShapes.WALKWAY_HANDRAIL_RIGHT_START.get(facing);
                    }
                    case 1: {
                        yield EscalatedShapes.ESCALATOR_HANDRAIL_RIGHT_BOTTOM.get(facing);
                    }
                    case 2: {
                        yield EscalatedShapes.ESCALATOR_HANDRAIL_RIGHT_MIDDLE.get(facing);
                    }
                    case 3: {
                        yield EscalatedShapes.ESCALATOR_HANDRAIL_RIGHT_TOP.get(facing);
                    }
                    case 4: {
                        yield EscalatedShapes.WALKWAY_HANDRAIL_RIGHT_HORIZONTAL.get(facing);
                    }
                    case 5: 
                }
                yield EscalatedShapes.WALKWAY_HANDRAIL_RIGHT_END.get(facing);
            }
            case AbstractHandrailBlock.Side.BOTH -> {
                switch (part.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield EscalatedShapes.WALKWAY_HANDRAIL_BOTH_START.get(facing);
                    }
                    case 1: {
                        yield EscalatedShapes.ESCALATOR_HANDRAIL_BOTH_BOTTOM.get(facing);
                    }
                    case 2: {
                        yield EscalatedShapes.ESCALATOR_HANDRAIL_BOTH_MIDDLE.get(facing);
                    }
                    case 3: {
                        yield EscalatedShapes.ESCALATOR_HANDRAIL_BOTH_TOP.get(facing);
                    }
                    case 4: {
                        yield EscalatedShapes.WALKWAY_HANDRAIL_BOTH_HORIZONTAL.get(facing);
                    }
                    case 5: 
                }
                yield EscalatedShapes.WALKWAY_HANDRAIL_BOTH_END.get(facing);
            }
        };
    }

    public static enum Part implements StringRepresentable
    {
        START,
        BOTTOM,
        MIDDLE,
        TOP,
        HORIZONTAL,
        END;

        private final String id = this.name().toLowerCase(Locale.ROOT);

        public String getSerializedName() {
            return this.id;
        }
    }
}

