/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.corpsecurioscompat;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class Config {
    public static final ModConfigSpec COMMON;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> BLACKLISTED_ITEMS;
    public static final ModConfigSpec.BooleanValue TRANSFER_CURSED_ITEMS;

    public static void register(ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON);
    }

    public static boolean isItemBlacklisted(Item item) {
        return ((List)BLACKLISTED_ITEMS.get()).contains(BuiltInRegistries.ITEM.getKey((Object)item));
    }

    public static boolean shouldTransferCursedItems() {
        return (Boolean)TRANSFER_CURSED_ITEMS.get();
    }

    public static boolean isItemCursed(ItemStack stack) {
        ItemEnchantments enchantments = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        for (Object2IntMap.Entry entry : enchantments.entrySet()) {
            Holder enchantment = (Holder)entry.getKey();
            System.out.println("Checking enchantment: " + String.valueOf(enchantment));
            if (!enchantment.is(Enchantments.BINDING_CURSE) || entry.getIntValue() <= 0) continue;
            return true;
        }
        return false;
    }

    static {
        ModConfigSpec.Builder COMMON_BUILDER = new ModConfigSpec.Builder();
        COMMON_BUILDER.comment("General settings").push("general");
        BLACKLISTED_ITEMS = COMMON_BUILDER.comment("Items that should not be transferred to curios slots (format: 'modid:item')").defineList("blacklisted_items", List.of(), entry -> entry instanceof String);
        TRANSFER_CURSED_ITEMS = COMMON_BUILDER.comment("Whether cursed items should be transferred back to curios slots (true = transfer cursed items, false = don't transfer)").define("transfer_cursed_items", false);
        COMMON_BUILDER.pop();
        COMMON = COMMON_BUILDER.build();
    }
}

