/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.registry;

import com.kipti.bnb.foundation.config.conditions.BnbFeatureEnabledCondition;
import com.kipti.bnb.registry.BnbBlocks;
import com.kipti.bnb.registry.BnbConfigs;
import com.kipti.bnb.registry.BnbPaletteStoneTypes;
import com.simibubi.create.foundation.block.DyedBlockList;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.util.Lazy;

public final class BnbFeatureFlag
extends Enum<BnbFeatureFlag> {
    public static final /* enum */ BnbFeatureFlag COGWHEEL_CHAIN_DRIVES = new BnbFeatureFlag("Ability for the player to create chain drives using create's cogwheels.", new Supplier[0]);
    public static final /* enum */ BnbFeatureFlag FLANGED_CHAIN_DRIVES;
    public static final /* enum */ BnbFeatureFlag CHAIN_PULLEY;
    public static final /* enum */ BnbFeatureFlag EXPERIMENTAL_FLYWHEEL_BEARING;
    public static final /* enum */ BnbFeatureFlag WEATHERED_GIRDER;
    public static final /* enum */ BnbFeatureFlag GIRDER_STRUT;
    public static final /* enum */ BnbFeatureFlag NIXIE_BOARD;
    public static final /* enum */ BnbFeatureFlag LARGE_NIXIE_TUBE;
    public static final /* enum */ BnbFeatureFlag LIGHTBULB;
    public static final /* enum */ BnbFeatureFlag BRASS_LAMP;
    public static final /* enum */ BnbFeatureFlag HEADLAMP;
    public static final /* enum */ BnbFeatureFlag CHAIRS;
    public static final /* enum */ BnbFeatureFlag TILES;
    private final String description;
    private final Lazy<Supplier<Block>[]> associatedBlocks;
    private final boolean defaultState;
    private static final /* synthetic */ BnbFeatureFlag[] $VALUES;

    public static BnbFeatureFlag[] values() {
        return (BnbFeatureFlag[])$VALUES.clone();
    }

    public static BnbFeatureFlag valueOf(String name) {
        return Enum.valueOf(BnbFeatureFlag.class, name);
    }

    private static Lazy<Supplier<Block>[]> createDecoBlockSupplierSet(BnbPaletteStoneTypes[] values) {
        return Lazy.of(() -> {
            ArrayList<Supplier> blocks = new ArrayList<Supplier>();
            for (BnbPaletteStoneTypes type : values) {
                blocks.addAll(type.getVariants().registeredBlocks.stream().map(e -> () -> ((BlockEntry)e).get()).toList());
                blocks.addAll(type.getVariants().registeredPartials.stream().map(e -> () -> ((BlockEntry)e).get()).toList());
            }
            return (Supplier[])blocks.toArray(Supplier[]::new);
        });
    }

    private static Supplier<Block>[] createSupplierSet(DyedBlockList<? extends Block> dyedBlockList) {
        return (Supplier[])Arrays.stream(dyedBlockList.toArray()).map(chairEntry -> () -> ((BlockEntry)chairEntry).get()).toArray(Supplier[]::new);
    }

    @SafeVarargs
    private BnbFeatureFlag(String description, Supplier<Block> ... associatedBlocks) {
        this.description = description;
        this.associatedBlocks = Lazy.of(() -> associatedBlocks);
        this.defaultState = true;
    }

    @SafeVarargs
    private BnbFeatureFlag(String description, boolean defaultState, Supplier<Block> ... associatedBlocks) {
        this.description = description;
        this.associatedBlocks = Lazy.of(() -> associatedBlocks);
        this.defaultState = defaultState;
    }

    private BnbFeatureFlag(String description, Lazy<Supplier<Block>[]> associatedBlocks) {
        this.description = description;
        this.associatedBlocks = associatedBlocks;
        this.defaultState = true;
    }

    public static boolean isEnabled(Item item) {
        if (!(item instanceof BlockItem)) {
            return true;
        }
        BlockItem blockItem = (BlockItem)item;
        return BnbFeatureFlag.isEnabled(blockItem);
    }

    public static boolean isEnabled(BlockItem tabItem) {
        if (tabItem == null) {
            return false;
        }
        for (BnbFeatureFlag featureFlag : BnbFeatureFlag.values()) {
            for (Supplier<Block> blockSupplier : featureFlag.getAssociatedBlocks()) {
                if (blockSupplier.get() != tabItem.getBlock() || featureFlag.get()) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isEnabled(String featureFlagKey) {
        BnbFeatureFlag flag;
        if (featureFlagKey == null || featureFlagKey.isEmpty()) {
            return false;
        }
        try {
            flag = BnbFeatureFlag.valueOf(featureFlagKey.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return BnbConfigs.common().getFeatureFlagState(flag);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getDefaultState() {
        return this.defaultState;
    }

    public Supplier<Block>[] getAssociatedBlocks() {
        return (Supplier[])this.associatedBlocks.get();
    }

    public boolean get() {
        return BnbConfigs.common().getFeatureFlagState(this);
    }

    public BnbFeatureEnabledCondition getDataCondition() {
        return new BnbFeatureEnabledCondition(this.name().toLowerCase());
    }

    private static /* synthetic */ BnbFeatureFlag[] $values() {
        return new BnbFeatureFlag[]{COGWHEEL_CHAIN_DRIVES, FLANGED_CHAIN_DRIVES, CHAIN_PULLEY, EXPERIMENTAL_FLYWHEEL_BEARING, WEATHERED_GIRDER, GIRDER_STRUT, NIXIE_BOARD, LARGE_NIXIE_TUBE, LIGHTBULB, BRASS_LAMP, HEADLAMP, CHAIRS, TILES};
    }

    static {
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> BnbBlocks.LARGE_EMPTY_FLANGED_COGWHEEL.get();
        supplierArray[1] = () -> BnbBlocks.SMALL_EMPTY_FLANGED_COGWHEEL.get();
        FLANGED_CHAIN_DRIVES = new BnbFeatureFlag("Ability for the player to create chain drives using the flanged gear cogwheels.", supplierArray);
        Supplier[] supplierArray2 = new Supplier[1];
        supplierArray2[0] = () -> BnbBlocks.CHAIN_PULLEY.get();
        CHAIN_PULLEY = new BnbFeatureFlag("Availability of the Chain Pulley block.", supplierArray2);
        Supplier[] supplierArray3 = new Supplier[1];
        supplierArray3[0] = () -> BnbBlocks.FLYWHEEL_BEARING.get();
        EXPERIMENTAL_FLYWHEEL_BEARING = new BnbFeatureFlag("Availability of the Flywheel Bearing block. (In development)", false, supplierArray3);
        Supplier[] supplierArray4 = new Supplier[2];
        supplierArray4[0] = () -> BnbBlocks.WEATHERED_METAL_GIRDER.get();
        supplierArray4[1] = () -> BnbBlocks.WEATHERED_GIRDER_STRUT.get();
        WEATHERED_GIRDER = new BnbFeatureFlag("Availability of the weathered girder block.", supplierArray4);
        Supplier[] supplierArray5 = new Supplier[2];
        supplierArray5[0] = () -> BnbBlocks.GIRDER_STRUT.get();
        supplierArray5[1] = () -> BnbBlocks.WEATHERED_GIRDER_STRUT.get();
        GIRDER_STRUT = new BnbFeatureFlag("Availability of the girder strut blocks.", supplierArray5);
        Supplier[] supplierArray6 = new Supplier[1];
        supplierArray6[0] = () -> BnbBlocks.NIXIE_BOARD.get();
        NIXIE_BOARD = new BnbFeatureFlag("Availability of Nixie Board block.", supplierArray6);
        Supplier[] supplierArray7 = new Supplier[1];
        supplierArray7[0] = () -> BnbBlocks.LARGE_NIXIE_TUBE.get();
        LARGE_NIXIE_TUBE = new BnbFeatureFlag("Availability of Large Nixie Tube block.", supplierArray7);
        Supplier[] supplierArray8 = new Supplier[1];
        supplierArray8[0] = () -> BnbBlocks.LIGHTBULB.get();
        LIGHTBULB = new BnbFeatureFlag("Availability of the Lightbulb block.", supplierArray8);
        Supplier[] supplierArray9 = new Supplier[1];
        supplierArray9[0] = () -> BnbBlocks.BRASS_LAMP.get();
        BRASS_LAMP = new BnbFeatureFlag("Availability of the Brass Lamp block.", supplierArray9);
        Supplier[] supplierArray10 = new Supplier[1];
        supplierArray10[0] = () -> BnbBlocks.HEADLAMP.get();
        HEADLAMP = new BnbFeatureFlag("Availability of the Headlamp block.", supplierArray10);
        CHAIRS = new BnbFeatureFlag("Availability of the Chair blocks.", BnbFeatureFlag.createSupplierSet(BnbBlocks.CHAIRS));
        TILES = new BnbFeatureFlag("Availability of the tile decoration blocks.", BnbFeatureFlag.createDecoBlockSupplierSet(BnbPaletteStoneTypes.values()));
        $VALUES = BnbFeatureFlag.$values();
    }
}

