/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.network.packets.from_client;

import com.kipti.bnb.content.cogwheel_chain.graph.ChainInteractionFailedException;
import com.kipti.bnb.content.cogwheel_chain.graph.CogwheelChain;
import com.kipti.bnb.content.cogwheel_chain.graph.CogwheelChainPathfinder;
import com.kipti.bnb.content.cogwheel_chain.graph.PathedCogwheelNode;
import com.kipti.bnb.content.cogwheel_chain.graph.PlacingCogwheelChain;
import com.kipti.bnb.network.BnbPackets;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import java.util.List;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.createmod.catnip.net.base.ServerboundPacketPayload;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public record PlaceCogwheelChainPacket(PlacingCogwheelChain worldSpacePartialChain, int priorityChainTakeHand) implements ServerboundPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, PlaceCogwheelChainPacket> STREAM_CODEC = StreamCodec.composite(PlacingCogwheelChain.STREAM_CODEC, PlaceCogwheelChainPacket::worldSpacePartialChain, (StreamCodec)ByteBufCodecs.INT, PlaceCogwheelChainPacket::priorityChainTakeHand, PlaceCogwheelChainPacket::new);

    public void handle(ServerPlayer player) {
        List<PathedCogwheelNode> chainGeometry;
        boolean hasEnough;
        if (this.worldSpacePartialChain.maxBounds() > PlacingCogwheelChain.MAX_CHAIN_BOUNDS) {
            return;
        }
        if (!this.worldSpacePartialChain.checkMatchingNodesInLevel(player.level())) {
            return;
        }
        int chainsRequired = this.worldSpacePartialChain.getChainsRequiredInLoop();
        boolean bl = hasEnough = player.hasInfiniteMaterials() || ChainConveyorBlockEntity.getChainsFromInventory((Player)player, (ItemStack)Items.CHAIN.getDefaultInstance(), (int)chainsRequired, (boolean)true);
        if (!hasEnough) {
            return;
        }
        if (!player.hasInfiniteMaterials()) {
            ChainConveyorBlockEntity.getChainsFromInventory((Player)player, (ItemStack)Items.CHAIN.getDefaultInstance(), (int)chainsRequired, (boolean)false);
        }
        try {
            chainGeometry = CogwheelChainPathfinder.buildChainPath(this.worldSpacePartialChain);
        }
        catch (ChainInteractionFailedException ignored) {
            return;
        }
        if (chainGeometry == null) {
            return;
        }
        CogwheelChain chain = new CogwheelChain(chainGeometry);
        chain.placeInLevel(player.level(), this.worldSpacePartialChain);
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return BnbPackets.PLACE_COGWHEEL_CHAIN;
    }
}

