/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.mixin.flywheel_bearing;

import com.kipti.bnb.content.flywheel_bearing.FlywheelBearingBlockEntity;
import com.kipti.bnb.mixin_accessor.FlywheelAccessibleKineticNetwork;
import com.kipti.bnb.registry.BnbConfigs;
import com.simibubi.create.content.kinetics.KineticNetwork;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import java.util.Iterator;
import java.util.Map;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={KineticNetwork.class})
public abstract class KineticNetworkMixin
implements FlywheelAccessibleKineticNetwork {
    @Shadow
    public Map<KineticBlockEntity, Float> members;
    @Shadow
    private float currentStress;
    @Unique
    private float currentFlywheelStressAbsorptionCapacity = 0.0f;
    @Unique
    private float currentFlywheelStressReleaseCapacity = 0.0f;

    @Shadow
    public abstract void sync();

    @Unique
    private boolean bits_n_bobs$flywheelCapacitiesAllowedInServer() {
        return (Boolean)BnbConfigs.server().FLYWHEEL_STORAGE_CAPACITY.get();
    }

    @Unique
    private float bits_n_bobs$calculateFlywheelStressAbsorptionCapacity() {
        if (!this.bits_n_bobs$flywheelCapacitiesAllowedInServer()) {
            return 0.0f;
        }
        float presentFlywheelStressCapacity = 0.0f;
        Iterator<KineticBlockEntity> iterator = this.members.keySet().iterator();
        while (iterator.hasNext()) {
            KineticBlockEntity be = iterator.next();
            if (be.getLevel().getBlockEntity(be.getBlockPos()) != be) {
                iterator.remove();
                continue;
            }
            if (!(be instanceof FlywheelBearingBlockEntity)) continue;
            FlywheelBearingBlockEntity flywheelBearing = (FlywheelBearingBlockEntity)be;
            presentFlywheelStressCapacity += flywheelBearing.getFlywheelStressAbsorptionCapacity();
        }
        return presentFlywheelStressCapacity;
    }

    @Unique
    private float bits_n_bobs$calculateFlywheelStressReleaseCapacity() {
        if (!this.bits_n_bobs$flywheelCapacitiesAllowedInServer()) {
            return 0.0f;
        }
        float presentFlywheelStressCapacity = 0.0f;
        Iterator<KineticBlockEntity> iterator = this.members.keySet().iterator();
        while (iterator.hasNext()) {
            KineticBlockEntity be = iterator.next();
            if (be.getLevel().getBlockEntity(be.getBlockPos()) != be) {
                iterator.remove();
                continue;
            }
            if (!(be instanceof FlywheelBearingBlockEntity)) continue;
            FlywheelBearingBlockEntity flywheelBearing = (FlywheelBearingBlockEntity)be;
            presentFlywheelStressCapacity += flywheelBearing.getFlywheelStressReleaseCapacity();
        }
        return presentFlywheelStressCapacity;
    }

    @Override
    @Unique
    public void bits_n_bobs$updateFlywheelStresses() {
        float newFlywheelStressAbsorptionCapacity = this.bits_n_bobs$calculateFlywheelStressAbsorptionCapacity();
        float newFlywheelStressReleaseCapacity = this.bits_n_bobs$calculateFlywheelStressReleaseCapacity();
        if (this.currentFlywheelStressAbsorptionCapacity != newFlywheelStressAbsorptionCapacity || this.currentFlywheelStressReleaseCapacity != newFlywheelStressReleaseCapacity) {
            this.currentFlywheelStressAbsorptionCapacity = newFlywheelStressAbsorptionCapacity;
            this.currentFlywheelStressReleaseCapacity = newFlywheelStressReleaseCapacity;
            this.bits_n_bob$syncToFlywheels();
        }
    }

    @Unique
    private void bits_n_bob$syncToFlywheels() {
        if (!this.bits_n_bobs$flywheelCapacitiesAllowedInServer()) {
            return;
        }
        Iterator<KineticBlockEntity> iterator = this.members.keySet().iterator();
        while (iterator.hasNext()) {
            KineticBlockEntity be = iterator.next();
            if (be.getLevel().getBlockEntity(be.getBlockPos()) != be) {
                iterator.remove();
                continue;
            }
            if (!(be instanceof FlywheelBearingBlockEntity)) continue;
            FlywheelBearingBlockEntity flywheelBearing = (FlywheelBearingBlockEntity)be;
            flywheelBearing.updateFlywheelStressesFromNetwork();
        }
    }

    @Inject(method={"updateNetwork"}, at={@At(value="HEAD")})
    public void bits_n_bobs$updateNetworkHead(CallbackInfo ci) {
        if (!this.bits_n_bobs$flywheelCapacitiesAllowedInServer()) {
            return;
        }
        float flywheelCapacity = this.bits_n_bobs$calculateFlywheelStressAbsorptionCapacity();
        if (this.currentFlywheelStressAbsorptionCapacity != flywheelCapacity) {
            this.currentFlywheelStressAbsorptionCapacity = flywheelCapacity;
            this.currentStress = -1.0f;
        }
    }

    @Inject(method={"addSilently"}, at={@At(value="HEAD")})
    public void addSilently(KineticBlockEntity be, float lastCapacity, float lastStress, CallbackInfo ci) {
        if (!this.bits_n_bobs$flywheelCapacitiesAllowedInServer()) {
            return;
        }
        if (this.members.containsKey(be)) {
            return;
        }
        if (be instanceof FlywheelBearingBlockEntity) {
            FlywheelBearingBlockEntity flywheelBearing = (FlywheelBearingBlockEntity)be;
            this.currentFlywheelStressAbsorptionCapacity += flywheelBearing.getFlywheelStressAbsorptionCapacity();
            this.currentFlywheelStressReleaseCapacity += flywheelBearing.getFlywheelStressReleaseCapacity();
        }
    }

    @Inject(method={"add"}, at={@At(value="HEAD")})
    public void add(KineticBlockEntity be, CallbackInfo ci) {
        if (!this.bits_n_bobs$flywheelCapacitiesAllowedInServer()) {
            return;
        }
        if (this.members.containsKey(be)) {
            return;
        }
        if (be instanceof FlywheelBearingBlockEntity) {
            FlywheelBearingBlockEntity flywheelBearing = (FlywheelBearingBlockEntity)be;
            this.currentFlywheelStressAbsorptionCapacity += flywheelBearing.getFlywheelStressAbsorptionCapacity();
            this.currentFlywheelStressReleaseCapacity += flywheelBearing.getFlywheelStressReleaseCapacity();
        }
    }

    @Inject(method={"remove"}, at={@At(value="HEAD")})
    public void remove(KineticBlockEntity be, CallbackInfo ci) {
        if (!this.bits_n_bobs$flywheelCapacitiesAllowedInServer()) {
            return;
        }
        if (!this.members.containsKey(be)) {
            return;
        }
        if (be instanceof FlywheelBearingBlockEntity) {
            FlywheelBearingBlockEntity flywheelBearing = (FlywheelBearingBlockEntity)be;
            this.currentFlywheelStressAbsorptionCapacity -= flywheelBearing.getFlywheelStressAbsorptionCapacity();
            this.currentFlywheelStressReleaseCapacity -= flywheelBearing.getFlywheelStressReleaseCapacity();
        }
    }

    @Override
    public float bits_n_bobs$getFlywheelStressAbsoptionCapacity() {
        return this.currentFlywheelStressAbsorptionCapacity;
    }

    @Override
    public float bits_n_bobs$getFlywheelStressReleaseCapacity() {
        return this.currentFlywheelStressReleaseCapacity;
    }
}

