/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.foundation;

import com.kipti.bnb.content.cogwheel_chain.item.CogwheelChainPlacementEffect;
import com.kipti.bnb.content.girder_strut.GirderStrutPlacementEffects;
import com.kipti.bnb.content.weathered_girder.WeatheredGirderWrenchBehaviour;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.outliner.Outliner;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    static final List<Pair<Vec3, Vec3>> deferredDebugRenderOutlines = Collections.synchronizedList(new ArrayList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onTickPost(ClientTickEvent.Post event) {
        WeatheredGirderWrenchBehaviour.tick();
        List<Pair<Vec3, Vec3>> list = deferredDebugRenderOutlines;
        synchronized (list) {
            for (Pair<Vec3, Vec3> outline : deferredDebugRenderOutlines) {
                Outliner.getInstance().showLine(outline, (Vec3)outline.getFirst(), (Vec3)outline.getSecond());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushNewDeferredDebugRenderOutline(Pair<Vec3, Vec3> outline) {
        List<Pair<Vec3, Vec3>> list = deferredDebugRenderOutlines;
        synchronized (list) {
            deferredDebugRenderOutlines.add(outline);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearDeferredDebugRenderOutlines() {
        List<Pair<Vec3, Vec3>> list = deferredDebugRenderOutlines;
        synchronized (list) {
            deferredDebugRenderOutlines.clear();
        }
    }

    @SubscribeEvent
    public static void onTickPre(ClientTickEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && mc.player != null) {
            GirderStrutPlacementEffects.tick(mc.player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onTickPre(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && mc.player != null) {
            CogwheelChainPlacementEffect.tick(mc.player);
        }
    }

    @SubscribeEvent
    public static void modify(ItemTooltipEvent context) {
    }
}

