/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.light.headlamp;

import com.kipti.bnb.content.light.founation.LightBlock;
import com.kipti.bnb.content.light.headlamp.HeadlampBlockEntity;
import com.kipti.bnb.registry.BnbBlockEntities;
import com.kipti.bnb.registry.BnbBlocks;
import com.kipti.bnb.registry.BnbShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeadlampBlock
extends LightBlock
implements IBE<HeadlampBlockEntity>,
IWrenchable {
    public HeadlampBlock(BlockBehaviour.Properties p_52591_) {
        super(p_52591_, BnbShapes.LIGHTBULB_SHAPE);
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (placer == null) {
            return;
        }
        Vec3 location = HeadlampBlock.getPlayerLocationInBlock(pos, placer);
        this.withBlockEntityDo((BlockGetter)level, pos, headlampBlockEntity -> headlampBlockEntity.placeHeadlampIntoBlock(location.subtract(pos.getCenter()), (Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    private static Vec3 getPlayerLocationInBlock(BlockPos pos, @NotNull LivingEntity placer) {
        double range = placer.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE) + 1.0;
        HitResult hitResult = placer.pick(range, 1.0f, false);
        Vec3 location = hitResult.getLocation();
        Vec3 direction = placer.getLookAngle();
        AABB hitBox = new AABB(pos);
        location = hitBox.clip(location.add(direction.scale(2.0)), location).orElse(location);
        return location;
    }

    private Vec3 getPlayerLocationInBlockExact(BlockPos pos, Level level, @NotNull LivingEntity placer) {
        double range = placer.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE) + 1.0;
        HitResult hitResult = placer.pick(range, 1.0f, false);
        Vec3 location = hitResult.getLocation();
        Vec3 direction = placer.getLookAngle();
        BlockHitResult clip = level.getBlockState(pos).getShape((BlockGetter)level, pos).clip(location, direction.scale(2.0), pos);
        if (clip == null) {
            return location;
        }
        return clip.getLocation();
    }

    public boolean canBeReplaced(@NotNull BlockState state, BlockPlaceContext useContext) {
        BlockItem blockItem;
        if (useContext.isSecondaryUseActive()) {
            return false;
        }
        ItemStack stack = useContext.getItemInHand();
        Item item = stack.getItem();
        if (item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() != this) {
            return super.canBeReplaced(state, useContext);
        }
        Vec3 location = useContext.getClickLocation();
        BlockPos pos = useContext.getClickedPos();
        BlockEntity blockEntity = useContext.getLevel().getBlockEntity(pos);
        if (blockEntity instanceof HeadlampBlockEntity) {
            HeadlampBlockEntity headlampBlockEntity = (HeadlampBlockEntity)blockEntity;
            return headlampBlockEntity.canPlaceHeadlampIntoBlock(location.subtract(pos.getCenter()), (Direction)state.getValue((Property)FACING));
        }
        return super.canBeReplaced(state, useContext);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext pContext) {
        AtomicReference<BlockState> stateForPlacement = new AtomicReference<BlockState>(super.getStateForPlacement(pContext));
        if (stateForPlacement.get() == null) {
            return null;
        }
        Level level = pContext.getLevel();
        BlockPos pos = pContext.getClickedPos();
        BlockState blockState = level.getBlockState(pos);
        HeadlampBlockEntity fpbe = (HeadlampBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        Vec3 location = pContext.getClickLocation().subtract(pos.getCenter());
        Direction facing = (Direction)stateForPlacement.get().getValue((Property)FACING);
        if (blockState.is((Block)this) && fpbe != null) {
            if (!level.isClientSide()) {
                this.withBlockEntityDo((BlockGetter)level, pos, headlampBlockEntity -> {
                    boolean placed = headlampBlockEntity.placeHeadlampIntoBlock(location, facing);
                    if (!placed) {
                        stateForPlacement.set(null);
                    }
                });
                level.playSound(null, pos, this.soundType.getPlaceSound(), SoundSource.BLOCKS);
            }
            stateForPlacement.set(blockState);
        }
        return stateForPlacement.get();
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        Item item = stack.getItem();
        if (item instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof HeadlampBlockEntity) {
                HeadlampBlockEntity headlampBlockEntity = (HeadlampBlockEntity)blockEntity;
                headlampBlockEntity.placeDyeColorIntoBlock(dyeItem.getDyeColor(), hitResult.getLocation().subtract(pos.getCenter()), (Direction)state.getValue((Property)FACING));
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public boolean onDestroyedByPlayer(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, boolean willHarvest, @NotNull FluidState fluid) {
        HeadlampBlockEntity headlampBlockEntity;
        BlockEntity blockEntity;
        Vec3 location = this.getPlayerLocationInBlockExact(pos, level, (LivingEntity)player);
        if (!player.isCrouching() && (blockEntity = level.getBlockEntity(pos)) instanceof HeadlampBlockEntity && (headlampBlockEntity = (HeadlampBlockEntity)blockEntity).removeNearestHeadlamp(location.subtract(pos.getCenter()), (Direction)state.getValue((Property)FACING))) {
            if (!level.isClientSide && !player.isCreative()) {
                HeadlampBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)BnbBlocks.HEADLAMP.asStack());
            }
            return false;
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    protected void onRemove(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (newState.is(state.getBlock())) {
            super.onRemove(state, level, pos, newState, movedByPiston);
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof HeadlampBlockEntity) {
            HeadlampBlockEntity headlampBlockEntity = (HeadlampBlockEntity)blockEntity;
            ItemStack additionalResources = BnbBlocks.HEADLAMP.asStack().copyWithCount(Math.clamp((long)(headlampBlockEntity.getExistingPlacements().size() - 1), 0, 3));
            if (!additionalResources.isEmpty()) {
                HeadlampBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)additionalResources);
            }
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        Vec3 location = this.getPlayerLocationInBlockExact(context.getClickedPos(), context.getLevel(), (LivingEntity)context.getPlayer());
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, world.getBlockState(pos), player);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return InteractionResult.SUCCESS;
        }
        if (!player.isCreative()) {
            Block.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)world.getBlockEntity(pos), (Entity)player, (ItemStack)context.getItemInHand()).forEach(itemStack -> player.getInventory().placeItemBackInInventory(itemStack));
        }
        state.spawnAfterBreak(serverLevel, pos, ItemStack.EMPTY, true);
        this.withBlockEntityDo((BlockGetter)world, pos, headlampBlockEntity -> {
            if (headlampBlockEntity.getExistingPlacements().size() > 1) {
                headlampBlockEntity.removeNearestHeadlamp(location.subtract(context.getClickedPos().getCenter()), (Direction)state.getValue((Property)FACING));
            } else {
                world.destroyBlock(pos, false);
            }
        });
        IWrenchable.playRemoveSound((Level)world, (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }

    @Override
    @NotNull
    protected VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape voxelShape;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof HeadlampBlockEntity) {
            HeadlampBlockEntity headlampBlockEntity = (HeadlampBlockEntity)blockEntity;
            voxelShape = headlampBlockEntity.getShape(state, level, pos, context);
        } else {
            voxelShape = Shapes.block();
        }
        return voxelShape;
    }

    @NotNull
    protected BlockState rotate(@NotNull BlockState state, @NotNull Rotation rotation) {
        return (BlockState)super.rotate(state, rotation).setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public boolean hasDynamicShape() {
        return true;
    }

    public Class<HeadlampBlockEntity> getBlockEntityClass() {
        return HeadlampBlockEntity.class;
    }

    public BlockEntityType<? extends HeadlampBlockEntity> getBlockEntityType() {
        return (BlockEntityType)BnbBlockEntities.HEADLAMP.get();
    }

    @NotNull
    protected VoxelShape getVisualShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return super.getVisualShape(state, level, pos, context);
    }
}

