/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.light.founation;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightBlock
extends DirectionalBlock
implements IWrenchable {
    public final MapCodec<LightBlock> CODEC;
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final BooleanProperty FORCED_ON = BooleanProperty.create((String)"forced_on");
    private final VoxelShaper shaper;
    private final boolean forcePlaceUpwards;

    public LightBlock(BlockBehaviour.Properties p_52591_, VoxelShaper shaper) {
        this(p_52591_, shaper, false);
    }

    public LightBlock(BlockBehaviour.Properties p_52591_, VoxelShaper shaper, boolean forcePlaceUpwards) {
        super(p_52591_);
        this.shaper = shaper;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)POWER, (Comparable)Integer.valueOf(0))).setValue((Property)FORCED_ON, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.UP));
        this.CODEC = LightBlock.simpleCodec(p -> new LightBlock((BlockBehaviour.Properties)p, shaper, forcePlaceUpwards));
        this.forcePlaceUpwards = forcePlaceUpwards;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        ItemStack heldItem = player.getMainHandItem();
        if (!heldItem.isEmpty()) {
            return InteractionResult.PASS;
        }
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        level.setBlock(pos, (BlockState)state.cycle((Property)FORCED_ON), 3);
        level.playSound(null, pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.3f, (Boolean)state.getValue((Property)FORCED_ON) != false ? 0.6f : 0.5f);
        return InteractionResult.SUCCESS;
    }

    public static boolean shouldUseOnLightModel(BlockState state) {
        return (Integer)state.getValue((Property)POWER) > 6 || (Boolean)state.getValue((Property)FORCED_ON) != false;
    }

    public static int getLightLevel(BlockState state) {
        return (Boolean)state.getValue((Property)FORCED_ON) != false ? 15 : (Integer)state.getValue((Property)POWER);
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWER, FACING, FORCED_ON});
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)(this.forcePlaceUpwards ? (context.getPlayer() != null && context.getPlayer().isCrouching() ? context.getClickedFace().getOpposite() : Direction.UP) : context.getClickedFace()))).setValue((Property)POWER, (Comparable)Integer.valueOf(context.getLevel().getBestNeighborSignal(context.getClickedPos())));
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.shaper.get((Direction)state.getValue((Property)FACING));
    }

    public boolean canConnectRedstone(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    protected void neighborChanged(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        int signal;
        int currentPower;
        if (!level.isClientSide && (currentPower = ((Integer)state.getValue((Property)POWER)).intValue()) != (signal = level.getBestNeighborSignal(pos))) {
            if (currentPower > 0) {
                level.scheduleTick(pos, (Block)this, 4);
            } else {
                level.setBlock(pos, (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(signal)), 2);
            }
        }
    }

    protected void tick(BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        int signal = level.getBestNeighborSignal(pos);
        if ((Integer)state.getValue((Property)POWER) != signal) {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(signal)), 2);
        }
    }

    @NotNull
    protected MapCodec<? extends DirectionalBlock> codec() {
        return this.CODEC;
    }
}

