/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.chair;

import com.kipti.bnb.registry.BnbBlocks;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.actors.seat.SeatBlock;
import com.simibubi.create.content.contraptions.actors.seat.SeatEntity;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.utility.BlockHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

public class ChairBlock
extends SeatBlock
implements IWrenchable {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty LEFT_ARM = BooleanProperty.create((String)"left_arm");
    public static final BooleanProperty RIGHT_ARM = BooleanProperty.create((String)"right_arm");
    public static final BooleanProperty BACK_FLAT = BooleanProperty.create((String)"back_flat");
    public static final BooleanProperty FORCED_BACK_FLAT = BooleanProperty.create((String)"forced_back_flat");
    public static final BooleanProperty INVERTED_CORNER = BooleanProperty.create((String)"inverted_corner");
    public static final BooleanProperty CORNER = BooleanProperty.create((String)"corner");

    public ChairBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties, color);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)LEFT_ARM, (Comparable)Boolean.valueOf(true))).setValue((Property)RIGHT_ARM, (Comparable)Boolean.valueOf(true))).setValue((Property)CORNER, (Comparable)Boolean.valueOf(false))).setValue((Property)BACK_FLAT, (Comparable)Boolean.valueOf(false))).setValue((Property)FORCED_BACK_FLAT, (Comparable)Boolean.valueOf(false))).setValue((Property)INVERTED_CORNER, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (context.getLevel().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockState newState = (BlockState)state.cycle((Property)FORCED_BACK_FLAT);
        boolean isForcedFlat = (Boolean)newState.getValue((Property)FORCED_BACK_FLAT);
        context.getLevel().setBlockAndUpdate(context.getClickedPos(), newState);
        context.getLevel().playSound(null, context.getClickedPos(), isForcedFlat ? SoundEvents.WOODEN_TRAPDOOR_CLOSE : SoundEvents.WOODEN_TRAPDOOR_OPEN, SoundSource.BLOCKS, 1.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.isShiftKeyDown() || player instanceof FakePlayer) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (stack.is((Holder)AllItems.WRENCH)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        DyeColor color = DyeColor.getColor((ItemStack)stack);
        if (color != null && color != this.color) {
            if (level.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            BlockState newState = BlockHelper.copyProperties((BlockState)state, (BlockState)BnbBlocks.CHAIRS.get(color).getDefaultState());
            level.setBlockAndUpdate(pos, newState);
            return ItemInteractionResult.SUCCESS;
        }
        List seats = level.getEntitiesOfClass(SeatEntity.class, new AABB(pos));
        if (!seats.isEmpty()) {
            SeatEntity seatEntity = (SeatEntity)seats.get(0);
            List passengers = seatEntity.getPassengers();
            if (!passengers.isEmpty() && passengers.get(0) instanceof Player) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (!level.isClientSide) {
                seatEntity.ejectPassengers();
                player.startRiding((Entity)seatEntity);
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        ChairBlock.sitDown((Level)level, (BlockPos)pos, (Entity)((Entity)ChairBlock.getLeashed((Level)level, (Player)player).or((Object)player)));
        return ItemInteractionResult.SUCCESS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{FACING, LEFT_ARM, RIGHT_ARM, CORNER, BACK_FLAT, FORCED_BACK_FLAT, INVERTED_CORNER});
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return this.calculateShape((BlockState)super.getStateForPlacement(pContext).setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite()), (LevelAccessor)pContext.getLevel(), pContext.getClickedPos());
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        BlockState blockState = super.updateShape(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
        return this.calculateShape(blockState, pLevel, pCurrentPos);
    }

    @NotNull
    private BlockState calculateShape(BlockState blockState, LevelAccessor pLevel, BlockPos pCurrentPos) {
        boolean isCorner;
        Direction facing = (Direction)blockState.getValue((Property)FACING);
        ConnectableSides connectableSides = ChairBlock.getConnectableSides(pLevel, pCurrentPos, facing);
        BlockState stateBack = pLevel.getBlockState(pCurrentPos.relative(facing.getOpposite()));
        boolean isFlatBack = BnbBlocks.CHAIRS.contains(stateBack.getBlock()) || stateBack.isCollisionShapeFullBlock((BlockGetter)pLevel, pCurrentPos.relative(facing.getOpposite()));
        boolean isBackCorner = stateBack.getOptionalValue((Property)CORNER).orElse(false);
        boolean isInvertedCorner = !(!(stateBack.getBlock() instanceof ChairBlock) || ((Direction)stateBack.getValue((Property)FACING)).getAxis() == facing.getAxis() || !connectableSides.hasConnectableRight() && !connectableSides.hasConnectableLeft() || connectableSides.hasConnectableRight() && connectableSides.hasConnectableLeft() || isBackCorner);
        boolean bl = isCorner = connectableSides.hasConnectableFront() && connectableSides.hasConnectableLeft() != connectableSides.hasConnectableRight();
        if (connectableSides.hasConnectableFront()) {
            Direction cornerFacing = connectableSides.hasConnectableLeft() ? facing.getCounterClockWise() : facing.getClockWise();
            BlockPos cornerPos = pCurrentPos.relative(cornerFacing);
            BlockState stateBackCorner = pLevel.getBlockState(cornerPos);
            isFlatBack = isFlatBack || isCorner && (BnbBlocks.CHAIRS.contains(stateBackCorner.getBlock()) || stateBackCorner.isCollisionShapeFullBlock((BlockGetter)pLevel, cornerPos));
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)blockState.setValue((Property)LEFT_ARM, (Comparable)Boolean.valueOf(!connectableSides.hasConnectableLeft()))).setValue((Property)RIGHT_ARM, (Comparable)Boolean.valueOf(!connectableSides.hasConnectableRight()))).setValue((Property)CORNER, (Comparable)Boolean.valueOf(isCorner))).setValue((Property)BACK_FLAT, (Comparable)Boolean.valueOf(isFlatBack))).setValue((Property)INVERTED_CORNER, (Comparable)Boolean.valueOf(isInvertedCorner));
    }

    @NotNull
    private static ConnectableSides getConnectableSides(LevelAccessor pLevel, BlockPos pCurrentPos, Direction facing) {
        BlockState stateLeft = pLevel.getBlockState(pCurrentPos.relative(facing.getClockWise()));
        boolean hasConnectableLeft = AllBlocks.SEATS.contains(stateLeft.getBlock()) || stateLeft.getBlock() instanceof ChairBlock && (stateLeft.getValue((Property)FACING) == facing || stateLeft.getValue((Property)FACING) == facing.getCounterClockWise() || (Boolean)stateLeft.getValue((Property)INVERTED_CORNER) != false);
        BlockState stateRight = pLevel.getBlockState(pCurrentPos.relative(facing.getCounterClockWise()));
        boolean hasConnectableRight = AllBlocks.SEATS.contains(stateRight.getBlock()) || stateRight.getBlock() instanceof ChairBlock && (stateRight.getValue((Property)FACING) == facing || stateRight.getValue((Property)FACING) == facing.getClockWise() || (Boolean)stateRight.getValue((Property)INVERTED_CORNER) != false);
        BlockState stateFront = pLevel.getBlockState(pCurrentPos.relative(facing));
        boolean hasConnectableFront = stateFront.getBlock() instanceof ChairBlock && (stateFront.getValue((Property)FACING) == facing.getCounterClockWise() || stateFront.getValue((Property)FACING) == facing.getClockWise());
        return new ConnectableSides(hasConnectableLeft, hasConnectableRight, hasConnectableFront);
    }

    private static boolean getFlatObstructing(LevelAccessor pLevel, BlockState thisState, BlockPos pCurrentPos, Direction facing, BlockState blockState, BooleanProperty property) {
        BlockState sideState = pLevel.getBlockState(pCurrentPos.relative(facing));
        return sideState.getBlock() instanceof ChairBlock && sideState.getValue((Property)FACING) == facing;
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)super.rotate(state, rotation).setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    private record ConnectableSides(boolean hasConnectableLeft, boolean hasConnectableRight, boolean hasConnectableFront) {
    }
}

