/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.chain_pulley;

import com.kipti.bnb.registry.BnbBlocks;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionCollider;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.IControlContraption;
import com.simibubi.create.content.contraptions.TranslatingContraption;
import com.simibubi.create.content.contraptions.pulley.PulleyBlock;
import com.simibubi.create.content.contraptions.pulley.PulleyBlockEntity;
import com.simibubi.create.content.contraptions.pulley.PulleyContraption;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.infrastructure.config.AllConfigs;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class ChainPulleyBlockEntity
extends PulleyBlockEntity {
    public ChainPulleyBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void assemble() throws AssemblyException {
        BlockPos ropePos;
        BlockState ropeState;
        int i;
        if (!(this.level.getBlockState(this.worldPosition).getBlock() instanceof PulleyBlock)) {
            return;
        }
        if (this.speed == 0.0f && this.mirrorParent == null) {
            return;
        }
        int maxLength = (Integer)AllConfigs.server().kinetics.maxRopeLength.get();
        for (i = 1; i <= maxLength && (BnbBlocks.CHAIN_ROPE.has(ropeState = this.level.getBlockState(ropePos = this.worldPosition.below(i))) || BnbBlocks.CHAIN_PULLEY_MAGNET.has(ropeState)); ++i) {
        }
        this.offset = i - 1;
        if (this.offset >= (float)this.getExtensionRange() && this.getSpeed() > 0.0f) {
            return;
        }
        if (this.offset <= 0.0f && this.getSpeed() < 0.0f) {
            return;
        }
        if (!this.level.isClientSide && this.mirrorParent == null) {
            this.needsContraption = false;
            BlockPos anchor = this.worldPosition.below(Mth.floor((float)(this.offset + 1.0f)));
            this.initialOffset = Mth.floor((float)this.offset);
            PulleyContraption contraption = new PulleyContraption(this.initialOffset);
            boolean canAssembleStructure = contraption.assemble(this.level, anchor);
            if (canAssembleStructure) {
                Direction movementDirection;
                Direction direction = movementDirection = this.getSpeed() > 0.0f ? Direction.DOWN : Direction.UP;
                if (ContraptionCollider.isCollidingWithWorld((Level)this.level, (TranslatingContraption)contraption, (BlockPos)anchor.relative(movementDirection), (Direction)movementDirection)) {
                    canAssembleStructure = false;
                }
            }
            if (!canAssembleStructure && this.getSpeed() > 0.0f) {
                return;
            }
            this.removeRopes();
            if (!contraption.getBlocks().isEmpty()) {
                contraption.removeBlocksFromWorld(this.level, BlockPos.ZERO);
                this.movedContraption = ControlledContraptionEntity.create((Level)this.level, (IControlContraption)this, (Contraption)contraption);
                this.movedContraption.setPos((double)anchor.getX(), (double)anchor.getY(), (double)anchor.getZ());
                this.level.addFreshEntity((Entity)this.movedContraption);
                this.forceMove = true;
                this.needsContraption = true;
                if (contraption.containsBlockBreakers()) {
                    this.award(AllAdvancements.CONTRAPTION_ACTORS);
                }
                for (BlockPos pos : contraption.createColliders(this.level, Direction.UP)) {
                    BlockEntity blockEntity;
                    if (pos.getY() != 0 || !((blockEntity = this.level.getBlockEntity(new BlockPos((pos = pos.offset((Vec3i)anchor)).getX(), this.worldPosition.getY(), pos.getZ()))) instanceof PulleyBlockEntity)) continue;
                    PulleyBlockEntity pbe = (PulleyBlockEntity)blockEntity;
                    pbe.startMirroringOther(this.worldPosition);
                }
            }
        }
        if (this.mirrorParent != null) {
            this.removeRopes();
        }
        this.clientOffsetDiff = 0.0f;
        this.running = true;
        this.sendData();
    }

    private void removeRopes() {
        for (int i = (int)this.offset; i > 0; --i) {
            BlockPos offset = this.worldPosition.below(i);
            BlockState oldState = this.level.getBlockState(offset);
            this.level.setBlock(offset, oldState.getFluidState().createLegacyBlock(), 66);
        }
    }

    public void disassemble() {
        if (!this.running && this.movedContraption == null && this.mirrorParent == null) {
            return;
        }
        this.offset = this.getGridOffset(this.offset);
        if (this.movedContraption != null) {
            this.resetContraptionToOffset();
        }
        if (!this.level.isClientSide) {
            if (this.shouldCreateRopes()) {
                if (this.offset > 0.0f) {
                    BlockPos magnetPos = this.worldPosition.below((int)this.offset);
                    FluidState ifluidstate = this.level.getFluidState(magnetPos);
                    if (this.level.getBlockState(magnetPos).getDestroySpeed((BlockGetter)this.level, magnetPos) != -1.0f) {
                        this.level.destroyBlock(magnetPos, this.level.getBlockState(magnetPos).getCollisionShape((BlockGetter)this.level, magnetPos).isEmpty());
                        this.level.setBlock(magnetPos, (BlockState)BnbBlocks.CHAIN_PULLEY_MAGNET.getDefaultState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.getType() == Fluids.WATER)), 66);
                    }
                }
                boolean[] waterlog = new boolean[(int)this.offset];
                for (boolean destroyPass : Iterate.trueAndFalse) {
                    for (int i = 1; i <= (int)this.offset - 1; ++i) {
                        BlockPos ropePos = this.worldPosition.below(i);
                        if (this.level.getBlockState(ropePos).getDestroySpeed((BlockGetter)this.level, ropePos) == -1.0f) continue;
                        if (destroyPass) {
                            FluidState ifluidstate = this.level.getFluidState(ropePos);
                            waterlog[i] = ifluidstate.getType() == Fluids.WATER;
                            this.level.destroyBlock(ropePos, this.level.getBlockState(ropePos).getCollisionShape((BlockGetter)this.level, ropePos).isEmpty());
                            continue;
                        }
                        this.level.setBlock(this.worldPosition.below(i), (BlockState)BnbBlocks.CHAIN_ROPE.getDefaultState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(waterlog[i])), 66);
                    }
                }
            }
            if (this.movedContraption != null && this.mirrorParent == null) {
                this.movedContraption.disassemble();
            }
            this.notifyMirrorsOfDisassembly();
        }
        if (this.movedContraption != null) {
            this.movedContraption.discard();
        }
        this.movedContraption = null;
        this.initialOffset = 0;
        this.running = false;
        this.sendData();
    }
}

