/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.neoforge.stats;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.blay09.mods.balm.api.stats.BalmStats;
import net.blay09.mods.balm.neoforge.DeferredRegisters;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.Stats;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NeoForgeBalmStats
implements BalmStats {
    private final Map<String, Registrations> registrations = new ConcurrentHashMap<String, Registrations>();

    @Override
    public void registerCustomStat(ResourceLocation identifier) {
        DeferredRegister register = DeferredRegisters.get(Registries.CUSTOM_STAT, identifier.getNamespace());
        register.register(identifier.getPath(), () -> identifier);
    }

    public void register(String modId, IEventBus eventBus) {
        eventBus.register((Object)this.getRegistrations(modId));
    }

    private Registrations getActiveRegistrations() {
        return this.getRegistrations(ModLoadingContext.get().getActiveNamespace());
    }

    private Registrations getRegistrations(String modId) {
        return this.registrations.computeIfAbsent(modId, it -> new Registrations());
    }

    private static class Registrations {
        public final List<ResourceLocation> customStats = new ArrayList<ResourceLocation>();

        private Registrations() {
        }

        @SubscribeEvent
        public void commonSetup(FMLCommonSetupEvent event) {
            event.enqueueWork(() -> this.customStats.forEach(it -> Stats.CUSTOM.get(it, StatFormatter.DEFAULT)));
        }
    }
}

