/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.api.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.config.BalmConfig;
import net.blay09.mods.balm.api.config.LoadedConfig;
import net.blay09.mods.balm.api.config.LoadedTableConfig;
import net.blay09.mods.balm.api.config.MutableLoadedConfig;
import net.blay09.mods.balm.api.config.schema.BalmConfigSchema;
import net.blay09.mods.balm.api.config.schema.ConfiguredProperty;
import net.blay09.mods.balm.api.config.schema.builder.ConfigCategory;
import net.blay09.mods.balm.common.config.AbstractBalmConfig;
import net.blay09.mods.balm.common.config.ConfigSync;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record ClientboundConfigPacket(BalmConfigSchema schema, LoadedConfig config) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClientboundConfigPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"balm", (String)"config"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundConfigPacket> STREAM_CODEC = StreamCodec.of(ClientboundConfigPacket::encode, ClientboundConfigPacket::decode);

    private static ClientboundConfigPacket decode(RegistryFriendlyByteBuf buf) {
        ResourceLocation identifier = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buf);
        BalmConfigSchema schema = Balm.getConfig().getSchema(identifier);
        LoadedTableConfig config = new LoadedTableConfig();
        int rootPropertyCount = buf.readVarInt();
        for (int j = 0; j < rootPropertyCount; ++j) {
            String property = buf.readUtf();
            ConfiguredProperty<?> propertySchema = schema.findRootProperty(property);
            ClientboundConfigPacket.decodePropertyInto(propertySchema, (ByteBuf)buf, config);
        }
        int categoryCount = buf.readVarInt();
        for (int i = 0; i < categoryCount; ++i) {
            String category = buf.readUtf();
            int propertyCount = buf.readVarInt();
            for (int j = 0; j < propertyCount; ++j) {
                String property = buf.readUtf();
                ConfiguredProperty<?> propertySchema = schema.findProperty(category, property);
                ClientboundConfigPacket.decodePropertyInto(propertySchema, (ByteBuf)buf, config);
            }
        }
        return new ClientboundConfigPacket(schema, config);
    }

    private static void encode(RegistryFriendlyByteBuf buf, ClientboundConfigPacket packet) {
        ResourceLocation.STREAM_CODEC.encode((Object)buf, (Object)packet.schema.identifier());
        List<ConfiguredProperty> rootProperties = packet.schema.rootProperties().stream().filter(ConfiguredProperty::synced).toList();
        buf.writeVarInt(rootProperties.size());
        for (ConfiguredProperty rootProperty : rootProperties) {
            buf.writeUtf(rootProperty.name());
            ClientboundConfigPacket.encodeProperty(rootProperty, (ByteBuf)buf, packet.config);
        }
        List<ConfigCategory> categories = packet.schema.categories().stream().filter(ConfigSync::hasSyncedProperties).toList();
        buf.writeVarInt(categories.size());
        for (ConfigCategory category : categories) {
            buf.writeUtf(category.name());
            List<ConfiguredProperty> properties = category.properties().stream().filter(ConfiguredProperty::synced).toList();
            buf.writeVarInt(properties.size());
            for (ConfiguredProperty property : properties) {
                buf.writeUtf(property.name());
                ClientboundConfigPacket.encodeProperty(property, (ByteBuf)buf, packet.config);
            }
        }
    }

    private static <T> void decodePropertyInto(ConfiguredProperty<T> property, ByteBuf buf, MutableLoadedConfig config) {
        Object value = property.streamCodec().decode((Object)buf);
        config.setRaw(property, value);
    }

    private static <T> void encodeProperty(ConfiguredProperty<T> property, ByteBuf buf, LoadedConfig config) {
        T value = config.getRaw(property);
        property.streamCodec().encode((Object)buf, value);
    }

    public static void handle(Player player, ClientboundConfigPacket packet) {
        MutableLoadedConfig localConfig = Balm.getConfig().getLocalConfig(packet.schema);
        MutableLoadedConfig newConfig = localConfig.copy();
        newConfig.applyFrom(packet.schema, packet.config);
        BalmConfig balmConfig = Balm.getConfig();
        if (balmConfig instanceof AbstractBalmConfig) {
            AbstractBalmConfig config = (AbstractBalmConfig)balmConfig;
            config.setActiveConfig(packet.schema, newConfig);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

