/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.register.helpers.list_providers;

import com.tterrag.registrate.util.entry.BlockEntityEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.lopyluna.dndecor.register.helpers.list_providers.MaterialTypeProvider;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class StoneTypeBEList<T extends BlockEntity>
implements Iterable<BlockEntityEntry<T>> {
    private final BlockEntityEntry<?>[] values;

    public StoneTypeBEList(BiFunction<NonNullSupplier<Block>, String, BlockEntityEntry<? extends T>> filler) {
        MaterialTypeProvider.checkStoneTypeList();
        this.values = new BlockEntityEntry[MaterialTypeProvider.stoneTypes.size()];
        for (NonNullSupplier<Block> type : MaterialTypeProvider.stoneTypes) {
            int index = MaterialTypeProvider.stoneTypes.indexOf(type);
            String id = MaterialTypeProvider.stoneTypesRegister.get(type);
            if (index < 0) continue;
            this.values[index] = filler.apply(type, id);
        }
    }

    public BlockEntityEntry<T> get(Block block) {
        NonNullSupplier type = () -> block;
        int index = MaterialTypeProvider.stoneTypes.indexOf(type);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public BlockEntityEntry<T> get(NonNullSupplier<Block> type) {
        int index = MaterialTypeProvider.stoneTypes.indexOf(type);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public boolean contains(Block block) {
        for (BlockEntityEntry<?> entry : this.values) {
            if (!entry.is((Object)block)) continue;
            return true;
        }
        return false;
    }

    public BlockEntityEntry<T>[] toArray() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    @Override
    @NotNull
    public Iterator<BlockEntityEntry<T>> iterator() {
        return new Iterator<BlockEntityEntry<T>>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < StoneTypeBEList.this.values.length;
            }

            @Override
            public BlockEntityEntry<T> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return StoneTypeBEList.this.values[this.index++];
            }
        };
    }
}

