/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.tterrag.registrate.util.entry.RegistryEntry;
import dev.lopyluna.dndecor.DnDecorDatagen;
import dev.lopyluna.dndecor.register.AllMetalTypes;
import dev.lopyluna.dndecor.register.DnDecorBETypes;
import dev.lopyluna.dndecor.register.DnDecorBlocks;
import dev.lopyluna.dndecor.register.DnDecorConfigs;
import dev.lopyluna.dndecor.register.DnDecorCreativeTabs;
import dev.lopyluna.dndecor.register.DnDecorItems;
import dev.lopyluna.dndecor.register.DnDecorLangPartial;
import dev.lopyluna.dndecor.register.DnDecorStoneTypes;
import dev.lopyluna.dndecor.register.DnDecorTags;
import java.util.ArrayList;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.jetbrains.annotations.Nullable;

@Mod(value="dndecor")
public class DnDecor {
    public static final String NAME = "Design n' Decor";
    public static final String MOD_ID = "dndecor";
    public static final boolean LOAD_ALL_METALS = false;
    public static final CreateRegistrate REGISTRATE = ((CreateRegistrate)CreateRegistrate.create((String)"dndecor").defaultCreativeTab((ResourceKey)null)).setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));

    public DnDecor(IEventBus modEventBus, ModContainer modContainer) {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        REGISTRATE.registerEventListeners(modEventBus);
        AllMetalTypes.register();
        DnDecorStoneTypes.register(REGISTRATE);
        DnDecorLangPartial.init();
        DnDecorTags.init();
        DnDecorItems.register();
        DnDecorBlocks.register();
        DnDecorBETypes.register();
        DnDecorCreativeTabs.register(modEventBus);
        DnDecorConfigs.register(modLoadingContext, modContainer);
        modEventBus.addListener(this::addCreative);
        modEventBus.addListener(EventPriority.LOWEST, DnDecorDatagen::gatherData);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().equals(DnDecorCreativeTabs.BASE_CREATIVE_TAB.getKey())) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (RegistryEntry entry : REGISTRATE.getAll(Registries.ITEM)) {
                ItemStack stack;
                Item item = (Item)entry.get();
                if (item instanceof BlockItem || item instanceof BucketItem || (stack = item.getDefaultInstance()).isEmpty()) continue;
                if (stack.is(DnDecorTags.ItemTags.PALETTE_BLOCKS.tag)) {
                    stacks.add(stack);
                    continue;
                }
                event.accept(stack);
            }
            for (RegistryEntry entry : REGISTRATE.getAll(Registries.BLOCK)) {
                Block block = (Block)entry.get();
                Item item = block.asItem();
                ItemStack stack = item.getDefaultInstance();
                if (stack.isEmpty()) continue;
                if (stack.is(DnDecorTags.ItemTags.PALETTE_BLOCKS.tag)) {
                    stacks.add(stack);
                    continue;
                }
                event.accept(stack);
            }
            for (ItemStack stack : stacks) {
                event.accept(stack);
            }
        }
    }

    public static LangBuilder lang() {
        return new LangBuilder(MOD_ID);
    }

    public static ResourceLocation asResource(String loc) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)loc);
    }

    public static ResourceLocation emptyLoc() {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"empty");
    }

    @Nullable
    public static KineticStats create(Item item) {
        BlockItem blockItem;
        Block block;
        if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).getBlock()) instanceof IRotate) {
            return new KineticStats(block);
        }
        return null;
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)DnDecor.create(item))));
    }
}

