/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.control.collection;

import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.control.collection.GuiStackSelectorExtension;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.extension.GuiExtensionCreator;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.mc.StackUtils;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.creativecore.common.util.type.map.HashMapList;

public class GuiStackSelector
extends GuiLabel {
    public final Player player;
    protected GuiExtensionCreator<GuiStackSelector, GuiStackSelectorExtension> ex = new GuiExtensionCreator(this);
    protected StackCollector collector;
    protected HashMapList<String, ItemStack> stacks;
    protected ItemStack selected = ItemStack.EMPTY;
    private boolean searchbar;

    public GuiStackSelector(String name, Player player, StackCollector collector, boolean searchbar) {
        super(name);
        this.player = player;
        this.searchbar = searchbar;
        this.collector = collector;
        this.updateCollectedStacks();
        this.selectFirst();
        this.setAlign(Align.CENTER);
    }

    public GuiStackSelector(String name, Player player, StackCollector collector) {
        this(name, player, collector, true);
    }

    public GuiStackSelector setWidth(int width) {
        this.setDim(width, 14);
        return this;
    }

    public boolean hasSearchbar() {
        return this.searchbar;
    }

    public GuiStackSelector setSearchbar(boolean searchbar) {
        this.searchbar = searchbar;
        return this;
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        this.ex.toggle(this::createBox);
        GuiStackSelector.playSound((Holder.Reference<SoundEvent>)SoundEvents.UI_BUTTON_CLICK);
        return true;
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.CLICKABLE;
    }

    public boolean selectFirst() {
        ItemStack first;
        if (this.stacks != null && (first = this.stacks.getFirst()) != null) {
            this.setSelected(first);
            return true;
        }
        return false;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    public void updateCollectedStacks() {
        this.stacks = this.collector.collect(this.player);
    }

    public boolean setSelectedForce(ItemStack stack) {
        this.setTitle(new TextBuilder().stack(stack).add(stack.getHoverName()).build());
        this.selected = stack;
        this.raiseEvent(new GuiControlChangedEvent<GuiStackSelector>(this));
        return true;
    }

    public boolean setSelected(ItemStack stack) {
        if (this.stacks.contains(stack)) {
            this.setTitle(new TextBuilder().stack(stack).add(stack.getHoverName()).build());
            this.selected = stack;
            this.raiseEvent(new GuiControlChangedEvent<GuiStackSelector>(this));
            return true;
        }
        return false;
    }

    public HashMapList<String, ItemStack> getStacks() {
        return this.stacks;
    }

    public ItemStack getSelected() {
        return this.selected;
    }

    protected GuiStackSelectorExtension createBox(GuiExtensionCreator<GuiStackSelector, GuiStackSelectorExtension> creator) {
        return new GuiStackSelectorExtension(this.name + "extension", this.getPlayer(), creator);
    }

    @Override
    public void looseFocus() {
        if (this.ex.checkShouldClose()) {
            this.ex.close();
        }
    }

    public static boolean contains(String search, ItemStack stack) {
        if (search.isEmpty()) {
            return true;
        }
        if (GuiStackSelector.getItemName(stack).toLowerCase().contains(search)) {
            return true;
        }
        for (Component line : stack.getTooltipLines(Item.TooltipContext.EMPTY, null, (TooltipFlag)TooltipFlag.Default.NORMAL)) {
            if (!line.getString().toLowerCase().contains(search)) continue;
            return true;
        }
        return false;
    }

    public static String getItemName(ItemStack stack) {
        String itemName = "";
        try {
            itemName = stack.getDisplayName().getString();
        }
        catch (Exception e) {
            itemName = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
        }
        return itemName;
    }

    public static abstract class StackCollector {
        public StackSelector selector;

        public StackCollector(StackSelector selector) {
            this.selector = selector;
        }

        public abstract HashMapList<String, ItemStack> collect(Player var1);
    }

    public static class GuiBlockSelector
    extends SearchSelector {
        @Override
        public boolean allow(ItemStack stack) {
            if (super.allow(stack)) {
                return !(Block.byItem((Item)stack.getItem()) instanceof AirBlock);
            }
            return false;
        }
    }

    public static class SearchSelector
    extends StackSelector {
        public String search = "";

        @Override
        public boolean allow(ItemStack stack) {
            return GuiStackSelector.contains(this.search, stack);
        }
    }

    public static abstract class StackSelector {
        public abstract boolean allow(ItemStack var1);
    }

    public static class CreativeCollector
    extends InventoryCollector {
        public CreativeCollector(StackSelector selector) {
            super(selector);
        }

        @Override
        public HashMapList<String, ItemStack> collect(Player player) {
            HashMapList<String, ItemStack> stacks = super.collect(player);
            ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
            for (Item item : BuiltInRegistries.ITEM) {
                ItemStack stack = new ItemStack((ItemLike)item);
                if (!this.selector.allow(stack)) continue;
                newStacks.add(stack);
            }
            stacks.add("collector.all", (ItemStack)newStacks);
            return stacks;
        }
    }

    public static class InventoryCollector
    extends StackCollector {
        public InventoryCollector(StackSelector selector) {
            super(selector);
        }

        @Override
        public HashMapList<String, ItemStack> collect(Player player) {
            HashMapList<String, ItemStack> stacks = new HashMapList<String, ItemStack>();
            if (player != null) {
                ArrayList<ItemStack> tempStacks = new ArrayList<ItemStack>();
                for (ItemStack stack : player.inventoryMenu.getItems()) {
                    if (!stack.isEmpty() && this.selector.allow(stack)) {
                        tempStacks.add(stack.copy());
                        continue;
                    }
                    StackUtils.collect(stack, this.selector::allow, tempStacks);
                }
                stacks.add("collector.inventory", (ItemStack)tempStacks);
            }
            return stacks;
        }
    }
}

