/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.items;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.StackCopySlot;

public class ItemHandlerCopySlot
extends StackCopySlot {
    private final SlotItemHandler slotItemHandler;

    public ItemHandlerCopySlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        super(xPosition, yPosition);
        this.slotItemHandler = new SlotItemHandler(itemHandler, index, xPosition, yPosition);
    }

    public ItemHandlerCopySlot(SlotItemHandler slotItemHandler) {
        super(slotItemHandler.x, slotItemHandler.y);
        this.slotItemHandler = slotItemHandler;
    }

    public boolean mayPlace(ItemStack stack) {
        return this.slotItemHandler.mayPlace(stack);
    }

    @Override
    protected ItemStack getStackCopy() {
        return this.slotItemHandler.getItem();
    }

    @Override
    protected void setStackCopy(ItemStack stack) {
        ((IItemHandlerModifiable)this.slotItemHandler.getItemHandler()).setStackInSlot(this.slotItemHandler.index, stack);
    }

    public void onQuickCraft(ItemStack oldStackIn, ItemStack newStackIn) {
        this.slotItemHandler.onQuickCraft(oldStackIn, newStackIn);
    }

    public int getMaxStackSize() {
        return this.slotItemHandler.getMaxStackSize();
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.slotItemHandler.getMaxStackSize(stack);
    }

    public boolean mayPickup(Player playerIn) {
        return this.slotItemHandler.mayPickup(playerIn);
    }

    public boolean isSameInventory(Slot other) {
        return this.slotItemHandler.isSameInventory(other);
    }

    public IItemHandler getItemHandler() {
        return this.slotItemHandler.getItemHandler();
    }
}

