/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class BooleanAttribute
extends Attribute {
    public BooleanAttribute(String descriptionId, boolean defaultValue) {
        super(descriptionId, defaultValue ? 1.0 : 0.0);
    }

    public double sanitizeValue(double value) {
        if (Double.isNaN(value)) {
            return 0.0;
        }
        return value > 0.0 ? 1.0 : 0.0;
    }

    public MutableComponent toValueComponent(@Nullable AttributeModifier.Operation op, double value, TooltipFlag flag) {
        if (op == null) {
            return Component.translatable((String)("neoforge.value.boolean." + (value > 0.0 ? "enabled" : "disabled")));
        }
        if (op == AttributeModifier.Operation.ADD_VALUE && value > 0.0) {
            return Component.translatable((String)"neoforge.value.boolean.enable");
        }
        if (op == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL && (int)value == -1) {
            return Component.translatable((String)"neoforge.value.boolean.disable");
        }
        return Component.translatable((String)"neoforge.value.boolean.invalid");
    }

    public MutableComponent toComponent(AttributeModifier modif, TooltipFlag flag) {
        double value = modif.amount();
        ChatFormatting color = this.getStyle(value > 0.0);
        MutableComponent comp = Component.translatable((String)"neoforge.modifier.bool", (Object[])new Object[]{this.toValueComponent(modif.operation(), value, flag), Component.translatable((String)this.getDescriptionId())}).withStyle(color);
        return comp.append(this.getDebugInfo(modif, flag));
    }
}

