/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.neoforged.fml.loading.mixin.FMLMixinContainerHandle;
import net.neoforged.fml.loading.mixin.FMLMixinPlatformAgent;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.launch.GlobalProperties;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.launch.platform.container.IContainerHandle;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.transformer.Config;

public class DeferredMixinConfigRegistration {
    private static final Logger LOG = LoggerFactory.getLogger((String)"fml-mixin-setup");
    private static boolean added = false;
    private static final List<ConfigInfo> mixinConfigs = new ArrayList<ConfigInfo>();

    public static void addMixinConfig(String config) {
        DeferredMixinConfigRegistration.addMixinConfig(config, null);
    }

    public static void addMixinConfig(String config, @Nullable String modId) {
        if (added) {
            throw new IllegalStateException("Too late to add mixin configs!");
        }
        mixinConfigs.add(new ConfigInfo(config, modId));
    }

    static void registerConfigs() {
        added = true;
        mixinConfigs.forEach(cfg -> Mixins.addConfiguration((String)cfg.fileName()));
        Map<String, IMixinConfig> configMap = Mixins.getConfigs().stream().collect(Collectors.toMap(Config::getName, Config::getConfig));
        mixinConfigs.forEach(cfg -> {
            if (cfg.modId() == null) {
                return;
            }
            IMixinConfig config = (IMixinConfig)configMap.get(cfg.fileName());
            if (config == null) {
                LOG.warn("Config file {} was not registered!", (Object)cfg.fileName());
            } else {
                config.decorate("fabric-modId", (Object)cfg.modId());
            }
        });
        mixinConfigs.clear();
    }

    static {
        List agentClassNames = (List)GlobalProperties.get((GlobalProperties.Keys)GlobalProperties.Keys.AGENTS);
        agentClassNames.add(FMLMixinPlatformAgent.class.getName());
        MixinBootstrap.getPlatform().addContainer((IContainerHandle)new FMLMixinContainerHandle());
    }

    record ConfigInfo(String fileName, @Nullable String modId) {
    }
}

