/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import com.mojang.logging.LogUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.neoforged.fml.loading.LogMarkers;
import org.slf4j.Logger;

public class ClasspathLocatorUtils {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static Path findJarPathFor(String resourceName, String jarName, URL resource) {
        try {
            Path path;
            URI uri = resource.toURI();
            if (uri.getScheme().equals("jar") && uri.getRawSchemeSpecificPart().contains("!/")) {
                int lastExcl = uri.getRawSchemeSpecificPart().lastIndexOf("!/");
                path = Paths.get(new URI(uri.getRawSchemeSpecificPart().substring(0, lastExcl)));
            } else {
                path = Paths.get(new URI("file://" + uri.getRawSchemeSpecificPart().substring(0, uri.getRawSchemeSpecificPart().length() - resourceName.length())));
            }
            return path;
        }
        catch (NullPointerException | URISyntaxException e) {
            LOGGER.error(LogMarkers.SCAN, "Failed to find JAR for class {} - {}", (Object)resourceName, (Object)jarName);
            throw new RuntimeException("Unable to locate " + resourceName + " - " + jarName, e);
        }
    }
}

