/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.config;

import com.mojang.logging.LogUtils;
import java.nio.file.Path;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import org.slf4j.Logger;

class ConfigWatcher
implements Runnable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ModConfig modConfig;
    private final Path path;
    private final ClassLoader realClassLoader;

    ConfigWatcher(ModConfig modConfig, Path path, ClassLoader classLoader) {
        this.modConfig = modConfig;
        this.path = path;
        this.realClassLoader = classLoader;
    }

    @Override
    public void run() {
        ClassLoader previousLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.realClassLoader);
        try {
            this.modConfig.lock.lock();
            try {
                LOGGER.debug(ConfigTracker.CONFIG, "Config file {} changed, re-loading", (Object)this.modConfig.getFileName());
                ConfigTracker.loadConfig(this.modConfig, this.path, ModConfigEvent.Reloading::new);
            }
            finally {
                this.modConfig.lock.unlock();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousLoader);
        }
    }
}

