/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import net.neoforged.fml.Logging;
import net.neoforged.fml.loading.FMLConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModWorkManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Executor syncWorkExecutor = Executors.newSingleThreadExecutor(r -> {
        Thread thread = new Thread(r, "modloading-sync-worker");
        thread.setDaemon(true);
        return thread;
    });
    private static ForkJoinPool parallelThreadPool;

    public static Executor syncExecutor() {
        return syncWorkExecutor;
    }

    public static Executor parallelExecutor() {
        if (parallelThreadPool == null) {
            int loadingThreadCount = FMLConfig.getIntConfigValue(FMLConfig.ConfigValue.MAX_THREADS);
            LOGGER.debug(Logging.LOADING, "Using {} threads for parallel mod-loading", (Object)loadingThreadCount);
            parallelThreadPool = new ForkJoinPool(loadingThreadCount, ModWorkManager::newForkJoinWorkerThread, null, false);
        }
        return parallelThreadPool;
    }

    private static ForkJoinWorkerThread newForkJoinWorkerThread(ForkJoinPool pool) {
        ForkJoinWorkerThread thread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
        thread.setName("modloading-worker-" + thread.getPoolIndex());
        thread.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        return thread;
    }
}

