/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ConduitBlockEntity
extends BlockEntity {
    private static final int BLOCK_REFRESH_RATE = 2;
    private static final int EFFECT_DURATION = 13;
    private static final float ROTATION_SPEED = -0.0375f;
    private static final int MIN_ACTIVE_SIZE = 16;
    private static final int MIN_KILL_SIZE = 42;
    private static final int KILL_RANGE = 8;
    private static final Block[] VALID_BLOCKS = new Block[]{Blocks.PRISMARINE, Blocks.PRISMARINE_BRICKS, Blocks.SEA_LANTERN, Blocks.DARK_PRISMARINE};
    public int tickCount;
    private float activeRotation;
    private boolean isActive;
    private boolean isHunting;
    private final List<BlockPos> effectBlocks = Lists.newArrayList();
    @Nullable
    private LivingEntity destroyTarget;
    @Nullable
    private UUID destroyTargetUUID;
    private long nextAmbientSoundActivation;

    public ConduitBlockEntity(BlockPos p_155397_, BlockState p_155398_) {
        super(BlockEntityType.CONDUIT, p_155397_, p_155398_);
    }

    @Override
    protected void loadAdditional(CompoundTag p_338591_, HolderLookup.Provider p_338280_) {
        super.loadAdditional(p_338591_, p_338280_);
        this.destroyTargetUUID = p_338591_.hasUUID("Target") ? p_338591_.getUUID("Target") : null;
    }

    @Override
    protected void saveAdditional(CompoundTag p_187495_, HolderLookup.Provider p_323702_) {
        super.saveAdditional(p_187495_, p_323702_);
        if (this.destroyTarget != null) {
            p_187495_.putUUID("Target", this.destroyTarget.getUUID());
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider p_324390_) {
        return this.saveCustomOnly(p_324390_);
    }

    public static void clientTick(Level p_155404_, BlockPos p_155405_, BlockState p_155406_, ConduitBlockEntity p_155407_) {
        ++p_155407_.tickCount;
        long $$4 = p_155404_.getGameTime();
        List<BlockPos> $$5 = p_155407_.effectBlocks;
        if ($$4 % 40L == 0L) {
            p_155407_.isActive = ConduitBlockEntity.updateShape(p_155404_, p_155405_, $$5);
            ConduitBlockEntity.updateHunting(p_155407_, $$5);
        }
        ConduitBlockEntity.updateClientTarget(p_155404_, p_155405_, p_155407_);
        ConduitBlockEntity.animationTick(p_155404_, p_155405_, $$5, p_155407_.destroyTarget, p_155407_.tickCount);
        if (p_155407_.isActive()) {
            p_155407_.activeRotation += 1.0f;
        }
    }

    public static void serverTick(Level p_155439_, BlockPos p_155440_, BlockState p_155441_, ConduitBlockEntity p_155442_) {
        ++p_155442_.tickCount;
        long $$4 = p_155439_.getGameTime();
        List<BlockPos> $$5 = p_155442_.effectBlocks;
        if ($$4 % 40L == 0L) {
            boolean $$6 = ConduitBlockEntity.updateShape(p_155439_, p_155440_, $$5);
            if ($$6 != p_155442_.isActive) {
                SoundEvent $$7 = $$6 ? SoundEvents.CONDUIT_ACTIVATE : SoundEvents.CONDUIT_DEACTIVATE;
                p_155439_.playSound(null, p_155440_, $$7, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            p_155442_.isActive = $$6;
            ConduitBlockEntity.updateHunting(p_155442_, $$5);
            if ($$6) {
                ConduitBlockEntity.applyEffects(p_155439_, p_155440_, $$5);
                ConduitBlockEntity.updateDestroyTarget(p_155439_, p_155440_, p_155441_, $$5, p_155442_);
            }
        }
        if (p_155442_.isActive()) {
            if ($$4 % 80L == 0L) {
                p_155439_.playSound(null, p_155440_, SoundEvents.CONDUIT_AMBIENT, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if ($$4 > p_155442_.nextAmbientSoundActivation) {
                p_155442_.nextAmbientSoundActivation = $$4 + 60L + (long)p_155439_.getRandom().nextInt(40);
                p_155439_.playSound(null, p_155440_, SoundEvents.CONDUIT_AMBIENT_SHORT, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    private static void updateHunting(ConduitBlockEntity p_155429_, List<BlockPos> p_155430_) {
        p_155429_.setHunting(p_155430_.size() >= 42);
    }

    private static boolean updateShape(Level p_155415_, BlockPos p_155416_, List<BlockPos> p_155417_) {
        p_155417_.clear();
        for (int $$3 = -1; $$3 <= 1; ++$$3) {
            for (int $$4 = -1; $$4 <= 1; ++$$4) {
                for (int $$5 = -1; $$5 <= 1; ++$$5) {
                    BlockPos $$6 = p_155416_.offset($$3, $$4, $$5);
                    if (p_155415_.isWaterAt($$6)) continue;
                    return false;
                }
            }
        }
        for (int $$7 = -2; $$7 <= 2; ++$$7) {
            for (int $$8 = -2; $$8 <= 2; ++$$8) {
                for (int $$9 = -2; $$9 <= 2; ++$$9) {
                    int $$10 = Math.abs($$7);
                    int $$11 = Math.abs($$8);
                    int $$12 = Math.abs($$9);
                    if ($$10 <= 1 && $$11 <= 1 && $$12 <= 1 || ($$7 != 0 || $$11 != 2 && $$12 != 2) && ($$8 != 0 || $$10 != 2 && $$12 != 2) && ($$9 != 0 || $$10 != 2 && $$11 != 2)) continue;
                    BlockPos $$13 = p_155416_.offset($$7, $$8, $$9);
                    BlockState $$14 = p_155415_.getBlockState($$13);
                    for (Block $$15 : VALID_BLOCKS) {
                        if (!$$14.is($$15)) continue;
                        p_155417_.add($$13);
                    }
                }
            }
        }
        return p_155417_.size() >= 16;
    }

    private static void applyEffects(Level p_155444_, BlockPos p_155445_, List<BlockPos> p_155446_) {
        int $$7;
        int $$6;
        int $$3 = p_155446_.size();
        int $$4 = $$3 / 7 * 16;
        int $$5 = p_155445_.getX();
        AABB $$8 = new AABB($$5, $$6 = p_155445_.getY(), $$7 = p_155445_.getZ(), $$5 + 1, $$6 + 1, $$7 + 1).inflate($$4).expandTowards(0.0, p_155444_.getHeight(), 0.0);
        List<Player> $$9 = p_155444_.getEntitiesOfClass(Player.class, $$8);
        if ($$9.isEmpty()) {
            return;
        }
        for (Player $$10 : $$9) {
            if (!p_155445_.closerThan($$10.blockPosition(), $$4) || !$$10.isInWaterOrRain()) continue;
            $$10.addEffect(new MobEffectInstance(MobEffects.CONDUIT_POWER, 260, 0, true, true));
        }
    }

    private static void updateDestroyTarget(Level p_155409_, BlockPos p_155410_, BlockState p_155411_, List<BlockPos> p_155412_, ConduitBlockEntity p_155413_) {
        LivingEntity $$5 = p_155413_.destroyTarget;
        int $$6 = p_155412_.size();
        if ($$6 < 42) {
            p_155413_.destroyTarget = null;
        } else if (p_155413_.destroyTarget == null && p_155413_.destroyTargetUUID != null) {
            p_155413_.destroyTarget = ConduitBlockEntity.findDestroyTarget(p_155409_, p_155410_, p_155413_.destroyTargetUUID);
            p_155413_.destroyTargetUUID = null;
        } else if (p_155413_.destroyTarget == null) {
            List<LivingEntity> $$7 = p_155409_.getEntitiesOfClass(LivingEntity.class, ConduitBlockEntity.getDestroyRangeAABB(p_155410_), p_350210_ -> p_350210_ instanceof Enemy && p_350210_.isInWaterOrRain());
            if (!$$7.isEmpty()) {
                p_155413_.destroyTarget = $$7.get(p_155409_.random.nextInt($$7.size()));
            }
        } else if (!p_155413_.destroyTarget.isAlive() || !p_155410_.closerThan(p_155413_.destroyTarget.blockPosition(), 8.0)) {
            p_155413_.destroyTarget = null;
        }
        if (p_155413_.destroyTarget != null) {
            p_155409_.playSound(null, p_155413_.destroyTarget.getX(), p_155413_.destroyTarget.getY(), p_155413_.destroyTarget.getZ(), SoundEvents.CONDUIT_ATTACK_TARGET, SoundSource.BLOCKS, 1.0f, 1.0f);
            p_155413_.destroyTarget.hurt(p_155409_.damageSources().magic(), 4.0f);
        }
        if ($$5 != p_155413_.destroyTarget) {
            p_155409_.sendBlockUpdated(p_155410_, p_155411_, p_155411_, 2);
        }
    }

    private static void updateClientTarget(Level p_155400_, BlockPos p_155401_, ConduitBlockEntity p_155402_) {
        if (p_155402_.destroyTargetUUID == null) {
            p_155402_.destroyTarget = null;
        } else if (p_155402_.destroyTarget == null || !p_155402_.destroyTarget.getUUID().equals(p_155402_.destroyTargetUUID)) {
            p_155402_.destroyTarget = ConduitBlockEntity.findDestroyTarget(p_155400_, p_155401_, p_155402_.destroyTargetUUID);
            if (p_155402_.destroyTarget == null) {
                p_155402_.destroyTargetUUID = null;
            }
        }
    }

    private static AABB getDestroyRangeAABB(BlockPos p_155432_) {
        int $$1 = p_155432_.getX();
        int $$2 = p_155432_.getY();
        int $$3 = p_155432_.getZ();
        return new AABB($$1, $$2, $$3, $$1 + 1, $$2 + 1, $$3 + 1).inflate(8.0);
    }

    @Nullable
    private static LivingEntity findDestroyTarget(Level p_155425_, BlockPos p_155426_, UUID p_155427_) {
        List<LivingEntity> $$3 = p_155425_.getEntitiesOfClass(LivingEntity.class, ConduitBlockEntity.getDestroyRangeAABB(p_155426_), p_352880_ -> p_352880_.getUUID().equals(p_155427_));
        if ($$3.size() == 1) {
            return $$3.get(0);
        }
        return null;
    }

    private static void animationTick(Level p_155419_, BlockPos p_155420_, List<BlockPos> p_155421_, @Nullable Entity p_155422_, int p_155423_) {
        RandomSource $$5 = p_155419_.random;
        double $$6 = Mth.sin((float)(p_155423_ + 35) * 0.1f) / 2.0f + 0.5f;
        $$6 = ($$6 * $$6 + $$6) * (double)0.3f;
        Vec3 $$7 = new Vec3((double)p_155420_.getX() + 0.5, (double)p_155420_.getY() + 1.5 + $$6, (double)p_155420_.getZ() + 0.5);
        for (BlockPos $$8 : p_155421_) {
            if ($$5.nextInt(50) != 0) continue;
            BlockPos $$9 = $$8.subtract(p_155420_);
            float $$10 = -0.5f + $$5.nextFloat() + (float)$$9.getX();
            float $$11 = -2.0f + $$5.nextFloat() + (float)$$9.getY();
            float $$12 = -0.5f + $$5.nextFloat() + (float)$$9.getZ();
            p_155419_.addParticle(ParticleTypes.NAUTILUS, $$7.x, $$7.y, $$7.z, $$10, $$11, $$12);
        }
        if (p_155422_ != null) {
            Vec3 $$13 = new Vec3(p_155422_.getX(), p_155422_.getEyeY(), p_155422_.getZ());
            float $$14 = (-0.5f + $$5.nextFloat()) * (3.0f + p_155422_.getBbWidth());
            float $$15 = -1.0f + $$5.nextFloat() * p_155422_.getBbHeight();
            float $$16 = (-0.5f + $$5.nextFloat()) * (3.0f + p_155422_.getBbWidth());
            Vec3 $$17 = new Vec3($$14, $$15, $$16);
            p_155419_.addParticle(ParticleTypes.NAUTILUS, $$13.x, $$13.y, $$13.z, $$17.x, $$17.y, $$17.z);
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isHunting() {
        return this.isHunting;
    }

    private void setHunting(boolean p_59215_) {
        this.isHunting = p_59215_;
    }

    public float getActiveRotation(float p_59198_) {
        return (this.activeRotation + p_59198_) * -0.0375f;
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

