/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class TntBlock
extends Block {
    public static final MapCodec<TntBlock> CODEC = TntBlock.simpleCodec(TntBlock::new);
    public static final BooleanProperty UNSTABLE = BlockStateProperties.UNSTABLE;

    public MapCodec<TntBlock> codec() {
        return CODEC;
    }

    public TntBlock(BlockBehaviour.Properties p_57422_) {
        super(p_57422_);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(UNSTABLE, false));
    }

    @Override
    protected void onPlace(BlockState p_57466_, Level p_57467_, BlockPos p_57468_, BlockState p_57469_, boolean p_57470_) {
        if (p_57469_.is(p_57466_.getBlock())) {
            return;
        }
        if (p_57467_.hasNeighborSignal(p_57468_)) {
            TntBlock.explode(p_57467_, p_57468_);
            p_57467_.removeBlock(p_57468_, false);
        }
    }

    @Override
    protected void neighborChanged(BlockState p_57457_, Level p_57458_, BlockPos p_57459_, Block p_57460_, BlockPos p_57461_, boolean p_57462_) {
        if (p_57458_.hasNeighborSignal(p_57459_)) {
            TntBlock.explode(p_57458_, p_57459_);
            p_57458_.removeBlock(p_57459_, false);
        }
    }

    @Override
    public BlockState playerWillDestroy(Level p_57445_, BlockPos p_57446_, BlockState p_57447_, Player p_57448_) {
        if (!p_57445_.isClientSide() && !p_57448_.isCreative() && p_57447_.getValue(UNSTABLE).booleanValue()) {
            TntBlock.explode(p_57445_, p_57446_);
        }
        return super.playerWillDestroy(p_57445_, p_57446_, p_57447_, p_57448_);
    }

    @Override
    public void wasExploded(Level p_57441_, BlockPos p_57442_, Explosion p_57443_) {
        if (p_57441_.isClientSide) {
            return;
        }
        PrimedTnt $$3 = new PrimedTnt(p_57441_, (double)p_57442_.getX() + 0.5, p_57442_.getY(), (double)p_57442_.getZ() + 0.5, p_57443_.getIndirectSourceEntity());
        int $$4 = $$3.getFuse();
        $$3.setFuse((short)(p_57441_.random.nextInt($$4 / 4) + $$4 / 8));
        p_57441_.addFreshEntity($$3);
    }

    public static void explode(Level p_57434_, BlockPos p_57435_) {
        TntBlock.explode(p_57434_, p_57435_, null);
    }

    private static void explode(Level p_57437_, BlockPos p_57438_, @Nullable LivingEntity p_57439_) {
        if (p_57437_.isClientSide) {
            return;
        }
        PrimedTnt $$3 = new PrimedTnt(p_57437_, (double)p_57438_.getX() + 0.5, p_57438_.getY(), (double)p_57438_.getZ() + 0.5, p_57439_);
        p_57437_.addFreshEntity($$3);
        p_57437_.playSound(null, $$3.getX(), $$3.getY(), $$3.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
        p_57437_.gameEvent((Entity)p_57439_, GameEvent.PRIME_FUSE, p_57438_);
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack p_316149_, BlockState p_316217_, Level p_316520_, BlockPos p_316601_, Player p_316770_, InteractionHand p_316393_, BlockHitResult p_316532_) {
        if (!p_316149_.is(Items.FLINT_AND_STEEL) && !p_316149_.is(Items.FIRE_CHARGE)) {
            return super.useItemOn(p_316149_, p_316217_, p_316520_, p_316601_, p_316770_, p_316393_, p_316532_);
        }
        TntBlock.explode(p_316520_, p_316601_, p_316770_);
        p_316520_.setBlock(p_316601_, Blocks.AIR.defaultBlockState(), 11);
        Item $$7 = p_316149_.getItem();
        if (p_316149_.is(Items.FLINT_AND_STEEL)) {
            p_316149_.hurtAndBreak(1, p_316770_, LivingEntity.getSlotForHand(p_316393_));
        } else {
            p_316149_.consume(1, p_316770_);
        }
        p_316770_.awardStat(Stats.ITEM_USED.get($$7));
        return ItemInteractionResult.sidedSuccess(p_316520_.isClientSide);
    }

    @Override
    protected void onProjectileHit(Level p_57429_, BlockState p_57430_, BlockHitResult p_57431_, Projectile p_57432_) {
        if (!p_57429_.isClientSide) {
            BlockPos $$4 = p_57431_.getBlockPos();
            Entity $$5 = p_57432_.getOwner();
            if (p_57432_.isOnFire() && p_57432_.mayInteract(p_57429_, $$4)) {
                TntBlock.explode(p_57429_, $$4, $$5 instanceof LivingEntity ? (LivingEntity)$$5 : null);
                p_57429_.removeBlock($$4, false);
            }
        }
    }

    @Override
    public boolean dropFromExplosion(Explosion p_57427_) {
        return false;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_57464_) {
        p_57464_.add(UNSTABLE);
    }
}

