/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class ShearsItem
extends Item {
    public ShearsItem(Item.Properties p_43074_) {
        super(p_43074_);
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(Tool.Rule.minesAndDrops(List.of(Blocks.COBWEB), 15.0f), Tool.Rule.overrideSpeed(BlockTags.LEAVES, 15.0f), Tool.Rule.overrideSpeed(BlockTags.WOOL, 5.0f), Tool.Rule.overrideSpeed(List.of(Blocks.VINE, Blocks.GLOW_LICHEN), 2.0f)), 1.0f, 1);
    }

    @Override
    public boolean mineBlock(ItemStack p_43078_, Level p_43079_, BlockState p_43080_, BlockPos p_43081_, LivingEntity p_43082_) {
        if (!p_43079_.isClientSide && !p_43080_.is(BlockTags.FIRE)) {
            p_43078_.hurtAndBreak(1, p_43082_, EquipmentSlot.MAINHAND);
        }
        return p_43080_.is(BlockTags.LEAVES) || p_43080_.is(Blocks.COBWEB) || p_43080_.is(Blocks.SHORT_GRASS) || p_43080_.is(Blocks.FERN) || p_43080_.is(Blocks.DEAD_BUSH) || p_43080_.is(Blocks.HANGING_ROOTS) || p_43080_.is(Blocks.VINE) || p_43080_.is(Blocks.TRIPWIRE) || p_43080_.is(BlockTags.WOOL);
    }

    @Override
    public InteractionResult useOn(UseOnContext p_186371_) {
        GrowingPlantHeadBlock $$5;
        BlockPos $$2;
        Level $$1 = p_186371_.getLevel();
        BlockState $$3 = $$1.getBlockState($$2 = p_186371_.getClickedPos());
        Block $$4 = $$3.getBlock();
        if ($$4 instanceof GrowingPlantHeadBlock && !($$5 = (GrowingPlantHeadBlock)$$4).isMaxAge($$3)) {
            Player $$6 = p_186371_.getPlayer();
            ItemStack $$7 = p_186371_.getItemInHand();
            if ($$6 instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)$$6, $$2, $$7);
            }
            $$1.playSound($$6, $$2, SoundEvents.GROWING_PLANT_CROP, SoundSource.BLOCKS, 1.0f, 1.0f);
            BlockState $$8 = $$5.getMaxAgeState($$3);
            $$1.setBlockAndUpdate($$2, $$8);
            $$1.gameEvent(GameEvent.BLOCK_CHANGE, $$2, GameEvent.Context.of(p_186371_.getPlayer(), $$8));
            if ($$6 != null) {
                $$7.hurtAndBreak(1, $$6, LivingEntity.getSlotForHand(p_186371_.getHand()));
            }
            return InteractionResult.sidedSuccess($$1.isClientSide);
        }
        return super.useOn(p_186371_);
    }
}

