/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.BitSet;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacketData;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.lighting.LevelLightEngine;

public class ClientboundLevelChunkWithLightPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundLevelChunkWithLightPacket> STREAM_CODEC = Packet.codec(ClientboundLevelChunkWithLightPacket::write, ClientboundLevelChunkWithLightPacket::new);
    private final int x;
    private final int z;
    private final ClientboundLevelChunkPacketData chunkData;
    private final ClientboundLightUpdatePacketData lightData;

    public ClientboundLevelChunkWithLightPacket(LevelChunk p_285290_, LevelLightEngine p_285254_, @Nullable BitSet p_285350_, @Nullable BitSet p_285304_) {
        ChunkPos $$4 = p_285290_.getPos();
        this.x = $$4.x;
        this.z = $$4.z;
        this.chunkData = new ClientboundLevelChunkPacketData(p_285290_);
        this.lightData = new ClientboundLightUpdatePacketData($$4, p_285254_, p_285350_, p_285304_);
    }

    private ClientboundLevelChunkWithLightPacket(RegistryFriendlyByteBuf p_319989_) {
        this.x = p_319989_.readInt();
        this.z = p_319989_.readInt();
        this.chunkData = new ClientboundLevelChunkPacketData(p_319989_, this.x, this.z);
        this.lightData = new ClientboundLightUpdatePacketData(p_319989_, this.x, this.z);
    }

    private void write(RegistryFriendlyByteBuf p_320036_) {
        p_320036_.writeInt(this.x);
        p_320036_.writeInt(this.z);
        this.chunkData.write(p_320036_);
        this.lightData.write(p_320036_);
    }

    @Override
    public PacketType<ClientboundLevelChunkWithLightPacket> type() {
        return GamePacketTypes.CLIENTBOUND_LEVEL_CHUNK_WITH_LIGHT;
    }

    @Override
    public void handle(ClientGamePacketListener p_195716_) {
        p_195716_.handleLevelChunkWithLight(this);
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public ClientboundLevelChunkPacketData getChunkData() {
        return this.chunkData;
    }

    public ClientboundLightUpdatePacketData getLightData() {
        return this.lightData;
    }
}

